# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

from influxdb_client.domain.authorization_update_request import AuthorizationUpdateRequest


class LegacyAuthorizationPostRequest(AuthorizationUpdateRequest):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'org_id': 'str',
        'user_id': 'str',
        'token': 'str',
        'permissions': 'list[Permission]',
        'status': 'str',
        'description': 'str'
    }

    attribute_map = {
        'org_id': 'orgID',
        'user_id': 'userID',
        'token': 'token',
        'permissions': 'permissions',
        'status': 'status',
        'description': 'description'
    }

    def __init__(self, org_id=None, user_id=None, token=None, permissions=None, status='active', description=None):  # noqa: E501,D401,D403
        """LegacyAuthorizationPostRequest - a model defined in OpenAPI."""  # noqa: E501
        AuthorizationUpdateRequest.__init__(self, status=status, description=description)  # noqa: E501

        self._org_id = None
        self._user_id = None
        self._token = None
        self._permissions = None
        self.discriminator = None

        if org_id is not None:
            self.org_id = org_id
        if user_id is not None:
            self.user_id = user_id
        if token is not None:
            self.token = token
        if permissions is not None:
            self.permissions = permissions

    @property
    def org_id(self):
        """Get the org_id of this LegacyAuthorizationPostRequest.

        ID of org that authorization is scoped to.

        :return: The org_id of this LegacyAuthorizationPostRequest.
        :rtype: str
        """  # noqa: E501
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Set the org_id of this LegacyAuthorizationPostRequest.

        ID of org that authorization is scoped to.

        :param org_id: The org_id of this LegacyAuthorizationPostRequest.
        :type: str
        """  # noqa: E501
        self._org_id = org_id

    @property
    def user_id(self):
        """Get the user_id of this LegacyAuthorizationPostRequest.

        ID of user that authorization is scoped to.

        :return: The user_id of this LegacyAuthorizationPostRequest.
        :rtype: str
        """  # noqa: E501
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Set the user_id of this LegacyAuthorizationPostRequest.

        ID of user that authorization is scoped to.

        :param user_id: The user_id of this LegacyAuthorizationPostRequest.
        :type: str
        """  # noqa: E501
        self._user_id = user_id

    @property
    def token(self):
        """Get the token of this LegacyAuthorizationPostRequest.

        Token (name) of the authorization

        :return: The token of this LegacyAuthorizationPostRequest.
        :rtype: str
        """  # noqa: E501
        return self._token

    @token.setter
    def token(self, token):
        """Set the token of this LegacyAuthorizationPostRequest.

        Token (name) of the authorization

        :param token: The token of this LegacyAuthorizationPostRequest.
        :type: str
        """  # noqa: E501
        self._token = token

    @property
    def permissions(self):
        """Get the permissions of this LegacyAuthorizationPostRequest.

        List of permissions for an auth.  An auth must have at least one Permission.

        :return: The permissions of this LegacyAuthorizationPostRequest.
        :rtype: list[Permission]
        """  # noqa: E501
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """Set the permissions of this LegacyAuthorizationPostRequest.

        List of permissions for an auth.  An auth must have at least one Permission.

        :param permissions: The permissions of this LegacyAuthorizationPostRequest.
        :type: list[Permission]
        """  # noqa: E501
        self._permissions = permissions

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, LegacyAuthorizationPostRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
