#!/usr/bin/perl -w

#
# langscript.plx
#
# Written by Jon Phillips, 2005. This is released into the Public Domain.
#
# This script is used to generate the language translation files for use in
# the NSIS install script. It is very general, but necessary at this time.
#
# If a language file exists in the DIR_TRANS_MASTER folder, then it gains
# preference over the DIR_TRANSLATIONS items and is copied to the 
# DIR_TRANSLATIONS folder and a new translation is not generated from the
# default language.
#
# Also, this script builds a file that can be included in an NSIS installer
# script. Thi is called FILE_LANG_INCLUDE.
#
# To turn on DEBUG MODE to get stdout messages, then set DEBUGGING to 1.
#
# TODO: Need to make the ARGV[1] to be checked if there and then add a / and 
# not have to require this...this is a really small use case.
#
# For now this script just requires both parameters passed to work.

use strict;

use File::Copy;

use constant DEBUGGING => 1;


if ( scalar @ARGV < 2 )
{
    print "You must pass in the relative path to NSI file you are using\n";
    exit 1;
}

use constant NSIS_PATH         => $ARGV[1];

use constant NSIS_FILE         => $ARGV[0];
use constant INCLUDES_DIR      => 'includes';
use constant FILE_LANG_INCLUDE => NSIS_PATH . INCLUDES_DIR . 
                                  '/language-includes.nsh';
use constant DIR_TRANS_MASTER  => 'translations-master';
use constant DIR_TRANSLATIONS  => 'translations';
use constant LANG_DEFAULT      => DIR_TRANS_MASTER."/English.nsh";

use constant COPY_WARNING      => 
    "; DO NOT EDIT THIS FILE! \n" . 
    "; Edit instead the translations-master/LANGUAGENAME.nsh file and then \n" .
    "; this script.\n\n";


# get out the files we will use from the nsi for language
my @nsis_imports;
open (F, NSIS_FILE) or die "Can't open @{[NSIS_FILE]}";

my $is_writing = 0;

my $num_nsis_lang = 0;
while ( my $buf = <F> )
{
    (last) if ( $buf =~ /\$PARSE_LANGUAGES_END\$/ );
    ($is_writing = 1) if ( $buf =~ /\$PARSE_LANGUAGES_START\$/ );
    
    (next) if ( $buf =~ /^[;\#]/ );

    if ( $is_writing )
    {
	# get rid of left whitespace: 
	$buf =~ s/^\s*//; 
	$buf =~ s/\s*$//;

        # this checks to see if the line is a comment
        (next) if ( $buf =~ /^;/ );
	
	$buf =~ s/^.*\"(.+)\"/$1/; # only get the lang. name which is filename
	chomp($buf);
        push( @nsis_imports, $buf );
        # print $buf;
        $num_nsis_lang++;
    }
}
close F;

# @nsis_file = sort( @nsis_file );

print "NUMBER OF IMPORTED LANGS IN NSIS: $num_nsis_lang\n\n" if (DEBUGGING);
# exit; 


if (-d NSIS_PATH . INCLUDES_DIR ) {
    # Delete original include file, it's output updated
    if ( -e FILE_LANG_INCLUDE )
    {
        unlink FILE_LANG_INCLUDE;
        print "Deleted @{[FILE_LANG_INCLUDE]}\n\n" if (DEBUGGING);
    }
} else {
    print "mkdir: " . NSIS_PATH . INCLUDES_DIR . "\n";
    mkdir NSIS_PATH . INCLUDES_DIR;
}



# OPEN DEFAULT LANG. AND STORE LINES FOR USE
my @default_lang;
open (F, NSIS_PATH . LANG_DEFAULT) or die "Couldn't Open";
while ( my $buf = <F> )
{
    chomp($buf);
    push(@default_lang, $buf);
}
close F;



# OPEN MASTER INCLUDE FILE FOR USE BY INSTALLER SCRIPT
open (MASTER, ">@{[FILE_LANG_INCLUDE]}") or 
    die "Can't Open @{[FILE_LANG_INCLUDE]}.";

my $num_of_langs        = 0;
my $num_of_lang_masters = 0;


#
# Check the master import list from the NSIS file and then create the 
# language files based on that. If there are more translation files in the
# translations folder, or masters folder, only those in the master NSIS 
# script will be looked for for translation.
#
#
#while ( my $file = <@{[DIR_TRANSLATIONS]}/*.nsh> )
foreach my $lang ( @nsis_imports )
{
    if ( ! -d @{[DIR_TRANSLATIONS]} ) {
	print "mkdir: " . NSIS_PATH . DIR_TRANSLATIONS . "\n" if (DEBUGGING);
        mkdir NSIS_PATH . DIR_TRANSLATIONS;
    }
    
    # $file =~ /^.*\/(.*)\.nsh/i;
    my $file = "@{[DIR_TRANSLATIONS]}/$lang.nsh";

    # $file =~ /^.*\/(.*)/i;
    my $lang_filename = "$lang.nsh";

    $lang = uc($lang);

    print "START of $lang\n" if (DEBUGGING);

    my $lang_master = DIR_TRANS_MASTER . "/$lang_filename";
    if ( -e $lang_master )
    {
        copy( $lang_master, $file ) or 
	    die "Can't copy master file to translated file";
	print "LANG MASTER EXISTS: $lang_master\n\n" if (DEBUGGING);

        print_include( $file );
	
	$num_of_lang_masters++;
	next;
    }

    print "LANG FILE NAME: $lang_filename\n" if (DEBUGGING);

    # print "$lang\n" if (DEBUGGING);
    print NSIS_PATH . "$file\n" if (DEBUGGING);



    # Open the translated file for writing
    open (F, ">" . NSIS_PATH . "$file") or die "Can't Open Translation: $file";
    print F COPY_WARNING;
    foreach my $line ( @default_lang )
    {
        $line =~ s/\$\{.*\}/\$\{LANG_$lang\}/;
        # print "$line\n";
	print F "$line\n";
        # print $buf;
    }
    close F;

    # $file =~ tr/\//\\/; # fix for windows slashes
    # my $file_fixed = substr( $file, 1, length($file) );
    # my $include_name = "!include \"$file_fixed\"\n";

    # print $include_name if (DEBUGGING);
    # print MASTER $include_name;

    print_include( $file );

    print "END of $lang\n\n" if (DEBUGGING);

    $num_of_langs++;
}
close MASTER;


if (DEBUGGING)
{
    print "Copied $num_of_lang_masters Master Translations\n";
    print "Built $num_of_langs Translations\n";

    print "\nDONE\n\n";
}

exit 0;

# FUNCTIONS

sub print_include
{
    my( $file ) = $_[0];
    
    # $file =~ tr/\//\\/; # fix for windows slashes
    # my $file_fixed = substr( $file, 1, length($file) );
    my $include_name = "!include \"$file\"\n";

    print $include_name if (DEBUGGING);
    print MASTER $include_name;

}

