# [ngIRCd](https://ngircd.barton.de) - FAQ, Tips & Tricks

# General

## Is it possible to link ngIRCd with other non-ngIRCd servers?

Yes and no. Back in the beginning (2001, 2002, ...) the server-server protocol
used by ngIRCd was compatible to the original ircd used by IRCNet at that time,
version 2.10.3p3. And most probably this is still the case today, although not
actively tested for a long time.

Please note that newer ircd versions (2.11.x) are *not* compatible any more!

And other server-server protocols were never supported.

## Is there a homepage with further information and downloads?

Yes. Please visit https://ngircd.barton.de :-)

## Why should I use ngIRCd instead of the original one?

The `README.md` file and the [homepage](https://ngircd.barton.de) list a few
advantages of ngIRCd:

- Well arranged (lean) configuration file.
- Simple to build, install, configure, and maintain.
- Supports IPv6 and SSL.
- Can use PAM for user authentication.
- Lots of popular user and channel modes are implemented.
- Supports "cloaking" of users.
- No problems with servers that have dynamic IP addresses.
- Freely available, modern, portable and tidy C source.
- Wide field of supported platforms, including AIX, A/UX, FreeBSD, HP-UX,
  IRIX, Linux, macOS, NetBSD, OpenBSD, Solaris and Windows with WSL or Cygwin.

# Building and Compilation

## The `./configure` script is missing in the source directory!?

When using sources checked out via *Git*, the `configure` script as well as the
`Makefile.in` templates must be generated using the GNU *automake*, *autoconf*
and *pkg-config* tools. To simplify this task run the `./autogen.sh` script
which will execute the required commands for you; then continue with executing
the `./configure` script as usual.

Please see the `INSTALL.md` file for details!

## Error message `aclocal: command not found`

GNU *automake* is missing on your system but required for building Git versions
of ngIRCd. Install GNU automake 1.6 or later and try again.

## Error message `autoheader: command not found`?

GNU *autoconf* is missing on your system but required for building Git versions
of ngIRCd. Install GNU autoconf 2.52 or later and try again.

## Error message `automake: configure.in: AM_INIT_AUTOMAKE must be used`?

Most probably you are using version 1.5 of GNU automake which seems to be
incompatible to the build system of ngIRCd. Solution: upgrade to at least
version 1.6 of GNU automake.

(If you are using Debian 3.0 "Woody" you can try to downgrade to version 1.4 of
GNU automake shipped with this distribution; it should work, too.)

# Troubleshooting ngIRCd Runtime Issues

Always start with:

1.  Make sure that ngIRCd parsed its configuration file as it was intended!
    Run `ngircd --configest` and double-check its output!

2.  Check the logs of your system, especially the entries generated by ngIRCd!
    Where you can find the log messages depends on your system and your setup:
    it can be plain text files in `/var/log/` (syslog) or the systemd journal
    database, for example.

3.  Ensure that the daemon started up successfully, is actually running and did
    not stop/crash in the meantime. You can check this with your service
    manager (like `systemctl status ngircd` on Linux systems using systemd) or
    using `pgrep -l ngircd` to check for "ngircd" processes. If ngIRCd is not
    running, try to restart the service and check the service status and the
    logs (syslog, systemd journal) again!

## Where is the log file stored?

See introduction to this section above :-)

## "Connection refused" errors

1.  Is the daemon really running? See introduction to this section above!

2.  Does ngIRCd listen on the correct interface(s) and port(s)? On Linux, you
    can check this with `sudo ss -ltnp|awk '/ngircd/{print $4}`, for example.
    Check your `Listen` and `Ports` settings in the `[Global]` (and `[SSL]`)
    sections and the startup messages of the daemon, especially the lines
    stating "Now listening on xxx:yyy (socket zzz)"!

3.  Are you able to connect to the ngIRCd service locally from the system the
    daemon runs on? Test all the interface IP addresses you expect ngIRCd to
    listen on, for example with a regular IRC client or tools like `telnet` or
    `nc` ("net cat"): `telnet localhost 6667`, `nc 192.168.1.2 6667`, ...

    If all the above works as expected, the issue most probably is not with
    ngIRCd or its configuration but the network layer.

4.  Are the port(s) ngIRCd listens on open and not blocked by a firewall? Check
    the logs of your firewall solution (on the server itself and all firewalls
    "in front of it") and use tools like `tcpdump` to check the network layer!

## Issues related to running ngIRCd inside of a `chroot` environment

**I cannot connect to remote peers when I use the chroot option, the following
is logged: `Can't resolve example.com: unknown error!`**

See next question blow ...

**When running ngIRCd inside a chroot, no IP addresses can be translated in DNS
names, errors like "Name or service not known" are logged!**

On Linux/glibc with chroot enabled you need to put some libraries inside
the chroot as well, notably `libnss_dns`; maybe others. Unfortunately, even
linking ngIRCd statically does not help this. So you can either copy
all the required files into the chroot directory:

``` bash
mkdir -p ./chroot/etc ./chroot/lib
cp -a /etc/hosts /etc/resolv.conf /etc/nsswitch.conf ./chroot/etc/
cp -a /lib/libresolv* /lib/libnss_* ./chroot/lib/
```

Or you can try to link ngIRCd against an other C library (like dietlibc) that do
not depend on NSS modules and these files.

# IRC Features

## I have added an `[Oper]` section, but how do I log in as an IRC operator?

You can use the `/OPER <name> <password>` command in your IRC client to become
an IRC operator as defined in an `[Oper]` block in your configuration file.

ngIRCd will also log all OPER requests (using syslog), and if an OPER command
fails you can look there to determine why it did not work (bad password,
unauthorized host mask, ...).

Please keep in mind that the "name" in the `/OPER` command is *not* related to
your nick name at all!

## I am an IRC operator, but MODE doesn't work!

By default, IRC operators are still not allowed to use `/MODE` globally.

If you set `OperCanUseMode = yes` in your configuration, then IRC operators can
use the `/MODE` command for changing modes even when they are not joined to the
specific channel.

## How can I "auto-op" users in channels?

ngIRCd can't do this: you would have to use some "IRC Services", like
[Atheme](http://atheme.net/atheme.html) or [Anope](http://www.anope.org).

See `doc/Services.txt` for setup instructions.

# Bugs!?

## Is there a list of known bugs and desired feature enhancements?

Yes. Have a look at the bug tracking system (GitHub issues) for ngIRCd located
at <https://github.com/ngircd/ngircd/issues>. There you can file bug reports and
feature requests as well as search the bug database.

## What should I do if I found a bug?

Please file a bug report at <https://github.com/ngircd/ngircd/issues/new>!
The authors will be notified automagically :-)
