<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Thiết lập tài khoản',
    'sidebar_personalization' => 'Cá nhân hóa',
    'sidebar_settings_storage' => 'Dung lượng',
    'sidebar_settings_export' => 'Xuất dữ liệu',
    'sidebar_settings_users' => 'Người dùng',
    'sidebar_settings_subscriptions' => 'Đăng ký',
    'sidebar_settings_import' => 'Nhập dữ liệu',
    'sidebar_settings_tags' => 'Quản lý tag',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'Tài nguyên DAV',
    'sidebar_settings_security' => 'Bảo mật',
    'sidebar_settings_auditlogs' => 'Nhật ký kiểm duyệt',

    'title_general' => 'Thông tin chung',
    'title_i18n' => 'Thiết lập ngôn ngữ và định dạng',
    'title_layout' => 'Giao diện',

    'me_title' => 'Thông tin liên hệ của tôi',
    'me_help' => 'Đây là liên hệ đại diện cho <em>bạn</em> trên Monica',
    'me_select' => 'Chọn 1 liên hệ',
    'me_no_contact' => 'Không có liên hệ nào được chọn.',
    'me_select_click' => 'Bấm vào đây để chọn 1 liên hệ.',
    'me_remove_contact' => 'Gỡ liên kết',
    'me_choose' => 'Chọn bản thân',
    'me_choose_placeholder' => 'Chọn bản thân',

    'export_title' => 'Xuất dữ liệu tài khoản của bạn',
    'export_be_patient' => 'Click the button to start the export. It might take several minutes to process the export – please be patient and do not spam the button.',
    'export_title_sql' => 'Export to SQL',
    'export_sql_explanation' => 'Exporting your data in SQL format allows you to take your data and import it to your own Monica instance. This is only valuable if you do have your own server.',
    'export_sql_cta' => 'Export to SQL',
    'export_sql_link_instructions' => 'Note: <a href=":url">read the instructions</a> to learn more about importing this file to your instance.',
    'export_title_json' => 'Export to Json',
    'export_submitted' => 'Your export has been submitted, it will be available in a few moment…',
    'export_json_explanation' => 'Exporting your data in Json format for backup.',
    'export_json_beta' => 'Json export is in preview mode. Tell us what you think about it:',
    'export_json_cta' => 'Export to Json',
    'export_header_type' => 'Type',
    'export_header_timestamp' => 'Creation date',
    'export_header_status' => 'Status',
    'export_header_actions' => 'Actions',
    'export_last_title' => 'Last exports',
    'export_empty_title' => 'No exports yet',
    'export_type_json' => 'Json export',
    'export_type_sql' => 'SQL export',
    'export_status_todo' => 'Submitted',
    'export_status_doing' => 'Doing',
    'export_status_done' => 'Done',
    'export_status_failed' => 'Failed',
    'export_not_done' => 'Download impossible, this export is not done yet.',

    'firstname' => 'Tên',
    'lastname' => 'Họ',
    'name_order' => 'Sắp xếp tên theo',
    'name_order_firstname_lastname' => '<Tên> <Họ> – Tèo Nguyễn',
    'name_order_lastname_firstname' => '<Họ> <Tên> – Nguyễn Tèo',
    'name_order_firstname_lastname_nickname' => '<Tên> <Họ> (<Nickname>) – Tèo Nguyễn (cu tèo)',
    'name_order_firstname_nickname_lastname' => '<Tên> (<Nickname>) <Họ> – Tèo (cu tèo) Nguyễn',
    'name_order_lastname_firstname_nickname' => '<Họ> <Tên> (<Nickname>) – Nguyễn Tèo (cu tèo)',
    'name_order_lastname_nickname_firstname' => '<Họ> (<Nickname>) <Tên> – Nguyễn (cu tèo) Tèo',
    'name_order_nickname_firstname_lastname' => '<Nickname> (<Tên> <Họ>) – cu tèo (Tèo Nguyễn)',
    'name_order_nickname_lastname_firstname' => '<Nickname> (<Họ> <Tên>) – cu tèo (Nguyễn Tèo)',
    'name_order_nickname' => '<Nickname> – cu tèo',
    'currency' => 'Tiền tệ',
    'name' => 'Tên bạn: :name',
    'email' => 'Địa chỉ email',
    'email_placeholder' => 'Nhập email',
    'email_help' => 'Đây là email dùng để đăng nhập, và là nơi bạn sẽ nhận các thông báo nhắc nhở.',
    'timezone' => 'Múi giờ',
    'temperature_scale' => 'Thang đo nhiệt độ',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (°C)',
    'layout' => 'Giao diện',
    'layout_small' => 'Chiều rộng tối đa 1200 pixel',
    'layout_big' => 'Toàn bộ chiều rộng trình duyệt',
    'save' => 'Cập nhật tùy chọn',
    'delete_title' => 'Xóa tài khoản',
    'delete_desc' => 'Bạn có muốn xóa tài khoản của bạn? Việc xóa không thể khôi phục và tất cả dữ liệu của bạn sẽ biến mất vĩnh viễn. Nếu bạn có gói thuê bao, nó sẽ bị hủy ngay lập túc.',
    'delete_other_desc' => 'Your data in the main database will be deleted immediately. As described in our privacy policy, we carry out securely encrypted backups of the database every day.  These backups are kept for 30 days after which they are completely deleted. We cannot delete specific data from the backups we hold any earlier than this.  All of your data will be completely deleted no later than 31 days after your account’s deletion.',
    'reset_desc' => 'Bạn chắc chắn muốn cài đặt lại tài khoản? Tất cả liên hệ và dữ liệu liên quan sẽ bị xóa. Tài khoản của bạn sẽ không bị xóa.',
    'reset_title' => 'Cài đặt lại tài khoản của bạn',
    'reset_cta' => 'Cài đặt lại tài khoản',
    'reset_notice' => 'Bạn chắc chắn muốn cài đặt lại tài khoản? Hành động này không thể hoàn tác.',
    'reset_success' => 'Cài đặt lại tài khoản thành công.',
    'delete_notice' => 'Bạn chắc chắn muốn xóa tài khoản? Hành động này không thể hoàn tác. Tất cả dữ liệu của bạn sẽ bị xóa và không thể khôi phục.',
    'delete_cta' => 'Xoá tài khoản',
    'settings_success' => 'Đã cập nhật Tùy Chọn!',
    'locale' => 'Ngôn ngữ',
    'locale_help' => 'Bạn có muốn hỗ trợ dịch Monica hoặc thêm ngôn ngữ mới? Hãy theo dõi <a href=":url" target="_blank" lang="en">thêm thông tin ở liên kết này</a>.',
    'locale_ar' => 'Tiếng Ả Rập',
    'locale_cs' => 'Tiếng Séc',
    'locale_de' => 'Tiếng Đức',
    'locale_el' => 'Tiếng Hy Lạp',
    'locale_en' => 'Tiếng Anh',
    'locale_en-GB' => 'Tiếng Anh (Vương Quốc Anh)',
    'locale_es' => 'Tiếng Tây Ban Nha',
    'locale_fr' => 'Tiếng Pháp',
    'locale_he' => 'Tiếng Do Thái',
    'locale_hr' => 'Tiếng Croatia',
    'locale_id' => 'Tiếng Indonesia',
    'locale_it' => 'Tiếng Ý',
    'locale_ja' => 'Tiếng Nhật',
    'locale_nl' => 'Tiếng Hà Lan',
    'locale_pt' => 'Tiếng Bồ Đào Nha',
    'locale_pt-BR' => 'Tiếng Bồ Đào Nha (Brazil)',
    'locale_ru' => 'Tiếng Nga',
    'locale_sv' => 'Tiếng Thụy Điển',
    'locale_vi' => 'tiếng Việt',
    'locale_zh' => 'Tiếng Trung Giản thể',
    'locale_zh-TW' => 'Tiếng Trung phồn thể',
    'locale_tr' => 'Tiếng Thổ Nhĩ Kỳ',

    'security_title' => 'Bảo mật',
    'security_help' => 'Thay đổi các vấn đề bảo mật cho tài khoản của bạn.',
    'password_change' => 'Đổi mật khẩu',
    'password_current' => 'Mật khẩu hiện tại',
    'password_current_placeholder' => 'Nhập mật khẩu hiện tại',
    'password_new1' => 'Mật khẩu mới',
    'password_new1_placeholder' => 'Nhập mật khẩu mới',
    'password_new2' => 'Xác nhận mật khẩu mới',
    'password_new2_placeholder' => 'Nhập lại mật khẩu mới',
    'password_btn' => 'Đổi mật khẩu',
    '2fa_title' => 'Xác minh 2 bước',
    '2fa_otp_title' => 'Ứng dụng mobile xác thực 2 yếu tố',
    '2fa_enable_title' => 'Bật xác thực 2 bước',
    '2fa_enable_description' => 'Bật xác thực 2 yếu tố để nâng cao bảo mật cho tài khoản của bạn.',
    '2fa_enable_otp' => 'Mở ứng dụng điện thoại xác thực 2 yếu tố và quét mã QR dưới đây:',
    '2fa_enable_otp_help' => 'Nếu ứng dụng xác thực 2 yếu tố của bạn không hỗ trợ QR code, nhập mã dưới đây:',
    '2fa_enable_otp_validate' => 'Hãy xác nhận thiết bị mới bạn vừa thiết lập:',
    '2fa_enable_success' => 'Đã kích hoạt xác thực 2 yếu tố',
    '2fa_enable_error' => 'Có lỗi khi thử kích hoạt xác thực 2 yếu tố',
    '2fa_enable_error_already_set' => 'Xác thực 2 yếu tố đã được kích hoạt trước đó',
    '2fa_disable_title' => 'Vô hiệu xác thực 2 yếu tố',
    '2fa_disable_description' => 'Vô hiệu hóa xác thực 2 yếu tố cho tài khoản của bạn. Hãy cẩn thận, tài khoản của bạn sẽ kém bảo mật hơn!',
    '2fa_disable_success' => 'Đã vô hiệu xác thực 2 yếu tố',
    '2fa_disable_error' => 'Có lỗi khi thử kích hoạt xác thực 2 yếu tố',

    'webauthn_title' => 'Khoá bảo mật — giao thức WebAuthn',
    'webauthn_enable_description' => 'Thêm khóa bảo mật mới',
    'webauthn_key_name_help' => 'Đặt tên cho khoá bảo mật.',
    'webauthn_key_name' => 'Tên khoá:',
    'webauthn_success' => 'Khóa của bạn đã được phát hiện và xác thực.',
    'webauthn_last_use' => 'Lần sử dụng gần đây: {timestamp}',
    'webauthn_delete_confirmation' => 'Bạn chắc chắn muốn xóa key này?',
    'webauthn_delete_success' => 'Đã xóa key',
    'webauthn_insertKey' => 'Lắp khóa bảo mật của bạn.',
    'webauthn_buttonAdvise' => 'Nếu khóa bảo mật có nút, hãy chạm vào.',
    'webauthn_noButtonAdvise' => 'Nếu nó không có, tháo ra và cắm lại.',
    'webauthn_not_supported' => 'Trình duyệt của bạn không hỗ trợ WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn chỉ hỗ trợ kết nối bảo mật. Hãy tải lại trang với giao thức https.',
    'webauthn_error_already_used' => 'Khóa này đã được đăng kí. Không cần thiết đăng kí lại.',
    'webauthn_error_not_allowed' => 'Hoạt động đã hết thời gian chờ hoặc không được phép.',

    'recovery_title' => 'Mã khôi phục',
    'recovery_show' => 'Tạo mã khôi phục',
    'recovery_copy_help' => 'Sao chép mã vào clipboard',
    'recovery_help_intro' => 'Đây là mã khôi phục của bạn:',
    'recovery_help_information' => 'Bạn có thể sử dụng mỗi mã khôi phục một lần.',
    'recovery_clipboard' => 'Đã sao chép mã vào bộ nhớ tạm.',
    'recovery_generate' => 'Tạo mã mới…',
    'recovery_generate_help' => 'Khởi tạo bộ mã mới sẽ vô hiệu các bộ mã đã khởi tạo trước đây.',
    'recovery_already_used_help' => 'Mã này đã được sử dụng.',

    'users_list_title' => 'Người dùng với quyền truy cập tài khoản của bạn',
    'users_list_add_user' => 'Mời người dùng mới',
    'users_list_you' => 'Bạn',
    'users_list_invitations_title' => 'Lời mời đang chờ',
    'users_list_invitations_explanation' => 'Dưới đây là những người bạn đã mời tham gia Monica với tư cách cộng tác viên.',
    'users_list_invitations_invited_by' => 'đã được mời bởi :name',
    'users_list_invitations_sent_date' => 'gửi vào :date',
    'users_blank_title' => 'Bạn là người duy nhất truy cập vào tài khoản này.',
    'users_blank_add_title' => 'Bạn có muốn mời thêm ai khác?',
    'users_blank_description' => 'Người này sẽ có cùng quyền truy cập mà bạn có và có thể thêm, chỉnh sửa hoặc xóa thông tin liên hệ.',
    'users_blank_cta' => 'Mời một ai đó',
    'users_add_title' => 'Mời người dùng mới cho tài khoản của bạn bằng email',
    'users_add_description' => 'Người này sẽ có quyền truy cập giống như bạn, bao gồm cả việc mời hoặc xóa những người dùng khác, bao gồm cả bạn. Đảm bảo rằng bạn tin tưởng người này trước khi cấp cho họ quyền truy cập.',
    'users_add_email_field' => 'Nhập email của người bạn muốn mời',
    'users_add_confirmation' => 'Tôi xác nhận rằng tôi muốn mời người dùng này vào tài khoản của tôi. Tôi hiểu rằng người này sẽ được truy cập vào TẤT CẢ dữ liệu của tôi và xem được chính xác những gì tôi đang thấy.',
    'users_add_cta' => 'Mời bằng email',
    'users_accept_title' => 'Chấp nhận lời mời và tạo tài khoản mới',
    'users_error_please_confirm' => 'Hãy xác nhận rằng bạn muốn mời người dùng này trước khi tiếp tục với lời mời',
    'users_error_email_already_taken' => 'Email này đã được sử dụng. Vui lòng chọn email khác',
    'users_error_already_invited' => 'Bạn đã mời người dùng này trước đó. Hãy chọn địa chỉ email khác.',
    'users_error_email_not_similar' => 'Đây không phải email của người đã mời bạn.',
    'users_invitation_deleted_confirmation_message' => 'Đã xóa lời mời thành công',
    'users_invitations_delete_confirmation' => 'Bạn có chắc muốn xóa lời mời này?',
    'users_list_delete_confirmation' => 'Bạn chắc chắn muốn xóa người dùng này khỏi tài khoản của bạn?',
    'users_invitation_need_subscription' => 'Cần gói thuê bao để thêm người dùng mới.',

    'subscriptions_account_current_plan' => 'Gói hiện tại',
    'subscriptions_account_current_legacy' => 'Current plan, not selectable anymore:',
    'subscriptions_account_current_paid_plan' => 'Bạn đang dùng gói :name. Cảm ơn bạn vì đã đăng kí thuê bao.',

    'subscriptions_account_next_billing_title' => 'Next bill',
    'subscriptions_account_next_billing' => 'Thuê bao của bạn sẽ tự động thanh toán vào <strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'We’ll bill you <strong>:price</strong> for another <strong>month</strong>.',
    'subscriptions_account_bill_annual' => 'We’ll bill you <strong>:price</strong> for another <strong>year</strong>.',
    'subscriptions_account_change' => 'Change plan',

    'subscriptions_account_cancel_title' => 'Cancel subscription',
    'subscriptions_account_cancel_action' => 'Cancel subscription',
    'subscriptions_account_cancel' => 'You can cancel your subscription at any time.',
    'subscriptions_account_free_plan' => 'Bạn đang dùng gói miễn phí.',
    'subscriptions_account_free_plan_upgrade' => 'Bạn có thể nâng cấp tài khoản của bạn lên gói :name, chi phí $:price mỗi tháng. Đây là những lợi ích:',
    'subscriptions_account_free_plan_benefits_users' => 'Không giới hạn số lượng người dùng',
    'subscriptions_account_free_plan_benefits_reminders' => 'Nhắc nhở bằng email',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Nhập danh bạ của bạn với vCard',
    'subscriptions_account_free_plan_benefits_support' => 'Hỗ trợ dự án có thể vận hành lâu dài, khi đó chúng tôi có thể giới thiệu nhiều tính năng tuyệt vời hơn.',
    'subscriptions_account_upgrade' => 'Nâng cấp tài khoản của bạn',
    'subscriptions_account_upgrade_title' => 'Nâng cấp Monica hôm nay và có thêm nhiều mối quan hệ ý nghĩa.',
    'subscriptions_account_upgrade_choice' => 'Chọn gói dưới đây và gia nhập hội :customers đã nâng cấp Monica.',
    'subscriptions_account_update_title' => 'Update Monica subscription',
    'subscriptions_account_update_description' => 'You can change your subscription’s frequency here.',
    'subscriptions_account_update_information' => 'You will be billed immediately for the new amount. Your subscription will extend to the new period, depending on your choice.',
    'subscriptions_account_invoices' => 'Hoá đơn',
    'subscriptions_account_invoices_download' => 'Tải xuống',
    'subscriptions_account_invoices_subscription' => 'Gói thuê bao từ :startDate đến :endDate',
    'subscriptions_account_payment' => 'Tùy chọn thanh toán nào phù hợp với bạn?',
    'subscriptions_account_confirm_payment' => 'Việc thanh toán của bạn chưa hoàn thành, hãy <a href=":url">xác nhận thanh toán của bạn</a>.',
    'subscriptions_downgrade_title' => 'Hạ cấp tài khoản xuống gói miễn phí',
    'subscriptions_downgrade_limitations' => 'Gói miễn phí bị giới hạn. Để có thể hạ cấp, bạn phải thỏa mãn các điều kiện dưới đây:',
    'subscriptions_downgrade_rule_users' => 'Bạn chỉ được có 1 người dùng trong tài khoản của bạn',
    'subscriptions_downgrade_rule_users_constraint' => 'Bạn đang có <a href=":url">1 người dùng</a> trong tài khoản.|Bạn đang có <a href=":url">:count người dùng</a> trong tài khoản.',
    'subscriptions_downgrade_rule_invitations' => 'Bạn không được phép có lời mời đang chờ nào',
    'subscriptions_downgrade_rule_invitations_constraint' => 'Hiện tại bạn đang có <a href=":url">1 lời mời đang chờ</a>.|Hiện tại bạn đang có <a href=":url">:count lời mời đang chờ</a>.',
    'subscriptions_downgrade_rule_contacts' => 'Bạn không được có nhiều hơn :number liên hệ đang hoạt động',
    'subscriptions_downgrade_rule_contacts_constraint' => 'Hiện tại bạn đang có <a href=":url">:count liên hệ</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'We can also <a href=":url">archive all your contacts for you</a> – that would clear this rule and let you proceed with your account’s downgrade process.',
    'subscriptions_downgrade_cta' => 'Hạ cấp',
    'subscriptions_downgrade_success' => 'Bạn đã trở lại gói miễn phí!',
    'subscriptions_downgrade_thanks' => 'Thanks so much for trying the paid plan. We keep adding new features on Monica all the time – so you might want to come back in the future to see if you might be interested in taking a subscription again.',
    'subscriptions_back' => 'Quay lại cài đặt',
    'subscriptions_upgrade_title' => 'Nâng cấp tài khoản của bạn',
    'subscriptions_upgrade_choose' => 'Bạn đã chọn gói :plan.',
    'subscriptions_upgrade_infos' => 'Chúng tôi không thể vui sướng hơn. Hãy nhập thông tin thanh toán dưới đây.',
    'subscriptions_upgrade_name' => 'Tên trên thẻ',
    'subscriptions_upgrade_zip' => 'Mã bưu chính',
    'subscriptions_upgrade_credit' => 'Thẻ tín dụng',
    'subscriptions_upgrade_submit' => 'Thanh toán {amount}',
    'subscriptions_upgrade_charge' => 'Chúng tôi sẽ tính phí :price vào thẻ của bạn bây giờ. Lần tính phí tiếp theo vào :date. Nếu bạn muốn thay đổi, bạn có thể hủy bất cứ lúc nào, không cần hỏi.',
    'subscriptions_upgrade_charge_handled' => 'Việc thanh toán được xử lý bởi <a href=":url">Stripe</a>. Chúng tôi không lưu trữ thông tin thẻ.',
    'subscriptions_upgrade_success' => 'Cảm ơn! Bây giờ bạn đã đăng kí thuê bao.',
    'subscriptions_upgrade_thanks' => 'Chào mừng bạn đến cộng đồng những người muốn làm thế giới tốt đẹp hơn.',

    'subscriptions_payment_confirm_title' => 'Xác nhận thanh toán :amount',
    'subscriptions_payment_confirm_information' => 'Xác thục bổ sung là cần thiết để tiến hành thanh toán. Hãy xác thực thanh toán bằng cách điền thông tin thanh toán bên dưới.',
    'subscriptions_payment_succeeded_title' => 'Thanh toán thành công',
    'subscriptions_payment_succeeded' => 'Bạn đã xác thực thanh toán thành công.',
    'subscriptions_payment_cancelled_title' => 'Thanh toán bị hủy',
    'subscriptions_payment_cancelled' => 'Thanh toán đã bị hủy.',
    'subscriptions_payment_error_name' => 'Hãy nhập tên bạn.',
    'subscriptions_payment_success' => 'Thanh toán thành công.',

    'subscriptions_pdf_title' => 'Gói thuê bao :name hàng tháng của bạn',
    'subscriptions_plan_frequency_year' => ':amount / year',
    'subscriptions_plan_frequency_month' => ':amount / month',
    'subscriptions_plan_choose' => 'Chọn gói',
    'subscriptions_plan_year_title' => 'Thanh toán hàng năm',
    'subscriptions_plan_year_bonus' => 'An tâm cả năm',
    'subscriptions_plan_month_title' => 'Thanh toán hàng tháng',
    'subscriptions_plan_month_bonus' => 'Hủy bất cứ lúc nào',
    'subscriptions_plan_include1' => 'Đi kèm với nâng cấp của bạn:',
    'subscriptions_plan_include2' => 'Không giới hạn số lượng liên hệ • Không giới hạn số lượng người dùng • Nhắc nhờ bằng email • Nhập với vCard • Cá nhân hóa bảng liên hệ',
    'subscriptions_plan_include3' => '100% lợi nhuận dành cho việc phát triển dự án mã nguồn mở này.',
    'subscriptions_help_title' => 'Các thông tin bổ sung mà bạn có thể hứng thú',
    'subscriptions_help_opensource_title' => 'Dự án mã nguồn mở là gì?',
    'subscriptions_help_opensource_desc' => 'Monica là dự án mã nguồn mở. Điều đó tức là nó được xây dựng bởi cộng đồng những người muốn xây dựng công cụ cho những điều tốt đẹp. Trở thành mã nguồn mở nghĩa là mã nguồn được công khai trên GitHub, và mọi người có thể xem, sửa và tối ưu nó. Tất cả số tiền chúng tôi quyên góp được dành để xây dựng các tính năng tốt hơn, trả tiền cho các máy chủ mạnh hơn và trả các chi phí khác. Cảm ơn bạn đã giúp đỡ. Chúng tôi không thể làm điều đó nếu không có bạn.',
    'subscriptions_help_limits_title' => 'Có giới hạn số lượng liên hệ trong gói miễn phí không?',
    'subscriptions_help_limits_plan' => 'Có. Gói miễn phí cho phép bạn quản lý :number liên hệ.',
    'subscriptions_help_discounts_title' => 'Bạn có mã giảm giá nào cho tổ chức phi lợi nhuận và giáo dục không?',
    'subscriptions_help_discounts_desc' => 'Chúng tôi có! Monica miễn phí cho sinh viên, tổ chức phi lợi nhuận và từ thiện. Hãy liên hệ <a href=":support">đội hỗ trợ</a> với bằng chứng về tình trạng của bạn và chúng tôi sẽ áp dụng trạng thái đặc biệt cho tài khoản của bạn.',
    'subscriptions_help_change_title' => 'Nếu tôi đổi ý thì sao?',
    'subscriptions_help_change_desc' => 'Bạn có thể hủy bất cứ lúc nào, không cần hỏi, mọi thứ được làm bởi chính bạn - không cần liên hệ hỗ trợ. Tuy nhiên, bạn sẽ không được hoàn lại tiền cho giai đoạn hiện tại.',

    'stripe_error_card' => 'Thẻ của bạn bị từ chối. Tin nhắn từ chối là: :message',
    'stripe_error_api_connection' => 'Kết nối mạng với Stripe bị lỗi. Hãy thử lại.',
    'stripe_error_rate_limit' => 'Hiện tại đang có quá nhiều yêu cầu đến Stripe. Hãy thử lại sau.',
    'stripe_error_invalid_request' => 'Thông số không hợp lệ. Hãy thử lại sau.',
    'stripe_error_authentication' => 'Sai thông tin xác thực với Stripe',

    'import_title' => 'Nhập danh bạ vào tài khoản của bạn',
    'import_cta' => 'Tải lên danh bạ',
    'import_stat' => 'Bạn đã nhập :number tệp từ trước đến giờ.',
    'import_result_stat' => 'Đã tải lên vCard với 1 liên hệ (đã nhập :total_imported, đã bỏ qua :total_skipped)',
    'import_view_report' => 'Xem báo cáo',
    'import_in_progress' => 'Đang xử lý việc nhập. Tải lại trang trong một phút.',
    'import_upload_title' => 'Nhập danh bạ của bạn với vCard',
    'import_upload_rules_desc' => 'Tuy nhiên, chúng tôi có một số quy tắc:',
    'import_upload_rule_format' => 'Chúng tôi hỗ trợ tệp <code>.vcard</code> và <code>.vcf</code>.',
    'import_upload_rule_vcard' => 'Chúng tôi hỗ trợ định dạng vCard 3.0 format, là định dạng mặc định của macOS’s Contacts.app và Google Contacts.',
    'import_upload_rule_instructions' => 'Hướng dẫn xuất dữ liệu cho <a href=":url1" target="_blank" rel="noopener noreferrer">macOS Contacts.app</a> và <a href=":url2" target="_blank" rel="noopener noreferrer">Google Contacts</a>.',
    'import_upload_rule_multiple' => 'Nếu liên hệ của bạn có nhiều địa chỉ email hoặc số điện thoại, chỉ có mục đầu tiên sẽ được lưu.',
    'import_upload_rule_limit' => 'Tệp giới hạn tới 10MB.',
    'import_upload_rule_time' => 'Có thể mất tới vài phút để tải lên danh bạ và xử lý chúng. Vui lòng đợi.',
    'import_upload_rule_cant_revert' => 'Hãy chắc chắn dữ liệu chính xác trước khi tải lên, bạn không thể hủy tiến trình tải lên.',
    'import_upload_form_file' => 'Tệp <code>.vcf</code> hoặc <code>.vCard</code> của bạn:',
    'import_upload_behaviour' => 'Import behaviour:',
    'import_upload_behaviour_add' => 'Thêm liên hệ mới và bỏ qua liên hệ đã tồn tại',
    'import_upload_behaviour_replace' => 'Thay thế liên hệ đã tồn tại',
    'import_upload_behaviour_help' => 'Việc thay thế sẽ thay thế toàn bộ dữ liệu tồn tại trong vCard, nhưng vẫn giữ các trường liên hệ đã tồn tại.',
    'import_report_title' => 'Báo cáo nhập',
    'import_report_date' => 'Ngày nhập',
    'import_report_type' => 'Kiểu nhập',
    'import_report_number_contacts' => 'Số lượng liên hệ trong tệp',
    'import_report_number_contacts_imported' => 'Số lượng danh bạ đã nhập',
    'import_report_number_contacts_skipped' => 'Số lượng danh bạ đã bỏ qua',
    'import_report_status_imported' => 'Đã nhập',
    'import_report_status_skipped' => 'Đã bỏ qua',
    'import_vcard_parse_error' => 'Lỗi khi phân tích mục vCard',
    'import_vcard_contact_exist' => 'Liên hệ đã tồn tại',
    'import_vcard_contact_no_firstname' => 'Không có tên (bắt buộc)',
    'import_vcard_file_not_found' => 'Tệp không tồn tại',
    'import_vcard_unknown_entry' => 'Tên liên hệ không xác định',
    'import_vcard_file_no_entries' => 'Tệp không chứa mục nào',
    'import_blank_title' => 'Bạn chưa nhập bất kì liên hệ nào.',
    'import_blank_question' => 'Bạn có muốn nhập liên hệ ngay bây giờ?',
    'import_blank_description' => 'Chúng tôi có thể nhập tệp vCard bạn lấy từ Google Contacts hoặc ứng dụng quản lý Danh bạ của bạn.',
    'import_blank_cta' => 'Nhập file vCard',
    'import_need_subscription' => 'Việc nhập dữ liệu yêu cầu gói thuê bao.',

    'tags_list_title' => 'Nhãn',
    'tags_list_description' => 'Bạn có thể sắp xếp liên hệ bằng cách thiết lập nhãn. Nhãn hoạt động giống thư mục, nhưng bạn có thể thêm nhiều nhãn vào một liên hệ. Để thêm nhãn mới, thêm nó ở trang liên hệ.',
    'tags_list_contact_number' => ':count liên hệ',
    'tags_list_delete_success' => 'The tag has been successfully deleted',
    'tags_list_edit_success' => 'The tag has been successfully updated',
    'tags_list_delete_confirmation' => 'Are you sure you want to delete the tag? No contacts will be deleted, only the tag.',
    'tags_blank_title' => 'Tag là một cách tốt để phân loại liên hệ của bạn.',
    'tags_blank_description' => 'Tag hoạt động như một thư mục, nhưng bạn có thể thêm nhiều tag vào một liên hệ. Truy cập trang liên hệ và thêm tag bạn bè, ngay dưới phần tên. Khi liên hệ được gắn tag, quay trở lại đây và quản lý tất cả tag trong tài khoản của bạn.',

    'api_title' => 'Khoá truy cập API',
    'api_description' => 'API có thể dùng để tương tác với dữ liệu của Monica từ ứng dụng bên ngoài, như app điện thoại.',
    'api_help' => 'Để sử dụng API, phải có một token. Bạn có thể tạo một token truy cập cá nhân (Bearer authentication), hoặc xác thực qua OAuth client để tạo nó cho bạn. Xem <a href=":url">tài liệu API</a>.',
    'api_endpoint' => 'Đường dẫn đích API cho Monica là:',

    'api_personal_access_tokens' => 'Mã token truy cập cá nhân',
    'api_pao_description' => 'Chắc chắn rằng bạn chỉ cấp quyền truy cập token này cho nguồn mà bạn tin tưởng - vì chúng cho phép truy cập tất cả dữ liệu của bạn.',
    'api_token_title' => 'Mã truy cập cá nhân',
    'api_token_create_new' => 'Tạo token mới',
    'api_token_not_created' => 'Bạn chưa tạo bất kỳ mã truy cập cá nhân nào.',
    'api_token_name' => 'Tên token',
    'api_token_expire' => 'Hết hạn vào {date}',
    'api_token_delete' => 'Xóa',
    'api_token_create' => 'Tạo Token',
    'api_token_scopes' => 'Phạm vi',
    'api_token_help' => 'Here is your new personal access token. This is the only time it will be shown so don’t lose it! You may now use this token to make API requests.',

    'api_oauth_clients' => 'OAuth client của bạn',
    'api_oauth_clients_desc' => 'Mục này cho phép bạn đăng kí OAuth client của bạn.',
    'api_oauth_clients_desc2' => 'Dùng client id để yêu cầu token mới, và chuyển đổi mã xác thực sang mã token truy cập. Xem <a href="{url}">tài liệu Laravel Passport</a> để biết thêm thông tin.',
    'api_oauth_title' => 'OAuth Clients',
    'api_oauth_create_new' => 'Tạo mới Client',
    'api_oauth_edit' => 'Sửa Client',
    'api_oauth_not_created' => 'Bạn không có bất kì OAuth client nào.',
    'api_oauth_clientid' => 'Client ID',
    'api_oauth_name' => 'Tên',
    'api_oauth_name_help' => 'Một cái gì đó người dùng của bạn sẽ nhận ra và tin tưởng.',
    'api_oauth_secret' => 'Mã bí mật',
    'api_oauth_create' => 'Tạo Client',
    'api_oauth_redirecturl' => 'URL chuyển tiếp',
    'api_oauth_redirecturl_help' => 'URL gọi lại ủy quyền của ứng dụng của bạn.',

    'api_authorized_clients' => 'Danh sách client được ủy quyền',
    'api_authorized_clients_desc' => 'Mục này liệt kê tất cả client bạn đã cấp quyền truy cập dữ liệu ứng dụng của bạn. Bạn có thể hủy quyền bất kì lúc nào.',
    'api_authorized_clients_title' => 'Ứng dụng được ủy quyền',
    'api_authorized_clients_none' => 'Không có client nào được cấp quyền.',
    'api_authorized_clients_name' => 'Tên',
    'api_authorized_clients_scopes' => 'Phạm vi',

    'personalization_tab_title' => 'Cá nhân hóa tài khoản',

    'personalization_title' => 'Here you will find different settings to configure your account. These features are intended for “power users” who want maximum control over Monica.',
    'personalization_contact_field_type_title' => 'Loại trường liên hệ',
    'personalization_contact_field_type_add' => 'Thêm loại trường mới',
    'personalization_contact_field_type_description' => 'You can configure all the different types of contact fields that you can associate to all your contacts. For example, if a new social network appears in the future, you will be able to add this new way of communicating with your contacts right here.',
    'personalization_contact_field_type_table_name' => 'Tên',
    'personalization_contact_field_type_table_protocol' => 'Giao thức',
    'personalization_contact_field_type_table_actions' => 'Hành động',
    'personalization_contact_field_type_modal_title' => 'Add a new contact field type',
    'personalization_contact_field_type_modal_edit_title' => 'Edit an existing contact field type',
    'personalization_contact_field_type_modal_delete_title' => 'Delete an existing contact field type',
    'personalization_contact_field_type_modal_delete_description' => 'Are you sure you want to delete this contact field type? Deleting this type of contact field will delete ALL the data with this type for all of your contacts.',
    'personalization_contact_field_type_modal_name' => 'Tên',
    'personalization_contact_field_type_modal_protocol' => 'Giao thức (tùy chọn)',
    'personalization_contact_field_type_modal_protocol_help' => 'Each new contact field type can be clickable. If a protocol is set, we will use it to trigger the action that is set.',
    'personalization_contact_field_type_modal_icon' => 'Icon (tùy chọn)',
    'personalization_contact_field_type_modal_icon_help' => 'Bạn có thể gắn icon với loại trường liên hệ này. Bạn cần thêm chỉ dẫn tới Font Awesome icon.',
    'personalization_contact_field_type_delete_success' => 'Xóa loại trường liên hệ thành công.',
    'personalization_contact_field_type_add_success' => 'Thêm loại trường liên hệ thành công.',
    'personalization_contact_field_type_edit_success' => 'Cập nhật loại trường liên hệ thành công.',

    'personalization_genders_title' => 'Loại giới tính',
    'personalization_genders_add' => 'Thêm loại giới tính mới',
    'personalization_genders_desc' => 'Bạn có thể định nghĩa bao nhiêu giới tính cũng được. Bạn cần tối thiểu 1 loại giới tính trong tài khoản của bạn.',
    'personalization_genders_modal_add' => 'Thêm loại giới tính',
    'personalization_genders_modal_edit' => 'Cập nhật loại giới tính',
    'personalization_genders_modal_name' => 'Tên',
    'personalization_genders_modal_name_help' => 'Tên sẽ được dùng hiển thị giới tính trên trang liên hệ.',
    'personalization_genders_modal_sex' => 'Giới tính',
    'personalization_genders_modal_sex_help' => 'Sử dụng để định nghĩa mối quan hệ, và trong quá trình nhập/xuất vCard.',
    'personalization_genders_modal_default' => 'Chọn giới tính mặc định cho liên hệ mới',
    'personalization_genders_modal_delete' => 'Xóa loại giới tính',
    'personalization_genders_modal_delete_desc' => 'Bạn chắc chắn muốn xóa giới tính "{name}"?',
    'personalization_genders_modal_delete_question' => 'Hiện bạn đang có {count} liên hệ với giới tính này. Nếu bạn xóa giới tính này, giới tính nào các liên hệ sẽ sở hữu?',
    'personalization_genders_modal_delete_question_default' => 'Giới tính này đang được đặt là mặc định. Nếu bạn xóa giới tính này, cái nào sẽ được đặt làm mặc định?',
    'personalization_genders_modal_error' => 'Hãy chọn giới tính trong danh sách.',
    'personalization_genders_list_contact_number' => '{count} liên hệ',
    'personalization_genders_table_name' => 'Tên',
    'personalization_genders_table_sex' => 'Giới tính',
    'personalization_genders_table_default' => 'Mặc định',
    'personalization_genders_default' => 'Giới tính mặc định',
    'personalization_genders_make_default' => 'Đổi giới tính mặc định',
    'personalization_genders_select_default' => 'Chọn giới tính mặc định',
    'personalization_genders_m' => 'Nam',
    'personalization_genders_f' => 'Nữ',
    'personalization_genders_o' => 'Khác',
    'personalization_genders_u' => 'Không rõ',
    'personalization_genders_n' => 'Không có hoặc không áp dụng',

    'personalization_reminder_rule_save' => 'Đã lưu thay đổi',
    'personalization_reminder_rule_title' => 'Quy tắc nhắc nhở',
    'personalization_reminder_rule_line' => 'trước {count} ngày',
    'personalization_reminder_rule_desc' => 'Với mỗi nhắc nhở bạn cài, Monica có thể gửi email cho bạn vào x ngày trước khi sự kiện xảy ra. Bạn có thể điều chỉnh cài đặt thông báo ở đây. Thông báo này chỉ áp dụng cho lời nhắc hàng tháng và hàng năm.',

    'personalization_module_save' => 'Đã lưu thay đổi',
    'personalization_module_title' => 'Tính năng',
    'personalization_module_desc' => 'Có thể bạn không cần dùng tất cả tính năng của Monica. Phần dưới đây cho phép bạn bật/tắt tính năng sử dụng trong khung liên hệ. Thay đổi này sẽ ảnh hưởng đến TẤT CẢ liên hệ của bạn. Tắt tính năng không xóa dữ liệu, chỉ ẩn tính năng này đi.',

    'personalisation_paid_upgrade' => 'Đây là tính năng nâng cao cần thuê bao trả phí để kích hoạt. Hãy nâng cấp tài khoản của bạn bằng cách truy cập <a href=":url">Cài đặt > Gói thuê bao</a>.',
    'personalisation_paid_upgrade_vue' => 'Đây là tính năng nâng cao cần thuê bao trả phí để kích hoạt. Hãy nâng cấp tài khoản của bạn bằng cách truy cập <a href="{url}">Cài đặt > Gói thuê bao</a>.',

    'reminder_time_to_send' => 'Thời gian lời nhắc sẽ được gửi',
    'reminder_time_to_send_help' => 'Lời nhắc tiếp theo của bạn được lên lịch gửi vào <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'Danh mục loại hoạt động',
    'personalization_activity_type_category_add' => 'Thêm danh mục',
    'personalization_activity_type_category_table_name' => 'Tên',
    'personalization_activity_type_category_description' => 'An activity with one of your contacts can have a type and a category type. Your account comes with a set of predefined category types by default, but you can customize these here.',
    'personalization_activity_type_category_table_actions' => 'Hành động',
    'personalization_activity_type_category_modal_add' => 'Thêm danh mục',
    'personalization_activity_type_category_modal_edit' => 'Sửa danh mục',
    'personalization_activity_type_category_modal_question' => 'Chúng ta nên đặt tên cho danh mục này là gì?',
    'personalization_activity_type_add_button' => 'Thêm loại hoạt động mới',
    'personalization_activity_type_modal_add' => 'Thêm loại hoạt động mới',
    'personalization_activity_type_modal_question' => 'Chúng ta nên đặt tên cho hoạt động này là gì?',
    'personalization_activity_type_modal_edit' => 'Sửa loại hoạt động',
    'personalization_activity_type_category_modal_delete' => 'Xóa danh mục',
    'personalization_activity_type_category_modal_delete_desc' => 'Bạn chắc chắn muốn xóa danh mục này? Việc này sẽ xóa tất cả loại hoạt động bên trong. Hoạt động gắn với danh mục này không bị ảnh hưởng.',
    'personalization_activity_type_modal_delete' => 'Xóa loại hoạt động',
    'personalization_activity_type_modal_delete_desc' => 'Bạn chắc chắn muốn xóa loại hoạt động này? Các hoạt động gắn với danh mục này sẽ không bị ảnh hưởng.',
    'personalization_activity_type_modal_delete_error' => 'Chúng tôi không thể tìm thấy loại hoạt động này.',
    'personalization_activity_type_category_modal_delete_error' => 'Chúng tôi không thể tìm thấy danh mục này.',

    'personalization_life_event_category_title' => 'Danh mục sự kiện trong đời',
    'personalization_live_event_category_table_name' => 'Tên',
    'personalization_life_event_category_description' => 'Sự kiện trong đời có thể có loại và danh mục. Tài khoản của bạn được cài đặt danh mục và loại mặc định, nhưng bạn có thể tùy biến ở đây.',
    'personalization_live_event_category_table_actions' => 'Hành động',
    'personalization_life_event_type_add_button' => 'Thêm loại sự kiện trong đời',
    'personalization_life_event_type_modal_add' => 'Thêm loại sự kiện trong đời',
    'personalization_life_event_type_modal_question' => 'Chúng ta nên đặt tên cho sự kiện này là gì?',
    'personalization_life_event_type_modal_edit' => 'Sửa kiểu sự kiện trong đời',
    'personalization_life_event_type_modal_delete' => 'Xoá kiểu sự kiện trong đời',
    'personalization_life_event_type_modal_delete_desc' => 'Bạn muốn xóa kiểu sự kiện trong đời này? Các dữ liệu sự kiện gắn liền với kiểu sự kiện này cũng sẽ bị xóa bỏ.',
    'personalization_life_event_type_modal_delete_error' => 'Chúng tôi không thể tìm được kiểu sự kiện trong đời này.',

    'personalization_life_event_category_work_education' => 'Công việc & học vấn',
    'personalization_life_event_category_family_relationships' => 'Gia đình & các mối quan hệ',
    'personalization_life_event_category_home_living' => 'Nhà cửa & đời sống',
    'personalization_life_event_category_travel_experiences' => 'Du lịch & trải nghiệm',
    'personalization_life_event_category_health_wellness' => 'Sức khỏe thể chất & tinh thần',

    'personalization_life_event_type_new_job' => 'Công việc mới',
    'personalization_life_event_type_retirement' => 'Nghỉ hưu',
    'personalization_life_event_type_new_school' => 'Trường học mới',
    'personalization_life_event_type_study_abroad' => 'Du học',
    'personalization_life_event_type_volunteer_work' => 'Công việc tình nguyện',
    'personalization_life_event_type_published_book_or_paper' => 'Xuất bản sách hoặc văn bản',
    'personalization_life_event_type_military_service' => 'Nghĩa vụ quân sự',
    'personalization_life_event_type_first_met' => 'Lần đầu gặp',
    'personalization_life_event_type_new_relationship' => 'Mối quan hệ mới',
    'personalization_life_event_type_engagement' => 'Đính hôn',
    'personalization_life_event_type_marriage' => 'Kết hôn',
    'personalization_life_event_type_anniversary' => 'Kỷ niệm',
    'personalization_life_event_type_expecting_a_baby' => 'Muốn có con',
    'personalization_life_event_type_new_child' => 'Mới có con',
    'personalization_life_event_type_new_family_member' => 'Thêm thành viên mới trong gia đình',
    'personalization_life_event_type_new_pet' => 'Thêm thú cưng',
    'personalization_life_event_type_end_of_relationship' => 'Kết thúc mối quan hệ',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Mất một người thân yêu',
    'personalization_life_event_type_moved' => 'Đã chuyển đi',
    'personalization_life_event_type_bought_a_home' => 'Đã mua nhà',
    'personalization_life_event_type_home_improvement' => 'Sửa nhà',
    'personalization_life_event_type_holidays' => 'Kỳ nghỉ',
    'personalization_life_event_type_new_vehicle' => 'Mua xe mới',
    'personalization_life_event_type_new_roommate' => 'Bạn cùng phòng mới',
    'personalization_life_event_type_overcame_an_illness' => 'Đã vượt qua bệnh tật',
    'personalization_life_event_type_quit_a_habit' => 'Bỏ một thói quen',
    'personalization_life_event_type_new_eating_habits' => 'Thói quen ăn uống mới',
    'personalization_life_event_type_weight_loss' => 'Giảm cân',
    'personalization_life_event_type_wear_glass_or_contact' => 'Đã đeo kính hoặc kính áp tròng',
    'personalization_life_event_type_broken_bone' => 'Gãy xương',
    'personalization_life_event_type_removed_braces' => 'Gỡ niềng răng',
    'personalization_life_event_type_surgery' => 'Đã phẫu thuật',
    'personalization_life_event_type_dentist' => 'Đã điều trị nha khoa',
    'personalization_life_event_type_new_sport' => 'Bắt đầu chơi môn thể thao mới',
    'personalization_life_event_type_new_hobby' => 'Có sở thích mới',
    'personalization_life_event_type_new_instrument' => 'Bắt đầu học nhạc cụ mới',
    'personalization_life_event_type_new_language' => 'Bắt đầu học ngôn ngữ mới',
    'personalization_life_event_type_tattoo_or_piercing' => 'Xăm hình hoặc xỏ khuyên',
    'personalization_life_event_type_new_license' => 'Bằng lái mới',
    'personalization_life_event_type_travel' => 'Du lịch',
    'personalization_life_event_type_achievement_or_award' => 'Có giải thưởng hoặc thành tựu',
    'personalization_life_event_type_changed_beliefs' => 'Thay đổi đức tin',
    'personalization_life_event_type_first_word' => 'Câu nói đầu tiên',
    'personalization_life_event_type_first_kiss' => 'Nụ hôn đầu',

    'storage_title' => 'Bộ nhớ',
    'storage_account_info' => 'Giới hạn tài khoản của bạn là :accountLimit MB. Bạn đã sử dụng :currentAccountSize MB (khoảng :percentUsage%).',
    'storage_upgrade_notice' => 'Nâng cấp tài khoản của bạn để có thể tải lên tài liệu và ảnh.',
    'storage_description' => 'Bạn có thể xem tất cả tài liệu và ảnh đã tải lên về liên hệ của bạn ở đây.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Bạn có thể tìm thấy tất cả cài đặt sử dụng WebDAV để xuất CardDAV và CalDAV ở đây.',
    'dav_copy_help' => 'Sao chép vào clipboard',
    'dav_clipboard_copied' => 'Giá trị đã được copy vào clipboard',
    'dav_url_base' => 'URL chung cho tất cả tài nguyên CardDAV và CalDAV:',
    'dav_connect_help' => 'Bạn có thể kết nối danh bạ và/hoặc lịch với url này trên điện thoại hoặc máy tính.',
    'dav_connect_help2' => 'Sử dụng email đăng nhập và tạo khóa API để xác thực.',
    'dav_url_carddav' => 'CardDAV url cho danh sách Danh bạ:',
    'dav_url_caldav_birthdays' => 'CalDAV url cho danh sách Sinh nhật:',
    'dav_url_caldav_tasks' => 'CalDAV url cho danh sách Công việc:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Xuất tất cả danh bạ thành một tệp',
    'dav_caldav_birthdays_export' => 'Xuất tất cả sinh nhật thành một tệp',
    'dav_caldav_tasks_export' => 'Xuất tất cả công việc thành một tệp',

    'archive_title' => 'Lưu trữ tát cả danh bạ trong tài khoản của bạn',
    'archive_desc' => 'Hành động này sẽ lưu trữ tất cả liên hệ trong tài khoản của bạn.',
    'archive_cta' => 'Lưu trữ tất cả liên hệ',

    'logs_title' => 'Mọi thứ đã xảy ra với tài khoản này',
    'logs_actor' => 'Người thao tác',
    'logs_timestamp' => 'Mốc thời gian',
    'logs_description' => 'Mô tả',
    'logs_subject' => 'Tiêu đề',
    'logs_size' => 'Kích thước (Kb)',
    'logs_object' => 'Đối tượng',
];
