/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class ClientHttpRequest {
    URLConnection _connection;
    OutputStream _os = null;
    Map<String, String> _cookies = new HashMap<String, String>();
    String _rawCookies = "";
    private static Random random = new Random();
    String boundary = "---------------------------" + ClientHttpRequest.randomString() + ClientHttpRequest.randomString() + ClientHttpRequest.randomString();

    protected void connect() throws IOException {
        if (this._os == null) {
            this._os = this._connection.getOutputStream();
        }
    }

    protected void write(char c) throws IOException {
        this.connect();
        this._os.write(c);
    }

    protected void write(String string) throws IOException {
        this.connect();
        this._os.write(string.getBytes("UTF-8"));
    }

    protected void newline() throws IOException {
        this.connect();
        this.write("\r\n");
    }

    protected void writeln(String string) throws IOException {
        this.connect();
        this.write(string);
        this.newline();
    }

    protected static String randomString() {
        return Long.toString(random.nextLong(), 36);
    }

    private void boundary() throws IOException {
        this.write("--");
        this.write(this.boundary);
    }

    public ClientHttpRequest(URLConnection uRLConnection) throws IOException {
        this._connection = uRLConnection;
        uRLConnection.setDoOutput(true);
        uRLConnection.setDoInput(true);
        uRLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    public ClientHttpRequest(URL uRL) throws IOException {
        this(uRL.openConnection());
    }

    public ClientHttpRequest(String string) throws IOException {
        this(new URL(string));
    }

    private void postCookies() {
        StringBuffer stringBuffer = new StringBuffer(this._rawCookies);
        Iterator<Map.Entry<String, String>> iterator = this._cookies.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            stringBuffer.append(entry.getKey().toString() + "=" + entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("; ");
        }
        if (stringBuffer.length() > 0) {
            this._connection.setRequestProperty("Cookie", stringBuffer.toString());
        }
    }

    public void setCookies(String string) throws IOException {
        this._rawCookies = string == null ? "" : string;
        this._cookies.clear();
    }

    public void setCookie(String string, String string2) throws IOException {
        this._cookies.put(string, string2);
    }

    public void setCookies(Map<String, String> map) throws IOException {
        if (map == null) {
            return;
        }
        this._cookies.putAll(map);
    }

    public void setCookies(String[] stringArray) throws IOException {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length - 1; i += 2) {
            this.setCookie(stringArray[i], stringArray[i + 1]);
        }
    }

    private void writeName(String string) throws IOException {
        this.newline();
        this.write("Content-Disposition: form-data; name=\"");
        this.write(string);
        this.write('\"');
    }

    public void setParameter(String string, String string2) throws IOException {
        if (string == null) {
            throw new InvalidParameterException("setParameter(" + string + "," + string2 + ") name must not be null");
        }
        if (string2 == null) {
            throw new InvalidParameterException("setParameter(" + string + "," + string2 + ") value must not be null");
        }
        this.boundary();
        this.writeName(string);
        this.newline();
        this.newline();
        this.writeln(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pipe(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[500000];
        int n = 0;
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            int n2;
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                outputStream.write(byArray, 0, n2);
                n += n2;
            }
        }
        outputStream.flush();
        byArray = null;
    }

    public void setParameter(String string, String string2, InputStream inputStream) throws IOException {
        this.boundary();
        this.writeName(string);
        this.write("; filename=\"");
        this.write(string2);
        this.write('\"');
        this.newline();
        this.write("Content-Type: ");
        String string3 = URLConnection.guessContentTypeFromName(string2);
        if (string3 == null) {
            string3 = "application/octet-stream";
        }
        this.writeln(string3);
        this.newline();
        ClientHttpRequest.pipe(inputStream, this._os);
        this.newline();
    }

    public void setParameter(String string, File file) throws IOException {
        this.setParameter(string, file.getPath(), new FileInputStream(file));
    }

    public void setParameter(String string, Object object) throws IOException {
        if (object instanceof File) {
            this.setParameter(string, (File)object);
        } else {
            this.setParameter(string, object.toString());
        }
    }

    public void setParameters(Map map) throws IOException {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.setParameter(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public void setParameters(Object[] objectArray) throws IOException {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length - 1; i += 2) {
                this.setParameter(objectArray[i].toString(), objectArray[i + 1]);
            }
        }
    }

    private InputStream doPost() throws IOException {
        this.boundary();
        this.writeln("--");
        this._os.close();
        return this._connection.getInputStream();
    }

    public InputStream post() throws IOException {
        this.postCookies();
        return this.doPost();
    }

    public InputStream post(Map map) throws IOException {
        this.postCookies();
        this.setParameters(map);
        return this.doPost();
    }

    public InputStream post(Object[] objectArray) throws IOException {
        this.postCookies();
        this.setParameters(objectArray);
        return this.doPost();
    }

    public InputStream post(Map<String, String> map, Map map2) throws IOException {
        this.setCookies(map);
        this.postCookies();
        this.setParameters(map2);
        return this.doPost();
    }

    public InputStream post(String string, Map map) throws IOException {
        this.setCookies(string);
        this.postCookies();
        this.setParameters(map);
        return this.doPost();
    }

    public InputStream post(String[] stringArray, Object[] objectArray) throws IOException {
        this.setCookies(stringArray);
        this.postCookies();
        this.setParameters(objectArray);
        return this.doPost();
    }

    public InputStream post(String string, Object object) throws IOException {
        this.postCookies();
        this.setParameter(string, object);
        return this.doPost();
    }

    public InputStream post(String string, Object object, String string2, Object object2) throws IOException {
        this.postCookies();
        this.setParameter(string, object);
        this.setParameter(string2, object2);
        return this.doPost();
    }

    public InputStream post(String string, Object object, String string2, Object object2, String string3, Object object3) throws IOException {
        this.postCookies();
        this.setParameter(string, object);
        this.setParameter(string2, object2);
        this.setParameter(string3, object3);
        return this.doPost();
    }

    public InputStream post(String string, Object object, String string2, Object object2, String string3, Object object3, String string4, Object object4) throws IOException {
        this.postCookies();
        this.setParameter(string, object);
        this.setParameter(string2, object2);
        this.setParameter(string3, object3);
        this.setParameter(string4, object4);
        return this.doPost();
    }

    public static InputStream post(URL uRL, Map map) throws IOException {
        return new ClientHttpRequest(uRL).post(map);
    }

    public static InputStream post(URL uRL, Object[] objectArray) throws IOException {
        return new ClientHttpRequest(uRL).post(objectArray);
    }

    public static InputStream post(URL uRL, Map<String, String> map, Map map2) throws IOException {
        return new ClientHttpRequest(uRL).post(map, map2);
    }

    public static InputStream post(URL uRL, String[] stringArray, Object[] objectArray) throws IOException {
        return new ClientHttpRequest(uRL).post(stringArray, objectArray);
    }

    public static InputStream post(URL uRL, String string, Object object) throws IOException {
        return new ClientHttpRequest(uRL).post(string, object);
    }

    public static InputStream post(URL uRL, String string, Object object, String string2, Object object2) throws IOException {
        return new ClientHttpRequest(uRL).post(string, object, string2, object2);
    }

    public static InputStream post(URL uRL, String string, Object object, String string2, Object object2, String string3, Object object3) throws IOException {
        return new ClientHttpRequest(uRL).post(string, object, string2, object2, string3, object3);
    }

    public static InputStream post(URL uRL, String string, Object object, String string2, Object object2, String string3, Object object3, String string4, Object object4) throws IOException {
        return new ClientHttpRequest(uRL).post(string, object, string2, object2, string3, object3, string4, object4);
    }
}

