/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TransformEdit;
import org.jhotdraw.draw.action.AbstractSelectedAction;

public abstract class MoveAction
extends AbstractSelectedAction {
    private int dx;
    private int dy;

    public MoveAction(DrawingEditor drawingEditor, int n, int n2) {
        super(drawingEditor);
        this.dx = n;
        this.dy = n2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.dx, this.dy);
        for (Figure figure : this.getView().getSelectedFigures()) {
            figure.willChange();
            figure.transform(affineTransform);
            figure.changed();
        }
        this.fireUndoableEditHappened(new TransformEdit(this.getView().getSelectedFigures(), affineTransform));
    }

    public static class East
    extends MoveAction {
        public static final String ID = "edit.moveEast";

        public East(DrawingEditor drawingEditor) {
            super(drawingEditor, 1, 0);
            this.labels.configureAction(this, ID);
        }
    }

    public static class North
    extends MoveAction {
        public static final String ID = "edit.moveNorth";

        public North(DrawingEditor drawingEditor) {
            super(drawingEditor, 0, -1);
            this.labels.configureAction(this, ID);
        }
    }

    public static class South
    extends MoveAction {
        public static final String ID = "edit.moveSouth";

        public South(DrawingEditor drawingEditor) {
            super(drawingEditor, 0, 1);
            this.labels.configureAction(this, ID);
        }
    }

    public static class West
    extends MoveAction {
        public static final String ID = "edit.moveWest";

        public West(DrawingEditor drawingEditor) {
            super(drawingEditor, -1, 0);
            this.labels.configureAction(this, ID);
        }
    }
}

