/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.conf;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.ldap.conf.CaseInsensitivePatternDeserializer;
import org.apache.guacamole.auth.ldap.conf.EnvironmentLDAPConfiguration;
import org.apache.guacamole.auth.ldap.conf.JacksonLDAPConfiguration;
import org.apache.guacamole.auth.ldap.conf.LDAPConfiguration;
import org.apache.guacamole.environment.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigurationService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationService.class);
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).registerModule((Module)new SimpleModule().addDeserializer(Pattern.class, (JsonDeserializer)new CaseInsensitivePatternDeserializer()));
    private static final String LDAP_SERVERS_YML = "ldap-servers.yml";
    private final AtomicLong lastModified = new AtomicLong(0L);
    private Collection<JacksonLDAPConfiguration> cachedConfigurations = null;
    @Inject
    private Environment environment;

    public Collection<? extends LDAPConfiguration> getLDAPConfigurations() throws GuacamoleException {
        long oldLastModified;
        File ldapServers = new File(this.environment.getGuacamoleHome(), LDAP_SERVERS_YML);
        if (ldapServers.exists()) {
            long oldLastModified2 = this.lastModified.get();
            long currentLastModified = ldapServers.lastModified();
            if (currentLastModified > oldLastModified2 && this.lastModified.compareAndSet(oldLastModified2, currentLastModified)) {
                try {
                    logger.debug("Reading updated LDAP configuration from \"{}\"...", (Object)ldapServers);
                    Collection configs = (Collection)this.mapper.readValue(ldapServers, (TypeReference)new TypeReference<Collection<JacksonLDAPConfiguration>>(){});
                    if (configs != null) {
                        logger.debug("Reading LDAP configuration defaults from guacamole.properties...");
                        EnvironmentLDAPConfiguration defaultConfig = new EnvironmentLDAPConfiguration(this.environment);
                        configs.forEach(config -> config.setDefaults(defaultConfig));
                    } else {
                        logger.debug("Using only guacamole.properties for LDAP server definitions as \"{}\" is empty.", (Object)ldapServers);
                    }
                    this.cachedConfigurations = configs;
                }
                catch (IOException e) {
                    logger.error("\"{}\" could not be read/parsed: {}", (Object)ldapServers, (Object)e.getMessage());
                }
            } else {
                logger.debug("Using cached LDAP configuration from \"{}\".", (Object)ldapServers);
            }
        } else if (this.cachedConfigurations != null && this.lastModified.compareAndSet(oldLastModified = this.lastModified.get(), 0L)) {
            logger.debug("Clearing cached LDAP configuration from \"{}\" (file no longer exists).", (Object)ldapServers);
            this.cachedConfigurations = null;
        }
        if (this.cachedConfigurations == null) {
            logger.debug("Reading LDAP configuration from guacamole.properties...");
            return Collections.singletonList(new EnvironmentLDAPConfiguration(this.environment));
        }
        return this.cachedConfigurations;
    }
}

