/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import twitter4j.HashtagEntity;
import twitter4j.TwitterException;
import twitter4j.internal.json.EntityIndex;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

class HashtagEntityJSONImpl
extends EntityIndex
implements HashtagEntity {
    private static final long serialVersionUID = 4068992372784813200L;
    private String text;

    HashtagEntityJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    HashtagEntityJSONImpl(int start, int end, String text) {
        this.setStart(start);
        this.setEnd(end);
        this.text = text;
    }

    HashtagEntityJSONImpl() {
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            JSONArray indicesArray = json.getJSONArray("indices");
            this.setStart(indicesArray.getInt(0));
            this.setEnd(indicesArray.getInt(1));
            if (!json.isNull("text")) {
                this.text = json.getString("text");
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public String getText() {
        return this.text;
    }

    public int getStart() {
        return super.getStart();
    }

    public int getEnd() {
        return super.getEnd();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashtagEntityJSONImpl that = (HashtagEntityJSONImpl)o;
        return !(this.text != null ? !this.text.equals(that.text) : that.text != null);
    }

    public int hashCode() {
        return this.text != null ? this.text.hashCode() : 0;
    }

    public String toString() {
        return "HashtagEntityJSONImpl{text='" + this.text + '\'' + '}';
    }
}

