/* Generated by wayland-scanner 1.24.0 */

#ifndef XDG_SHELL_UNSTABLE_V6_ENUM_PROTOCOL_H
#define XDG_SHELL_UNSTABLE_V6_ENUM_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef ZXDG_SHELL_V6_ERROR_ENUM
#define ZXDG_SHELL_V6_ERROR_ENUM
enum zxdg_shell_v6_error {
	/**
	 * given wl_surface has another role
	 */
	ZXDG_SHELL_V6_ERROR_ROLE = 0,
	/**
	 * xdg_shell was destroyed before children
	 */
	ZXDG_SHELL_V6_ERROR_DEFUNCT_SURFACES = 1,
	/**
	 * the client tried to map or destroy a non-topmost popup
	 */
	ZXDG_SHELL_V6_ERROR_NOT_THE_TOPMOST_POPUP = 2,
	/**
	 * the client specified an invalid popup parent surface
	 */
	ZXDG_SHELL_V6_ERROR_INVALID_POPUP_PARENT = 3,
	/**
	 * the client provided an invalid surface state
	 */
	ZXDG_SHELL_V6_ERROR_INVALID_SURFACE_STATE = 4,
	/**
	 * the client provided an invalid positioner
	 */
	ZXDG_SHELL_V6_ERROR_INVALID_POSITIONER = 5,
};
#endif /* ZXDG_SHELL_V6_ERROR_ENUM */

#ifndef ZXDG_POSITIONER_V6_ERROR_ENUM
#define ZXDG_POSITIONER_V6_ERROR_ENUM
enum zxdg_positioner_v6_error {
	/**
	 * invalid input provided
	 */
	ZXDG_POSITIONER_V6_ERROR_INVALID_INPUT = 0,
};
#endif /* ZXDG_POSITIONER_V6_ERROR_ENUM */

#ifndef ZXDG_POSITIONER_V6_ANCHOR_ENUM
#define ZXDG_POSITIONER_V6_ANCHOR_ENUM
enum zxdg_positioner_v6_anchor {
	/**
	 * the center of the anchor rectangle
	 */
	ZXDG_POSITIONER_V6_ANCHOR_NONE = 0,
	/**
	 * the top edge of the anchor rectangle
	 */
	ZXDG_POSITIONER_V6_ANCHOR_TOP = 1,
	/**
	 * the bottom edge of the anchor rectangle
	 */
	ZXDG_POSITIONER_V6_ANCHOR_BOTTOM = 2,
	/**
	 * the left edge of the anchor rectangle
	 */
	ZXDG_POSITIONER_V6_ANCHOR_LEFT = 4,
	/**
	 * the right edge of the anchor rectangle
	 */
	ZXDG_POSITIONER_V6_ANCHOR_RIGHT = 8,
};
#endif /* ZXDG_POSITIONER_V6_ANCHOR_ENUM */

#ifndef ZXDG_POSITIONER_V6_GRAVITY_ENUM
#define ZXDG_POSITIONER_V6_GRAVITY_ENUM
enum zxdg_positioner_v6_gravity {
	/**
	 * center over the anchor edge
	 */
	ZXDG_POSITIONER_V6_GRAVITY_NONE = 0,
	/**
	 * position above the anchor edge
	 */
	ZXDG_POSITIONER_V6_GRAVITY_TOP = 1,
	/**
	 * position below the anchor edge
	 */
	ZXDG_POSITIONER_V6_GRAVITY_BOTTOM = 2,
	/**
	 * position to the left of the anchor edge
	 */
	ZXDG_POSITIONER_V6_GRAVITY_LEFT = 4,
	/**
	 * position to the right of the anchor edge
	 */
	ZXDG_POSITIONER_V6_GRAVITY_RIGHT = 8,
};
#endif /* ZXDG_POSITIONER_V6_GRAVITY_ENUM */

#ifndef ZXDG_POSITIONER_V6_CONSTRAINT_ADJUSTMENT_ENUM
#define ZXDG_POSITIONER_V6_CONSTRAINT_ADJUSTMENT_ENUM
/**
 * @ingroup iface_zxdg_positioner_v6
 * constraint adjustments
 *
 * The constraint adjustment value define ways the compositor will adjust
 * the position of the surface, if the unadjusted position would result
 * in the surface being partly constrained.
 *
 * Whether a surface is considered 'constrained' is left to the compositor
 * to determine. For example, the surface may be partly outside the
 * compositor's defined 'work area', thus necessitating the child surface's
 * position be adjusted until it is entirely inside the work area.
 *
 * The adjustments can be combined, according to a defined precedence: 1)
 * Flip, 2) Slide, 3) Resize.
 */
enum zxdg_positioner_v6_constraint_adjustment {
	/**
	 * don't move the child surface when constrained
	 *
	 * Don't alter the surface position even if it is constrained on
	 * some axis, for example partially outside the edge of a monitor.
	 */
	ZXDG_POSITIONER_V6_CONSTRAINT_ADJUSTMENT_NONE = 0,
	/**
	 * move along the x axis until unconstrained
	 *
	 * Slide the surface along the x axis until it is no longer
	 * constrained.
	 *
	 * First try to slide towards the direction of the gravity on the x
	 * axis until either the edge in the opposite direction of the
	 * gravity is unconstrained or the edge in the direction of the
	 * gravity is constrained.
	 *
	 * Then try to slide towards the opposite direction of the gravity
	 * on the x axis until either the edge in the direction of the
	 * gravity is unconstrained or the edge in the opposite direction
	 * of the gravity is constrained.
	 */
	ZXDG_POSITIONER_V6_CONSTRAINT_ADJUSTMENT_SLIDE_X = 1,
	/**
	 * move along the y axis until unconstrained
	 *
	 * Slide the surface along the y axis until it is no longer
	 * constrained.
	 *
	 * First try to slide towards the direction of the gravity on the y
	 * axis until either the edge in the opposite direction of the
	 * gravity is unconstrained or the edge in the direction of the
	 * gravity is constrained.
	 *
	 * Then try to slide towards the opposite direction of the gravity
	 * on the y axis until either the edge in the direction of the
	 * gravity is unconstrained or the edge in the opposite direction
	 * of the gravity is constrained.
	 */
	ZXDG_POSITIONER_V6_CONSTRAINT_ADJUSTMENT_SLIDE_Y = 2,
	/**
	 * invert the anchor and gravity on the x axis
	 *
	 * Invert the anchor and gravity on the x axis if the surface is
	 * constrained on the x axis. For example, if the left edge of the
	 * surface is constrained, the gravity is 'left' and the anchor is
	 * 'left', change the gravity to 'right' and the anchor to 'right'.
	 *
	 * If the adjusted position also ends up being constrained, the
	 * resulting position of the flip_x adjustment will be the one
	 * before the adjustment.
	 */
	ZXDG_POSITIONER_V6_CONSTRAINT_ADJUSTMENT_FLIP_X = 4,
	/**
	 * invert the anchor and gravity on the y axis
	 *
	 * Invert the anchor and gravity on the y axis if the surface is
	 * constrained on the y axis. For example, if the bottom edge of
	 * the surface is constrained, the gravity is 'bottom' and the
	 * anchor is 'bottom', change the gravity to 'top' and the anchor
	 * to 'top'.
	 *
	 * If the adjusted position also ends up being constrained, the
	 * resulting position of the flip_y adjustment will be the one
	 * before the adjustment.
	 */
	ZXDG_POSITIONER_V6_CONSTRAINT_ADJUSTMENT_FLIP_Y = 8,
	/**
	 * horizontally resize the surface
	 *
	 * Resize the surface horizontally so that it is completely
	 * unconstrained.
	 */
	ZXDG_POSITIONER_V6_CONSTRAINT_ADJUSTMENT_RESIZE_X = 16,
	/**
	 * vertically resize the surface
	 *
	 * Resize the surface vertically so that it is completely
	 * unconstrained.
	 */
	ZXDG_POSITIONER_V6_CONSTRAINT_ADJUSTMENT_RESIZE_Y = 32,
};
#endif /* ZXDG_POSITIONER_V6_CONSTRAINT_ADJUSTMENT_ENUM */

#ifndef ZXDG_SURFACE_V6_ERROR_ENUM
#define ZXDG_SURFACE_V6_ERROR_ENUM
enum zxdg_surface_v6_error {
	ZXDG_SURFACE_V6_ERROR_NOT_CONSTRUCTED = 1,
	ZXDG_SURFACE_V6_ERROR_ALREADY_CONSTRUCTED = 2,
	ZXDG_SURFACE_V6_ERROR_UNCONFIGURED_BUFFER = 3,
};
#endif /* ZXDG_SURFACE_V6_ERROR_ENUM */

#ifndef ZXDG_TOPLEVEL_V6_RESIZE_EDGE_ENUM
#define ZXDG_TOPLEVEL_V6_RESIZE_EDGE_ENUM
/**
 * @ingroup iface_zxdg_toplevel_v6
 * edge values for resizing
 *
 * These values are used to indicate which edge of a surface
 * is being dragged in a resize operation.
 */
enum zxdg_toplevel_v6_resize_edge {
	ZXDG_TOPLEVEL_V6_RESIZE_EDGE_NONE = 0,
	ZXDG_TOPLEVEL_V6_RESIZE_EDGE_TOP = 1,
	ZXDG_TOPLEVEL_V6_RESIZE_EDGE_BOTTOM = 2,
	ZXDG_TOPLEVEL_V6_RESIZE_EDGE_LEFT = 4,
	ZXDG_TOPLEVEL_V6_RESIZE_EDGE_TOP_LEFT = 5,
	ZXDG_TOPLEVEL_V6_RESIZE_EDGE_BOTTOM_LEFT = 6,
	ZXDG_TOPLEVEL_V6_RESIZE_EDGE_RIGHT = 8,
	ZXDG_TOPLEVEL_V6_RESIZE_EDGE_TOP_RIGHT = 9,
	ZXDG_TOPLEVEL_V6_RESIZE_EDGE_BOTTOM_RIGHT = 10,
};
#endif /* ZXDG_TOPLEVEL_V6_RESIZE_EDGE_ENUM */

#ifndef ZXDG_TOPLEVEL_V6_STATE_ENUM
#define ZXDG_TOPLEVEL_V6_STATE_ENUM
/**
 * @ingroup iface_zxdg_toplevel_v6
 * types of state on the surface
 *
 * The different state values used on the surface. This is designed for
 * state values like maximized, fullscreen. It is paired with the
 * configure event to ensure that both the client and the compositor
 * setting the state can be synchronized.
 *
 * States set in this way are double-buffered, see wl_surface.commit.
 */
enum zxdg_toplevel_v6_state {
	/**
	 * the surface is maximized
	 * the surface is maximized
	 *
	 * The surface is maximized. The window geometry specified in the
	 * configure event must be obeyed by the client. If the window
	 * geometry is not obyed, the zxdg_shell_v6.invalid_surface_state
	 * error is raised.
	 */
	ZXDG_TOPLEVEL_V6_STATE_MAXIMIZED = 1,
	/**
	 * the surface is fullscreen
	 * the surface is fullscreen
	 *
	 * The surface is fullscreen. See set_fullscreen for more
	 * information.
	 */
	ZXDG_TOPLEVEL_V6_STATE_FULLSCREEN = 2,
	/**
	 * the surface is being resized
	 * the surface is being resized
	 *
	 * The surface is being resized. The window geometry specified in
	 * the configure event is a maximum; the client cannot resize
	 * beyond it. If the client attempts to resize above it, the
	 * zxdg_shell_v6.invalid_surface_state error is raised. Clients
	 * that have aspect ratio or cell sizing configuration can use a
	 * smaller size, however.
	 */
	ZXDG_TOPLEVEL_V6_STATE_RESIZING = 3,
	/**
	 * the surface is now activated
	 * the surface is now activated
	 *
	 * Client window decorations should be painted as if the window
	 * is active. Do not assume this means that the window actually has
	 * keyboard or pointer focus.
	 */
	ZXDG_TOPLEVEL_V6_STATE_ACTIVATED = 4,
};
#endif /* ZXDG_TOPLEVEL_V6_STATE_ENUM */

#ifndef ZXDG_POPUP_V6_ERROR_ENUM
#define ZXDG_POPUP_V6_ERROR_ENUM
enum zxdg_popup_v6_error {
	/**
	 * tried to grab after being mapped
	 */
	ZXDG_POPUP_V6_ERROR_INVALID_GRAB = 0,
};
#endif /* ZXDG_POPUP_V6_ERROR_ENUM */

#ifdef  __cplusplus
}
#endif

#endif
