/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractOutputTarget;

public class DatagramOutputTarget
extends AbstractOutputTarget {
    private static final String DEFAULT_ENCODING = "US-ASCII";
    private DatagramSocket m_socket = new DatagramSocket();
    private String m_encoding;

    public DatagramOutputTarget(InetAddress address, int port, Formatter formatter, String encoding) throws IOException {
        super(formatter);
        this.m_socket.connect(address, port);
        this.m_encoding = encoding;
        this.open();
    }

    public DatagramOutputTarget(InetAddress address, int port, Formatter formatter) throws IOException {
        this(address, port, formatter, DEFAULT_ENCODING);
    }

    public DatagramOutputTarget(InetAddress address, int port) throws IOException {
        this(address, port, null);
    }

    protected void write(String stringData) {
        try {
            byte[] data = stringData.getBytes(this.m_encoding);
            DatagramPacket packet = new DatagramPacket(data, data.length);
            this.m_socket.send(packet);
        }
        catch (IOException ioe) {
            this.getErrorHandler().error("Error sending datagram.", ioe, null);
        }
    }

    public synchronized void close() {
        super.close();
        this.m_socket = null;
    }
}

