/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.fileupload2.core.FileItemHeaders;

class FileItemHeadersImpl
implements FileItemHeaders {
    private final Map<String, List<String>> headerNameToValueListMap = new LinkedHashMap<String, List<String>>();

    FileItemHeadersImpl() {
    }

    @Override
    public synchronized void addHeader(String name, String value) {
        this.headerNameToValueListMap.computeIfAbsent(this.toLowerCase(name), k -> new ArrayList()).add(value);
    }

    @Override
    public String getHeader(String name) {
        List<String> headerValueList = this.getList(name);
        if (null == headerValueList) {
            return null;
        }
        return headerValueList.get(0);
    }

    @Override
    public Iterator<String> getHeaderNames() {
        return this.headerNameToValueListMap.keySet().iterator();
    }

    @Override
    public Iterator<String> getHeaders(String name) {
        List<String> headerValueList = this.getList(name);
        if (null == headerValueList) {
            headerValueList = Collections.emptyList();
        }
        return headerValueList.iterator();
    }

    private List<String> getList(String name) {
        return this.headerNameToValueListMap.get(this.toLowerCase(name));
    }

    private String toLowerCase(String value) {
        return value.toLowerCase(Locale.ENGLISH);
    }
}

