/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml.dataattributes;

import nu.validator.htmlparser.impl.NCName;
import nu.validator.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DataAttributeDroppingContentHandlerWrapper
implements ContentHandler {
    private final ContentHandler delegate;
    private final ErrorHandler errorHandler;
    private Locator locator = null;

    public DataAttributeDroppingContentHandlerWrapper(ContentHandler delegate, ErrorHandler errorHandler) {
        this.delegate = delegate;
        this.errorHandler = errorHandler;
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        this.delegate.characters(arg0, arg1, arg2);
    }

    @Override
    public void endDocument() throws SAXException {
        this.delegate.endDocument();
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        this.delegate.endElement(arg0, arg1, arg2);
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
        this.delegate.endPrefixMapping(arg0);
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        this.delegate.ignorableWhitespace(arg0, arg1, arg2);
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
        this.delegate.processingInstruction(arg0, arg1);
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
        this.locator = arg0;
        this.delegate.setDocumentLocator(arg0);
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
        this.delegate.skippedEntity(arg0);
    }

    @Override
    public void startDocument() throws SAXException {
        this.delegate.startDocument();
    }

    @Override
    public void startElement(String ns, String arg1, String arg2, Attributes attributes) throws SAXException {
        if ("http://www.w3.org/1999/xhtml" == ns || "http://www.w3.org/2000/svg" == ns || "http://www.w3.org/1998/Math/MathML" == ns) {
            this.delegate.startElement(ns, arg1, arg2, this.filterAttributes(attributes));
        } else {
            this.delegate.startElement(ns, arg1, arg2, attributes);
        }
    }

    private Attributes filterAttributes(Attributes attributes) throws SAXException {
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String local = attributes.getLocalName(i);
            if (local.length() <= 5 || !local.startsWith("data-") || attributes.getURI(i) != "") continue;
            if (this.errorHandler != null) {
                this.checkDataName(local);
            }
            AttributesImpl attributesImpl = new AttributesImpl();
            for (int j = 0; j < i; ++j) {
                attributesImpl.addAttribute(attributes.getURI(j), attributes.getLocalName(j), attributes.getQName(j), attributes.getType(j), attributes.getValue(j));
            }
            for (int k = i + 1; k < len; ++k) {
                String uri = attributes.getURI(k);
                local = attributes.getLocalName(k);
                if (local.length() > 5 && local.startsWith("data-") && "" == uri) {
                    this.checkDataName(local);
                    continue;
                }
                attributesImpl.addAttribute(uri, local, attributes.getQName(k), attributes.getType(k), attributes.getValue(k));
            }
            return attributesImpl;
        }
        return attributes;
    }

    private void checkDataName(String local) throws SAXException {
        for (int i = 5; i < local.length(); ++i) {
            char c = local.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                this.errorHandler.error(new SAXParseException("\u201cdata-*\u201d attributes must not have characters from the range \u201cA\u201d\u2026\u201cZ\u201d in the name.", this.locator));
                continue;
            }
            if (NCName.isNCNameTrail(c)) continue;
            this.errorHandler.error(new SAXParseException("\u201cdata-*\u201d attribute names must be XML 1.0 4th ed. plus Namespaces NCNames.", this.locator));
        }
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.delegate.startPrefixMapping(arg0, arg1);
    }
}

