/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml.ariaattributes;

import java.util.Arrays;
import nu.validator.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class AriaAttributeDroppingContentHandlerWrapper
implements ContentHandler {
    private final ContentHandler delegate;
    private String[] KNOWN_ARIA_ATTRIBUTE_NAMES = new String[]{"aria-activedescendant", "aria-atomic", "aria-autocomplete", "aria-braillelabel", "aria-brailleroledescription", "aria-busy", "aria-checked", "aria-colcount", "aria-colindex", "aria-colindextext", "aria-colspan", "aria-controls", "aria-current", "aria-describedby", "aria-description", "aria-details", "aria-disabled", "aria-dropeffect", "aria-errormessage", "aria-expanded", "aria-flowto", "aria-grabbed", "aria-haspopup", "aria-hidden", "aria-invalid", "aria-keyshortcuts", "aria-label", "aria-labelledby", "aria-level", "aria-live", "aria-modal", "aria-multiline", "aria-multiselectable", "aria-orientation", "aria-owns", "aria-placeholder", "aria-posinset", "aria-pressed", "aria-readonly", "aria-relevant", "aria-required", "aria-roledescription", "aria-rowcount", "aria-rowindex", "aria-rowindextext", "aria-rowspan", "aria-selected", "aria-setsize", "aria-sort", "aria-valuemax", "aria-valuemin", "aria-valuenow", "aria-valuetext"};

    public AriaAttributeDroppingContentHandlerWrapper(ContentHandler delegate, ErrorHandler errorHandler) {
        this.delegate = delegate;
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        this.delegate.characters(arg0, arg1, arg2);
    }

    @Override
    public void endDocument() throws SAXException {
        this.delegate.endDocument();
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        this.delegate.endElement(arg0, arg1, arg2);
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
        this.delegate.endPrefixMapping(arg0);
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        this.delegate.ignorableWhitespace(arg0, arg1, arg2);
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
        this.delegate.processingInstruction(arg0, arg1);
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
        this.delegate.setDocumentLocator(arg0);
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
        this.delegate.skippedEntity(arg0);
    }

    @Override
    public void startDocument() throws SAXException {
        this.delegate.startDocument();
    }

    @Override
    public void startElement(String ns, String arg1, String arg2, Attributes attributes) throws SAXException {
        if ("http://www.w3.org/1999/xhtml" == ns || "http://www.w3.org/2000/svg" == ns || "http://www.w3.org/1998/Math/MathML" == ns) {
            this.delegate.startElement(ns, arg1, arg2, this.filterAttributes(attributes));
        } else {
            this.delegate.startElement(ns, arg1, arg2, attributes);
        }
    }

    private Attributes filterAttributes(Attributes attributes) throws SAXException {
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String local = attributes.getLocalName(i);
            if (!local.startsWith("aria-") || attributes.getURI(i) != "" || attributes.getValue(i) != "" || Arrays.binarySearch(this.KNOWN_ARIA_ATTRIBUTE_NAMES, local) < 0) continue;
            AttributesImpl attributesImpl = new AttributesImpl();
            for (int j = 0; j < i; ++j) {
                attributesImpl.addAttribute(attributes.getURI(j), attributes.getLocalName(j), attributes.getQName(j), attributes.getType(j), attributes.getValue(j));
            }
            for (int k = i + 1; k < len; ++k) {
                String uri = attributes.getURI(k);
                local = attributes.getLocalName(k);
                if (local.startsWith("aria-") && attributes.getURI(i) == "" && attributes.getValue(i) == "" && Arrays.binarySearch(this.KNOWN_ARIA_ATTRIBUTE_NAMES, local) >= 0) continue;
                attributesImpl.addAttribute(uri, local, attributes.getQName(k), attributes.getType(k), attributes.getValue(k));
            }
            return attributesImpl;
        }
        return attributes;
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.delegate.startPrefixMapping(arg0, arg1);
    }
}

