/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class ContentHandlerFilter
implements ContentHandler {
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private Locator locator;

    protected ContentHandlerFilter(ContentHandler contentHandler, ErrorHandler errorHandler) {
        this.contentHandler = contentHandler;
        this.errorHandler = errorHandler;
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.contentHandler.characters(chars, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    @Override
    public void endElement(String uri, String local, String qName) throws SAXException {
        this.contentHandler.endElement(uri, local, qName);
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
        this.contentHandler.endPrefixMapping(arg0);
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        this.contentHandler.ignorableWhitespace(arg0, arg1, arg2);
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
        this.contentHandler.processingInstruction(arg0, arg1);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
        this.contentHandler.skippedEntity(arg0);
    }

    @Override
    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    @Override
    public void startElement(String uri, String local, String qName, Attributes attrs) throws SAXException {
        this.contentHandler.startElement(uri, local, qName, attrs);
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.contentHandler.startPrefixMapping(arg0, arg1);
    }

    protected void fatal(String message) throws SAXException {
        SAXParseException spe = new SAXParseException(message, this.locator);
        this.errorHandler.fatalError(spe);
        throw spe;
    }

    protected void err(String message) throws SAXException {
        SAXParseException spe = new SAXParseException(message, this.locator);
        this.errorHandler.error(spe);
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

