/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.spec.html5;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.saxtree.DocumentFragment;
import nu.validator.saxtree.TreeBuilder;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.EmptyAttributes;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class ImageReportAdviceBuilder
implements ContentHandler {
    private static final String NS = "http://www.w3.org/1999/xhtml";
    private State state = State.AWAITING_H2;
    private int depth = 0;
    private TreeBuilder treeBuilder;
    private final List<DocumentFragment> fragments = new LinkedList<DocumentFragment>();

    public static List<DocumentFragment> parseAltAdvice() throws IOException, SAXException {
        HtmlParser parser = new HtmlParser(XmlViolationPolicy.ALTER_INFOSET);
        ImageReportAdviceBuilder handler = new ImageReportAdviceBuilder();
        parser.setContentHandler(handler);
        InputSource in = new InputSource(ImageReportAdviceBuilder.class.getClassLoader().getResourceAsStream("nu/validator/localentities/files/vnu-alt-advice"));
        parser.parse(in);
        return handler.getFragments();
    }

    public static void main(String[] args) throws IOException, SAXException {
        ImageReportAdviceBuilder.parseAltAdvice();
    }

    private ImageReportAdviceBuilder() {
    }

    @Override
    public void startDocument() throws SAXException {
        this.state = State.AWAITING_H2;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (this.state.ordinal()) {
            case 0: {
                if ("h2" == localName && NS == uri) {
                    this.depth = 0;
                    this.state = State.AWAITING_HEADLINE;
                }
                return;
            }
            case 1: {
                if (this.depth == 0 && "span" == localName && NS == uri && "mw-headline".equals(atts.getValue("", "class"))) {
                    this.state = State.IN_HEADLINE;
                } else {
                    ++this.depth;
                }
                return;
            }
            case 2: {
                ++this.depth;
                return;
            }
            case 3: {
                ++this.depth;
                return;
            }
            case 4: {
                String href = null;
                if (NS == uri && "a" == localName) {
                    href = atts.getValue("", "href");
                    if (href == null) break;
                    AttributesImpl ai = new AttributesImpl();
                    ai.addAttribute("href", href);
                    ++this.depth;
                    this.treeBuilder.startElement(uri, localName, qName, ai);
                    break;
                }
                if (NS == uri && "div" == localName && "printfooter".equals(atts.getValue("", "class"))) {
                    this.fragments.add((DocumentFragment)this.treeBuilder.getRoot());
                    this.treeBuilder = null;
                    this.state = State.AWAITING_H2;
                    break;
                }
                if (this.depth == 0 && "h2" == localName && NS == uri) {
                    this.fragments.add((DocumentFragment)this.treeBuilder.getRoot());
                    this.treeBuilder = null;
                    this.depth = 0;
                    this.state = State.AWAITING_HEADLINE;
                    break;
                }
                ++this.depth;
                this.treeBuilder.startElement(uri, localName, qName, EmptyAttributes.EMPTY_ATTRIBUTES);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.state.ordinal()) {
            case 0: {
                return;
            }
            case 1: {
                if (this.depth == 0) {
                    this.state = State.AWAITING_H2;
                } else {
                    --this.depth;
                }
                return;
            }
            case 2: {
                if (this.depth == 0) {
                    this.state = State.AWAITING_H2_END;
                } else {
                    --this.depth;
                }
                return;
            }
            case 3: {
                if (this.depth == 0) {
                    this.treeBuilder = new TreeBuilder(true, true);
                    this.state = State.IN_PROSE;
                } else {
                    --this.depth;
                }
                return;
            }
            case 4: {
                --this.depth;
                this.treeBuilder.endElement(uri, localName, qName);
                return;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.depth < 0) {
            return;
        }
        switch (this.state.ordinal()) {
            case 4: {
                this.treeBuilder.characters(ch, start, length);
                return;
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private List<DocumentFragment> getFragments() {
        return this.fragments;
    }

    private static enum State {
        AWAITING_H2,
        AWAITING_HEADLINE,
        IN_HEADLINE,
        AWAITING_H2_END,
        IN_PROSE;

    }
}

