/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

public class SingletonNode
extends Value
implements GroundedValue {
    protected NodeInfo node = null;

    public SingletonNode(NodeInfo node) {
        this.node = node;
    }

    public Item asItem() {
        return this.node;
    }

    public void process(XPathContext context) throws XPathException {
        if (this.node != null) {
            context.getReceiver().append(this.node, 0, 2);
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        switch (this.node.getNodeKind()) {
            case 9: {
                NodeInfo n;
                AxisIterator iter = this.node.iterateAxis((byte)3);
                ItemType elementType = null;
                while ((n = (NodeInfo)iter.next()) != null) {
                    int kind = n.getNodeKind();
                    if (kind == 3) {
                        elementType = null;
                        break;
                    }
                    if (kind != 1) continue;
                    if (elementType != null) {
                        elementType = null;
                        break;
                    }
                    elementType = new SingletonNode(n).getItemType(th);
                }
                if (elementType == null) {
                    return NodeKindTest.DOCUMENT;
                }
                return new DocumentNodeTest((NodeTest)elementType);
            }
            case 1: {
                int eltype = this.node.getTypeAnnotation();
                if (eltype == -1 || eltype == 630 || eltype == 572) {
                    return new NameTest(1, this.node.getFingerprint(), this.node.getNamePool());
                }
                return new CombinedNodeTest(new NameTest(1, this.node.getFingerprint(), this.node.getNamePool()), 23, new ContentTypeTest(1, this.node.getConfiguration().getSchemaType(eltype), this.node.getConfiguration()));
            }
            case 2: {
                int attype = this.node.getTypeAnnotation();
                if (attype == -1 || attype == 631) {
                    return new NameTest(2, this.node.getFingerprint(), this.node.getNamePool());
                }
                return new CombinedNodeTest(new NameTest(2, this.node.getFingerprint(), this.node.getNamePool()), 23, new ContentTypeTest(2, this.node.getConfiguration().getSchemaType(attype), this.node.getConfiguration()));
            }
            case 3: {
                return NodeKindTest.TEXT;
            }
            case 8: {
                return NodeKindTest.COMMENT;
            }
            case 7: {
                return NodeKindTest.PROCESSING_INSTRUCTION;
            }
            case 13: {
                return NodeKindTest.NAMESPACE;
            }
        }
        throw new IllegalArgumentException("Unknown node kind " + this.node.getNodeKind());
    }

    public int getCardinality() {
        if (this.node == null) {
            return 8192;
        }
        return 16384;
    }

    public int getLength() throws XPathException {
        return this.node == null ? 0 : 1;
    }

    public Item itemAt(int n) {
        if (n == 0 && this.node != null) {
            return this.node;
        }
        return null;
    }

    public GroundedValue subsequence(int start, int length) {
        if (this.node != null && start <= 0 && start + length > 0) {
            return this;
        }
        return EmptySequence.getInstance();
    }

    public NodeInfo getNode() {
        return this.node;
    }

    public SequenceIterator iterate() {
        return SingletonIterator.makeIterator(this.node);
    }

    public boolean effectiveBooleanValue() {
        return this.node != null;
    }

    public String getStringValue() {
        return this.node == null ? "" : this.node.getStringValue();
    }
}

