/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.Host;
import io.mola.galimatias.URLUtils;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class IPv4Address
extends Host {
    private static final long serialVersionUID = 1L;
    private final int address;

    private IPv4Address(byte[] addrBytes) {
        int addr = 0;
        addr = addrBytes[3] & 0xFF;
        addr |= addrBytes[2] << 8 & 0xFF00;
        addr |= addrBytes[1] << 16 & 0xFF0000;
        this.address = addr |= addrBytes[0] << 24 & 0xFF000000;
    }

    public static IPv4Address parseIPv4Address(String input) throws GalimatiasParseException {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        if (input.isEmpty()) {
            throw new GalimatiasParseException("empty input");
        }
        if (input.charAt(input.length() - 1) == '.') {
            throw new GalimatiasParseException("IPv4 address has trailing dot");
        }
        byte[] addr = new byte[4];
        int dotsSeen = 0;
        int addrIdx = 0;
        int idx = 0;
        boolean isEOF = false;
        while (!isEOF) {
            char c = input.charAt(idx);
            Integer value = null;
            if (!URLUtils.isASCIIDigit(c)) {
                throw new GalimatiasParseException("Non-digit character in IPv4 address");
            }
            while (URLUtils.isASCIIDigit(c)) {
                int number = c - 48;
                if (value == null) {
                    value = number;
                } else {
                    if (value == 0) {
                        throw new GalimatiasParseException("IPv4 address contains a leading zero");
                    }
                    value = value * 10 + number;
                }
                isEOF = ++idx >= input.length();
                char c2 = c = isEOF ? (char)'\u0000' : input.charAt(idx);
                if (value <= 255) continue;
                throw new GalimatiasParseException("Invalid value for IPv4 address");
            }
            if (dotsSeen < 3 && c != '.') {
                throw new GalimatiasParseException("Illegal character in IPv4 address", idx);
            }
            isEOF = ++idx >= input.length();
            char c3 = c = isEOF ? (char)'\u0000' : input.charAt(idx);
            if (dotsSeen == 3 && idx < input.length()) {
                throw new GalimatiasParseException("IPv4 address is too long", idx);
            }
            addr[addrIdx] = (byte)value.intValue();
            ++addrIdx;
            ++dotsSeen;
        }
        if (dotsSeen != 4) {
            throw new GalimatiasParseException("Malformed IPv4 address");
        }
        return new IPv4Address(addr);
    }

    public Inet4Address toInetAddress() throws UnknownHostException {
        return (Inet4Address)Inet4Address.getByAddress(this.getBytes());
    }

    public static IPv4Address fromInet4Adress(Inet4Address inet4Address) {
        return new IPv4Address(inet4Address.getAddress());
    }

    private byte[] getBytes() {
        return new byte[]{(byte)(this.address >> 24 & 0xFF), (byte)(this.address >> 16 & 0xFF), (byte)(this.address >> 8 & 0xFF), (byte)(this.address & 0xFF)};
    }

    @Override
    public String toString() {
        byte[] bytes = this.getBytes();
        return String.format("%d.%d.%d.%d", bytes[0] & 0xFF, bytes[1] & 0xFF, bytes[2] & 0xFF, bytes[3] & 0xFF);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPv4Address)) {
            return false;
        }
        return this.address == ((IPv4Address)obj).address;
    }

    public int hashCode() {
        return this.address;
    }
}

