/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.ParseIssue;

public class GalimatiasParseException
extends Exception {
    private ParseIssue parseIssue = ParseIssue.UNSPECIFIED;
    private int position = -1;

    private GalimatiasParseException() {
    }

    static Builder builder() {
        return new Builder();
    }

    GalimatiasParseException(String message) {
        super(message);
    }

    GalimatiasParseException(String message, int position) {
        super(message);
        this.position = position;
    }

    GalimatiasParseException(String message, ParseIssue parseIssue, int position, Throwable exception) {
        super(message, exception);
        if (parseIssue != null) {
            this.parseIssue = parseIssue;
        }
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public ParseIssue getParseIssue() {
        return this.parseIssue;
    }

    static class Builder {
        private String message;
        private ParseIssue parseIssue;
        private int position;
        private Throwable cause;

        private Builder() {
        }

        public Builder withMessage(String msg) {
            this.message = msg;
            return this;
        }

        public Builder withPosition(int pos) {
            this.position = pos;
            return this;
        }

        public Builder withParseIssue(ParseIssue issue) {
            this.parseIssue = issue;
            return this;
        }

        public Builder withCause(Throwable throwableCause) {
            this.cause = throwableCause;
            return this;
        }

        public GalimatiasParseException build() {
            return new GalimatiasParseException(this.message, this.parseIssue, this.position, this.cause);
        }
    }
}

