/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation.data;

import com.shapesecurity.salvation.data.Location;
import com.shapesecurity.salvation.interfaces.Show;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Notice
implements Show {
    @Nonnull
    public final Type type;
    @Nonnull
    public final String message;
    @Nullable
    public Location startLocation;
    @Nullable
    public Location endLocation;

    public Notice(@Nonnull Type type, @Nonnull String message) {
        this.message = message;
        this.type = type;
    }

    @Nonnull
    public static ArrayList<Notice> getAllErrors(@Nonnull ArrayList<Notice> notices) {
        if (notices == null) {
            return new ArrayList<Notice>();
        }
        return notices.stream().filter(Notice::isError).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nonnull
    public static ArrayList<Notice> getAllWarnings(@Nonnull ArrayList<Notice> notices) {
        if (notices == null) {
            return new ArrayList<Notice>();
        }
        return notices.stream().filter(Notice::isWarning).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nonnull
    public static ArrayList<Notice> getAllInfos(@Nonnull ArrayList<Notice> notices) {
        if (notices == null) {
            return new ArrayList<Notice>();
        }
        return notices.stream().filter(Notice::isInfo).collect(Collectors.toCollection(ArrayList::new));
    }

    public String toString() {
        return this.type.getValue() + ": " + this.message;
    }

    public boolean isError() {
        return this.type == Type.ERROR;
    }

    public boolean isWarning() {
        return this.type == Type.WARNING;
    }

    public boolean isInfo() {
        return this.type == Type.INFO;
    }

    @Override
    @Nonnull
    public String show() {
        if (this.startLocation == null) {
            return this.message;
        }
        return this.startLocation.show() + ": " + this.message;
    }

    public static enum Type {
        INFO("Info"),
        WARNING("Warning"),
        ERROR("Error");

        String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

