/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing.HeaderPanel;
import org.graalvm.visualvm.lib.ui.UIUtils;

public final class HeaderLabel
extends HeaderPanel {
    public static final int DEFAULT_HEIGHT = HeaderLabel.computeHeight();
    private String text;
    private int hAlign = 0;

    public HeaderLabel() {
        this("");
    }

    public HeaderLabel(String text) {
        this.text = text;
    }

    public final void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public final String getText() {
        return this.text;
    }

    public final void setHorizontalAlignment(int align) {
        this.hAlign = align;
        this.repaint();
    }

    public final int getHorizontalAlignment() {
        return this.hAlign;
    }

    @Override
    protected Object getRendererValue() {
        return this.getText();
    }

    @Override
    protected void setupRenderer(Component renderer) {
        if (renderer instanceof JLabel) {
            JLabel label = (JLabel)renderer;
            label.setHorizontalAlignment(this.hAlign);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = this.getPreferredSizeSuper();
        dim.height = DEFAULT_HEIGHT;
        return dim;
    }

    private Dimension getPreferredSizeSuper() {
        return super.getPreferredSize();
    }

    private static int computeHeight() {
        int height = new HeaderLabel((String)"X").getPreferredSizeSuper().height;
        if (UIUtils.isMetalLookAndFeel()) {
            height += 4;
        }
        return height;
    }
}

