/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.graalvm.visualvm.gotosource.SourceHandle;
import org.graalvm.visualvm.gotosource.SourcesViewer;
import org.graalvm.visualvm.gotosource.viewer.Bundle;
import org.graalvm.visualvm.gotosource.viewer.ExternalViewerLauncher;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.ui.swing.PopupButton;
import org.graalvm.visualvm.lib.ui.swing.SmallButton;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public final class ExternalSourcesViewer
extends SourcesViewer {
    private static final Logger LOGGER = Logger.getLogger(ExternalSourcesViewer.class.getName());
    public static final String ID = "ExternalSourcesViewer";
    private static final String PROP_COMMAND = "prop_ExternalSourcesViewer_command";
    private static final String DEFAULT_COMMAND = Bundle.ExternalSourcesViewer_CommandHint();
    private final String forcedCommand;
    private JPanel settingsPanel;
    private JTextField commandField;

    public ExternalSourcesViewer() {
        this(null);
    }

    public ExternalSourcesViewer(String forcedCommand) {
        super(ID, Bundle.ExternalSourcesViewer_Name(), Bundle.ExternalSourcesViewer_Description());
        this.forcedCommand = forcedCommand;
    }

    @Override
    public boolean open(SourceHandle handle) {
        String command = this.getCommand();
        if (command.isEmpty() || command.equals(DEFAULT_COMMAND)) {
            ExternalSourcesViewer.configureCommand();
        } else {
            ExternalSourcesViewer.executeCommand(handle, command);
        }
        return true;
    }

    @Override
    public void loadSettings() {
        if (this.forcedCommand == null && this.settingsPanel != null) {
            this.commandField.setText(this.getCommand());
        }
    }

    @Override
    public void saveSettings() {
        if (this.forcedCommand == null && this.settingsPanel != null) {
            this.saveCommand(this.commandField.getText().trim());
        }
    }

    @Override
    public boolean settingsDirty() {
        return this.forcedCommand == null && this.settingsPanel != null && !this.commandField.getText().trim().equals(this.getCommand());
    }

    private void saveCommand(String command) {
        if (this.forcedCommand == null) {
            NbPreferences.forModule(ExternalSourcesViewer.class).put(PROP_COMMAND, command);
        }
    }

    private String getCommand() {
        return this.forcedCommand == null ? NbPreferences.forModule(ExternalSourcesViewer.class).get(PROP_COMMAND, DEFAULT_COMMAND).trim() : this.forcedCommand;
    }

    private static void configureCommand() {
        ProfilerDialogs.displayWarning((String)Bundle.ExternalSourcesViewer_NotConfigured(), (String)Bundle.ExternalSourcesViewer_NotConfiguredCaption(), null);
        OptionsDisplayer.getDefault().open("SourcesOptions");
    }

    private static void executeCommand(SourceHandle handle, String commandS) {
        List<String> commandL = ExternalViewerLauncher.getCommandStrings(commandS);
        for (int i = 0; i < commandL.size(); ++i) {
            String commandI = commandL.get(i);
            if (i == 0) {
                if ((!commandI.startsWith("'") || !commandI.endsWith("'")) && (!commandI.startsWith("\"") || !commandI.endsWith("\""))) continue;
                commandI = commandI.substring(1, commandI.length() - 1);
                commandL.set(i, commandI);
                continue;
            }
            commandI = handle.expandFeatures(commandI);
            commandL.set(i, commandI);
        }
        new ExternalViewerLauncher((List)commandL){

            @Override
            protected void failed(IOException e) {
                ProfilerDialogs.displayError((String)Bundle.ExternalSourcesViewer_CommandFailed(e.getMessage()));
                LOGGER.log(Level.INFO, "Opening external sources viewer failed", e);
            }
        }.run();
    }

    @Override
    public JComponent getSettingsComponent() {
        if (this.settingsPanel == null) {
            this.settingsPanel = new JPanel(null);
            this.settingsPanel.setLayout(new BoxLayout(this.settingsPanel, 2));
            this.settingsPanel.setOpaque(false);
            int tab = 15;
            int gap = 5;
            JLabel parametersCaption = new JLabel();
            Mnemonics.setLocalizedText((JLabel)parametersCaption, (String)Bundle.ExternalSourcesViewer_CommandLabel());
            this.settingsPanel.add(parametersCaption);
            this.settingsPanel.add(Box.createHorizontalStrut(gap));
            this.commandField = new JTextField(this.getCommand());
            parametersCaption.setLabelFor(this.commandField);
            this.settingsPanel.add(this.commandField);
            this.settingsPanel.add(Box.createHorizontalStrut(gap));
            SmallButton fileChooser = new SmallButton("..."){

                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    JFileChooser fileChooser = new JFileChooser((String)null);
                    fileChooser.setDialogTitle(Bundle.ExternalSourcesViewer_RootsDialogCaption());
                    fileChooser.setApproveButtonText(Bundle.ExternalSourcesViewer_RootsDialogButton());
                    fileChooser.setFileSelectionMode(2);
                    if (fileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0) {
                        ExternalSourcesViewer.insertFile(ExternalSourcesViewer.this.commandField, fileChooser.getSelectedFile());
                    }
                }
            };
            fileChooser.setToolTipText(Bundle.ExternalSourcesViewer_OpenRootsDialogToolTip());
            this.settingsPanel.add((Component)fileChooser);
            this.settingsPanel.add(Box.createHorizontalStrut(gap));
            PopupButton parametersPopup = new PopupButton(){

                protected void populatePopup(JPopupMenu popup) {
                    ToolPreset[] tools;
                    IdePreset[] ides;
                    for (IdePreset ide : ides = IdePreset.sorted()) {
                        final String command = ide.getCommand();
                        JMenuItem item = new JMenuItem(ide.getName()){

                            @Override
                            protected void fireActionPerformed(ActionEvent e) {
                                super.fireActionPerformed(e);
                                ExternalSourcesViewer.this.commandField.setText(command);
                            }
                        };
                        popup.add(item);
                    }
                    popup.addSeparator();
                    for (ToolPreset tool : tools = ToolPreset.sorted()) {
                        final String command = tool.getCommand();
                        JMenuItem item = new JMenuItem(tool.getName()){

                            @Override
                            protected void fireActionPerformed(ActionEvent e) {
                                super.fireActionPerformed(e);
                                ExternalSourcesViewer.this.commandField.setText(command);
                            }
                        };
                        popup.add(item);
                    }
                    popup.addSeparator();
                    SourceHandle.Feature[] features = SourceHandle.Feature.values();
                    int longestCode = 0;
                    for (SourceHandle.Feature feature : features) {
                        longestCode = Math.max(longestCode, feature.getCode().length());
                    }
                    for (SourceHandle.Feature feature : features) {
                        final String parameter = feature.getCode();
                        String val = "<html><code>" + ExternalSourcesViewer.appendSpaces(parameter, longestCode) + "&nbsp;&nbsp;</code>" + feature.getName() + "</html>";
                        JMenuItem item = new JMenuItem(val){

                            @Override
                            protected void fireActionPerformed(ActionEvent e) {
                                super.fireActionPerformed(e);
                                ExternalSourcesViewer.insertParameter(ExternalSourcesViewer.this.commandField, parameter);
                            }
                        };
                        popup.add(item);
                    }
                }
            };
            parametersPopup.setToolTipText(Bundle.ExternalSourcesViewer_InsertCommandToolTip());
            parametersPopup.setPopupAlign(1);
            this.settingsPanel.add((Component)parametersPopup);
            Dimension dim = parametersPopup.getPreferredSize();
            fileChooser.setPreferredSize(dim);
            fileChooser.setMinimumSize(dim);
            fileChooser.setMaximumSize(dim);
            if (this.forcedCommand != null) {
                this.commandField.setEditable(false);
                fileChooser.setEnabled(false);
                parametersPopup.setEnabled(false);
            }
        }
        return this.settingsPanel;
    }

    private static String appendSpaces(String string, int targetLength) {
        int spacesToAdd = targetLength - string.length();
        for (int i = 0; i < spacesToAdd; ++i) {
            string = string + "&nbsp;";
        }
        return string;
    }

    private static void insertFile(JTextField textField, File file) {
        String path = file.getAbsolutePath();
        if (path.contains(" ")) {
            path = "\"" + path + "\"";
        }
        try {
            textField.getDocument().insertString(0, path, null);
            textField.select(0, path.length());
            textField.requestFocusInWindow();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static void insertParameter(JTextField textField, String parameter) {
        Document document = textField.getDocument();
        int length = document.getLength();
        int position = textField.getCaretPosition();
        try {
            if (position > 0 && !" ".equals(document.getText(position - 1, 1))) {
                parameter = " " + parameter;
            }
            if (position < length - 1 && !" ".equals(document.getText(position, 1))) {
                parameter = parameter + " ";
            }
            textField.getDocument().insertString(position, parameter, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static enum ToolPreset {
        NOTEPAD("Notepad", "notepad.exe " + SourceHandle.Feature.FILE.getCode()),
        NOTEPADPP("Notepad++", "notepad++ -p" + SourceHandle.Feature.OFFSET.getCode() + " " + SourceHandle.Feature.FILE.getCode()),
        GEDIT("Gedit", "gedit +" + SourceHandle.Feature.LINE.getCode() + " " + SourceHandle.Feature.FILE.getCode()),
        EMACS("Emacs", "emacs +" + SourceHandle.Feature.LINE.getCode() + ":" + SourceHandle.Feature.COLUMN.getCode() + " " + SourceHandle.Feature.FILE.getCode()),
        KATE("Kate", "kate -l " + SourceHandle.Feature.LINE.getCode() + " -c " + SourceHandle.Feature.COLUMN.getCode() + " " + SourceHandle.Feature.FILE.getCode());

        private final String name;
        private final String command;

        private ToolPreset(String name, String command) {
            this.name = name;
            this.command = command;
        }

        String getName() {
            return this.name;
        }

        String getCommand() {
            return this.command;
        }

        public String toString() {
            return this.getName();
        }

        static ToolPreset[] sorted() {
            ToolPreset[] commands = ToolPreset.values();
            Arrays.sort(commands, new Comparator<ToolPreset>(){

                @Override
                public int compare(ToolPreset c1, ToolPreset c2) {
                    return c1.name.compareTo(c2.name);
                }
            });
            return commands;
        }
    }

    private static enum IdePreset {
        NETBEANS("NetBeans", "netbeans " + SourceHandle.Feature.FILE.getCode() + ":" + SourceHandle.Feature.LINE.getCode()),
        ECLIPSE("Eclipse", "eclipse " + SourceHandle.Feature.FILE.getCode() + ":" + SourceHandle.Feature.LINE.getCode()),
        IDEA("IntelliJ IDEA", "idea --line " + SourceHandle.Feature.LINE.getCode() + " --column " + SourceHandle.Feature.COLUMN.getCode() + " " + SourceHandle.Feature.FILE.getCode()),
        VSCODE("Visual Studio Code", "code -g " + SourceHandle.Feature.FILE.getCode() + ":" + SourceHandle.Feature.LINE.getCode()),
        XCODE("Xcode", "open -a Xcode " + SourceHandle.Feature.FILE.getCode());

        private final String name;
        private final String command;

        private IdePreset(String name, String command) {
            this.name = name;
            this.command = command;
        }

        String getName() {
            return this.name;
        }

        String getCommand() {
            return this.command;
        }

        public String toString() {
            return this.getName();
        }

        static IdePreset[] sorted() {
            IdePreset[] commands = IdePreset.values();
            Arrays.sort(commands, new Comparator<IdePreset>(){

                @Override
                public int compare(IdePreset c1, IdePreset c2) {
                    return c1.name.compareTo(c2.name);
                }
            });
            return commands;
        }
    }
}

