/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems.annotations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class LayerBuilder {
    private final Document doc;
    private final javax.lang.model.element.Element originatingElement;
    private final ProcessingEnvironment processingEnv;
    private final List<File> unwrittenFiles = new LinkedList<File>();

    LayerBuilder(Document document, javax.lang.model.element.Element element, ProcessingEnvironment processingEnvironment) {
        this.doc = document;
        this.originatingElement = element;
        this.processingEnv = processingEnvironment;
    }

    public File file(String string) {
        if (!string.matches("[^/]+(/[^/]+)*")) {
            throw new IllegalArgumentException(string);
        }
        File file = new File(string, false);
        this.unwrittenFiles.add(file);
        return file;
    }

    public File folder(String string) {
        File file = new File(string, true);
        this.unwrittenFiles.add(file);
        return file;
    }

    void close() {
        for (File file : this.unwrittenFiles) {
            if (file.getPath().startsWith("dummy/")) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "layer file " + file.getPath() + " was never written");
        }
        this.unwrittenFiles.clear();
    }

    public File instanceFile(String string, String string2, Class<?> clazz) throws IllegalArgumentException, LayerGenerationException {
        return this.instanceFile(string, string2, clazz, null, null);
    }

    public File instanceFile(String string, String string2, Class<?> clazz, Annotation annotation, String string3) throws IllegalArgumentException, LayerGenerationException {
        String string4;
        String[] stringArray = this.instantiableClassOrMethod(clazz, annotation, string3);
        String string5 = stringArray[0];
        String string6 = stringArray[1];
        if (string2 == null) {
            string4 = string5.replace('.', '-');
            if (string6 != null) {
                string4 = string4 + "-" + string6;
            }
        } else {
            string4 = string2;
        }
        File file = this.file(string + "/" + string4 + ".instance");
        if (string6 != null) {
            file.methodvalue("instanceCreate", string5, string6);
        } else if (string2 != null) {
            file.stringvalue("instanceClass", string5);
        }
        return file;
    }

    public File instanceFile(String string, String string2) throws IllegalArgumentException, LayerGenerationException {
        return this.instanceFile(string, string2, null, null);
    }

    public File instanceFile(String string, String string2, Annotation annotation, String string3) throws IllegalArgumentException, LayerGenerationException {
        String string4;
        String[] stringArray = this.instantiableClassOrMethod(null, annotation, string3);
        String string5 = stringArray[0];
        String string6 = stringArray[1];
        if (string2 == null) {
            string4 = string5.replace('.', '-');
            if (string6 != null) {
                string4 = string4 + "-" + string6;
            }
        } else {
            string4 = string2;
        }
        return this.file(string + "/" + string4 + ".instance");
    }

    private String[] instantiableClassOrMethod(Class<?> clazz, Annotation annotation, String string) throws IllegalArgumentException, LayerGenerationException {
        if (this.originatingElement == null) {
            throw new IllegalArgumentException("Only applicable to builders with exactly one associated element");
        }
        DeclaredType declaredType = clazz != null ? this.processingEnv.getTypeUtils().getDeclaredType(this.processingEnv.getElementUtils().getTypeElement(clazz.getName().replace('$', '.')), new TypeMirror[0]) : null;
        switch (this.originatingElement.getKind()) {
            case CLASS: {
                String string2 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.originatingElement).toString();
                if (this.originatingElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(string2 + " must not be abstract", this.originatingElement, this.processingEnv, annotation, string);
                }
                boolean bl = false;
                for (ExecutableElement executableElement : ElementFilter.constructorsIn(this.originatingElement.getEnclosedElements())) {
                    if (!executableElement.getParameters().isEmpty()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new LayerGenerationException(string2 + " must have a no-argument constructor", this.originatingElement, this.processingEnv, annotation, string);
                }
                if (declaredType != null && !this.processingEnv.getTypeUtils().isAssignable(this.originatingElement.asType(), declaredType)) {
                    throw new LayerGenerationException(string2 + " is not assignable to " + declaredType, this.originatingElement, this.processingEnv, annotation, string);
                }
                if (!this.originatingElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    throw new LayerGenerationException(string2 + " is not public", this.originatingElement, this.processingEnv, annotation, string);
                }
                if (((TypeElement)this.originatingElement).getNestingKind().isNested() && !this.originatingElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(string2 + " is nested but not static", this.originatingElement, this.processingEnv, annotation, string);
                }
                return new String[]{string2, null};
            }
            case METHOD: {
                boolean bl;
                String string3 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.originatingElement.getEnclosingElement()).toString();
                String string4 = this.originatingElement.getSimpleName().toString();
                if (!this.originatingElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(string3 + "." + string4 + " must be static", this.originatingElement, this.processingEnv, annotation, string);
                }
                List<? extends VariableElement> list = ((ExecutableElement)this.originatingElement).getParameters();
                DeclaredType declaredType2 = this.processingEnv.getTypeUtils().getDeclaredType(this.processingEnv.getElementUtils().getTypeElement("java.util.Map"), new TypeMirror[0]);
                boolean bl2 = bl = list.size() == 1 && this.processingEnv.getTypeUtils().isAssignable(list.get(0).asType(), declaredType2);
                if (!list.isEmpty() && !bl) {
                    throw new LayerGenerationException(string3 + "." + string4 + " must not take arguments", this.originatingElement, this.processingEnv, annotation, string);
                }
                if (declaredType != null && !this.processingEnv.getTypeUtils().isAssignable(((ExecutableElement)this.originatingElement).getReturnType(), declaredType)) {
                    throw new LayerGenerationException(string3 + "." + string4 + " is not assignable to " + declaredType, this.originatingElement, this.processingEnv, annotation, string);
                }
                return new String[]{string3, string4};
            }
        }
        throw new LayerGenerationException("Annotated element is not loadable as an instance", this.originatingElement, this.processingEnv, annotation, string);
    }

    public File shadowFile(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = string.replaceFirst("^.+/", "").replaceFirst("\\.[^./]+$", "");
        }
        return this.file(string2 + "/" + string3 + ".shadow").stringvalue("originalFile", string);
    }

    public FileObject validateResource(String string, javax.lang.model.element.Element element, Annotation annotation, String string2, boolean bl) throws LayerGenerationException {
        if (string.startsWith("/")) {
            throw new LayerGenerationException("do not use leading slashes on resource paths", element, this.processingEnv, annotation, string2);
        }
        if (bl) {
            for (JavaFileManager.Location location : new JavaFileManager.Location[]{StandardLocation.SOURCE_PATH, StandardLocation.CLASS_OUTPUT, StandardLocation.CLASS_PATH, StandardLocation.PLATFORM_CLASS_PATH}) {
                try {
                    FileObject fileObject = this.processingEnv.getFiler().getResource(location, "", string);
                    if (location.isOutputLocation()) {
                        fileObject.openInputStream().close();
                    }
                    return fileObject;
                }
                catch (IOException iOException) {
                }
            }
            throw new LayerGenerationException("Cannot find resource " + string, element, this.processingEnv, annotation, string2);
        }
        try {
            try {
                FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", string);
                fileObject.openInputStream().close();
                return fileObject;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", string);
                    fileObject.openInputStream().close();
                    return fileObject;
                }
                catch (IOException iOException) {
                    throw fileNotFoundException;
                }
            }
        }
        catch (IOException iOException) {
            throw new LayerGenerationException("Cannot find resource " + string, element, this.processingEnv, annotation, string2);
        }
    }

    public static String absolutizeResource(javax.lang.model.element.Element element, String string) throws LayerGenerationException {
        if (string.startsWith("/")) {
            return string.substring(1);
        }
        try {
            return new URI(null, LayerBuilder.findPackage(element).replace('.', '/') + "/", null).resolve(new URI(null, string, null)).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new LayerGenerationException(uRISyntaxException.toString(), element);
        }
    }

    private static String findPackage(javax.lang.model.element.Element element) {
        switch (element.getKind()) {
            case PACKAGE: {
                return ((PackageElement)element).getQualifiedName().toString();
            }
        }
        return LayerBuilder.findPackage(element.getEnclosingElement());
    }

    public final class File {
        private final String path;
        private final boolean folder;
        private final Map<String, String[]> attrs = new LinkedHashMap<String, String[]>();
        private String contents;
        private String url;

        File(String string, boolean bl) {
            this.path = string;
            this.folder = bl;
        }

        public String getPath() {
            return this.path;
        }

        public File contents(String string) {
            if (this.contents != null || this.url != null || string == null || this.folder) {
                throw new IllegalArgumentException();
            }
            this.contents = string;
            return this;
        }

        public File url(String string) {
            if (this.contents != null || this.url != null || string == null || this.folder) {
                throw new IllegalArgumentException();
            }
            this.url = string;
            return this;
        }

        public File stringvalue(String string, String string2) {
            this.attrs.put(string, new String[]{"stringvalue", string2});
            return this;
        }

        public File bytevalue(String string, byte by) {
            this.attrs.put(string, new String[]{"bytevalue", Byte.toString(by)});
            return this;
        }

        public File shortvalue(String string, short s) {
            this.attrs.put(string, new String[]{"shortvalue", Short.toString(s)});
            return this;
        }

        public File intvalue(String string, int n) {
            this.attrs.put(string, new String[]{"intvalue", Integer.toString(n)});
            return this;
        }

        public File longvalue(String string, long l) {
            this.attrs.put(string, new String[]{"longvalue", Long.toString(l)});
            return this;
        }

        public File floatvalue(String string, float f) {
            this.attrs.put(string, new String[]{"floatvalue", Float.toString(f)});
            return this;
        }

        public File doublevalue(String string, double d) {
            this.attrs.put(string, new String[]{"doublevalue", Double.toString(d)});
            return this;
        }

        public File boolvalue(String string, boolean bl) {
            this.attrs.put(string, new String[]{"boolvalue", Boolean.toString(bl)});
            return this;
        }

        public File charvalue(String string, char c) {
            this.attrs.put(string, new String[]{"charvalue", Character.toString(c)});
            return this;
        }

        public File urlvalue(String string, URI uRI) throws LayerGenerationException {
            if (uRI.isOpaque()) {
                throw new LayerGenerationException("Cannot use an opaque URI: " + uRI, LayerBuilder.this.originatingElement);
            }
            this.attrs.put(string, new String[]{"urlvalue", uRI.toString()});
            return this;
        }

        public File urlvalue(String string, String string2) throws LayerGenerationException {
            try {
                return this.urlvalue(string, URI.create(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new LayerGenerationException(illegalArgumentException.getLocalizedMessage(), LayerBuilder.this.originatingElement);
            }
        }

        public File methodvalue(String string, String string2, String string3) {
            this.attrs.put(string, new String[]{"methodvalue", string2 + "." + string3});
            return this;
        }

        public File newvalue(String string, String string2) {
            this.attrs.put(string, new String[]{"newvalue", string2});
            return this;
        }

        public File instanceAttribute(String string, Class<?> clazz) throws IllegalArgumentException, LayerGenerationException {
            return this.instanceAttribute(string, clazz, null, null);
        }

        public File instanceAttribute(String string, Class<?> clazz, Annotation annotation, String string2) throws IllegalArgumentException, LayerGenerationException {
            String[] stringArray = LayerBuilder.this.instantiableClassOrMethod(clazz, annotation, string2);
            if (stringArray[1] == null) {
                this.newvalue(string, stringArray[0]);
            } else {
                this.methodvalue(string, stringArray[0], stringArray[1]);
            }
            return this;
        }

        public File bundlevalue(String string, String string2, String string3) {
            this.attrs.put(string, new String[]{"bundlevalue", string2 + "#" + string3});
            return this;
        }

        public File bundlevalue(String string, String string2) throws LayerGenerationException {
            return this.bundlevalue(string, string2, null, null);
        }

        public File bundlevalue(String string, String string2, Annotation annotation, String string3) throws LayerGenerationException {
            String string4 = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
            Matcher matcher = Pattern.compile("((?:" + string4 + "\\.)+[^\\s.#]+)?#(\\S*)").matcher(string2);
            if (matcher.matches()) {
                String string5 = matcher.group(1);
                String string6 = matcher.group(2);
                if (string5 == null) {
                    javax.lang.model.element.Element element;
                    for (element = LayerBuilder.this.originatingElement; element != null && element.getKind() != ElementKind.PACKAGE; element = element.getEnclosingElement()) {
                    }
                    if (element == null) {
                        throw new LayerGenerationException("No reference element to determine package in '" + string2 + "'", LayerBuilder.this.originatingElement);
                    }
                    string5 = ((PackageElement)element).getQualifiedName() + ".Bundle";
                }
                this.verifyBundleKey(string5, string6, matcher.group(1) == null, annotation, string3);
                this.bundlevalue(string, string5, string6);
            } else {
                this.stringvalue(string, string2);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void verifyBundleKey(String string, String string2, boolean bl, Annotation annotation, String string3) throws LayerGenerationException {
            Object object;
            Object object2;
            if (LayerBuilder.this.processingEnv == null) {
                return;
            }
            if (bl) {
                for (object2 = LayerBuilder.this.originatingElement; object2 != null; object2 = object2.getEnclosingElement()) {
                    object = object2.getAnnotation(NbBundle.Messages.class);
                    if (object == null) continue;
                    for (String string4 : object.value()) {
                        if (!string4.startsWith(string2 + "=")) continue;
                        return;
                    }
                }
            }
            try {
                object2 = LayerBuilder.this.validateResource(string.replace('.', '/') + ".properties", LayerBuilder.this.originatingElement, null, null, false).openInputStream();
                try {
                    object = new Properties();
                    ((Properties)object).load((InputStream)object2);
                    if (((Properties)object).getProperty(string2) == null) {
                        throw new LayerGenerationException("No key '" + string2 + "' found in " + string, LayerBuilder.this.originatingElement, LayerBuilder.this.processingEnv, annotation, string3);
                    }
                }
                finally {
                    ((InputStream)object2).close();
                }
            }
            catch (IOException iOException) {
                throw new LayerGenerationException("Could not open " + string + ": " + iOException, LayerBuilder.this.originatingElement, LayerBuilder.this.processingEnv, annotation, string3);
            }
        }

        public File serialvalue(String string, byte[] byArray) {
            StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
            for (int n : byArray) {
                if (n >= 0 && n < 16) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(Integer.toHexString(n < 0 ? n + 256 : n));
            }
            this.attrs.put(string, new String[]{"serialvalue", stringBuilder.toString().toUpperCase(Locale.ENGLISH)});
            return this;
        }

        public File position(int n) {
            if (n != Integer.MAX_VALUE) {
                this.intvalue("position", n);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public LayerBuilder write() {
            Object object;
            void var4_7;
            Object object2;
            LayerBuilder.this.unwrittenFiles.remove(this);
            Element element = LayerBuilder.this.doc.getDocumentElement();
            String[] stringArray = this.path.split("/");
            for (String object32 : Arrays.asList(stringArray).subList(0, stringArray.length - 1)) {
                object2 = this.find(element, object32, "file|folder");
                if (object2 != null) {
                    if (!object2.getNodeName().equals("folder")) {
                        throw new IllegalArgumentException(this.path);
                    }
                    element = object2;
                    continue;
                }
                element = (Element)element.appendChild(LayerBuilder.this.doc.createElement("folder"));
                element.setAttribute("name", object32);
            }
            String string = stringArray[stringArray.length - 1];
            Element element2 = this.find(element, string, "file|folder");
            if (element2 == null) {
                Element element3 = (Element)element.appendChild(LayerBuilder.this.doc.createElement(this.folder ? "folder" : "file"));
                element3.setAttribute("name", string);
            }
            if (LayerBuilder.this.originatingElement != null) {
                boolean bl;
                switch (LayerBuilder.this.originatingElement.getKind()) {
                    case METHOD: 
                    case CONSTRUCTOR: 
                    case ENUM_CONSTANT: 
                    case FIELD: 
                    case INSTANCE_INIT: 
                    case STATIC_INIT: {
                        object2 = LayerBuilder.this.originatingElement.getEnclosingElement() + "." + LayerBuilder.this.originatingElement;
                        break;
                    }
                    default: {
                        object2 = LayerBuilder.this.originatingElement.toString();
                    }
                }
                boolean bl2 = true;
                object = var4_7.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    Node node = object.item(i);
                    if (node.getNodeType() != 8 || !node.getNodeValue().equals(object2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    var4_7.appendChild(LayerBuilder.this.doc.createComment((String)object2));
                }
            }
            for (Map.Entry entry : this.attrs.entrySet()) {
                object = this.find((Element)var4_7, (String)entry.getKey(), "attr");
                if (object != null) {
                    var4_7.removeChild((Node)object);
                }
                Element element4 = (Element)var4_7.appendChild(LayerBuilder.this.doc.createElement("attr"));
                element4.setAttribute("name", (String)entry.getKey());
                element4.setAttribute(((String[])entry.getValue())[0], ((String[])entry.getValue())[1]);
            }
            if (this.url != null) {
                var4_7.setAttribute("url", this.url);
            } else if (this.contents != null) {
                void var6_13;
                object2 = var4_7.getChildNodes();
                boolean bl = false;
                while (var6_13 < object2.getLength()) {
                    object = object2.item((int)var6_13);
                    if (object.getNodeType() == 4) {
                        var4_7.removeChild((Node)object);
                        continue;
                    }
                    ++var6_13;
                }
                var4_7.appendChild(LayerBuilder.this.doc.createCDATASection(this.contents));
            }
            return LayerBuilder.this;
        }

        private Element find(Element element, String string, String string2) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(element2 = (Element)node).getAttribute("name").equals(string) || !element2.getNodeName().matches(string2)) continue;
                return element2;
            }
            return null;
        }
    }
}

