/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import org.graalvm.visualvm.lib.jfluid.heap.HeapSummary;
import org.graalvm.visualvm.lib.jfluid.heap.HprofHeap;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

class ComputedSummary
implements HeapSummary {
    private final long bytes;
    private final long instances;
    private final long time;

    ComputedSummary(HprofHeap heap) {
        long bytesCount = 0L;
        long instancesCount = 0L;
        for (JavaClass jcls : heap.getAllClasses()) {
            instancesCount += (long)jcls.getInstancesCount();
            bytesCount += jcls.getAllInstancesSize();
        }
        this.bytes = bytesCount;
        this.instances = instancesCount;
        long headerTime = heap.dumpBuffer.getTime();
        long tagTime = heap.getHeapTime() / 1000L;
        this.time = headerTime + tagTime;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public long getTotalAllocatedBytes() {
        return -1L;
    }

    @Override
    public long getTotalAllocatedInstances() {
        return -1L;
    }

    @Override
    public long getTotalLiveBytes() {
        return this.bytes;
    }

    @Override
    public long getTotalLiveInstances() {
        return this.instances;
    }
}

