/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class PrintTable {
    private final String[] names;
    private final List<String[]> data;
    private int[] limits;

    public PrintTable(String ... stringArray) {
        this.names = stringArray;
        this.data = new ArrayList<String[]>();
    }

    public void setLimits(int ... nArray) {
        assert (nArray.length == this.names.length);
        this.limits = nArray;
    }

    public void addRow(String ... stringArray) {
        this.data.add(stringArray);
    }

    public void write(Appendable appendable) throws IOException {
        int[] nArray = new int[this.names.length];
        PrintTable.length(this.names, nArray, this.limits);
        for (String[] stringArray : this.data) {
            PrintTable.length(stringArray, nArray, this.limits);
        }
        PrintTable.printRow(appendable, this.names, nArray, this.limits);
        PrintTable.printSeparator(appendable, nArray);
        for (String[] stringArray : this.data) {
            PrintTable.printRow(appendable, stringArray, nArray, this.limits);
        }
        PrintTable.printSeparator(appendable, nArray);
    }

    private static void length(String[] stringArray, int[] nArray, int[] nArray2) {
        assert (stringArray.length == nArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].length();
            if (nArray2 != null && nArray2[i] >= 0 && n > nArray2[i]) {
                n = nArray2[i];
            }
            if (nArray[i] >= n) continue;
            nArray[i] = n;
        }
    }

    private static void printRow(Appendable appendable, String[] stringArray, int[] nArray, int[] nArray2) throws IOException {
        assert (stringArray.length == nArray.length);
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            appendable.append(string);
            String string2 = stringArray[i];
            if (nArray2 != null && nArray2[i] >= 0 && string2.length() > nArray2[i]) {
                string2 = string2.substring(0, nArray2[i]);
            }
            appendable.append(string2);
            int n = nArray[i] - string2.length();
            while (n-- > 0) {
                appendable.append(' ');
            }
            string = " ";
        }
        appendable.append('\n');
    }

    private static void printSeparator(Appendable appendable, int[] nArray) throws IOException {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            appendable.append(string);
            for (int j = 0; j < nArray[i]; ++j) {
                appendable.append('-');
            }
            string = " ";
        }
        appendable.append('\n');
    }
}

