/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.AbstractModeContainer;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;
import org.netbeans.swing.tabcontrol.customtabs.TabbedComponentFactory;
import org.netbeans.swing.tabcontrol.customtabs.TabbedType;
import org.openide.util.Lookup;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;

public final class DefaultSplitContainer
extends AbstractModeContainer {
    private final JPanel panel = new ModePanel(this);

    public DefaultSplitContainer(ModeView modeView, WindowDnDManager windowDnDManager, int n) {
        super(modeView, windowDnDManager, n);
        this.panel.add(this.tabbedHandler.getComponent(), "Center");
    }

    @Override
    public void requestAttention(TopComponent topComponent) {
        this.tabbedHandler.requestAttention(topComponent);
    }

    @Override
    public void cancelRequestAttention(TopComponent topComponent) {
        this.tabbedHandler.cancelRequestAttention(topComponent);
    }

    @Override
    public void setAttentionHighlight(TopComponent topComponent, boolean bl) {
        this.tabbedHandler.setAttentionHighlight(topComponent, bl);
    }

    @Override
    public void makeBusy(TopComponent topComponent, boolean bl) {
        this.tabbedHandler.makeBusy(topComponent, bl);
    }

    @Override
    protected Component getModeComponent() {
        return this.panel;
    }

    @Override
    protected Tabbed createTabbed() {
        TabbedComponentFactory tabbedComponentFactory = (TabbedComponentFactory)Lookup.getDefault().lookup(TabbedComponentFactory.class);
        TabbedType tabbedType = this.getKind() == 1 ? TabbedType.EDITOR : TabbedType.VIEW;
        return tabbedComponentFactory.createTabbedComponent(tabbedType, (WinsysInfoForTabbedContainer)new TabbedAdapter.WinsysInfo(this.getKind()));
    }

    @Override
    protected void updateTitle(String string) {
    }

    @Override
    protected void updateActive(boolean bl) {
        Window window;
        if (bl && (window = SwingUtilities.getWindowAncestor(this.panel)) != null && !window.isActive() && WindowManagerImpl.getInstance().getEditorAreaState() == 1) {
            window.toFront();
        }
    }

    @Override
    public boolean isActive() {
        Window window = SwingUtilities.getWindowAncestor(this.panel);
        return window != null ? window.isActive() : false;
    }

    @Override
    protected boolean isAttachingPossible() {
        return true;
    }

    @Override
    protected TopComponentDroppable getModeDroppable() {
        return (ModePanel)this.panel;
    }

    static class ModePanel
    extends JPanel
    implements ModeComponent,
    TopComponentDroppable {
        private final AbstractModeContainer abstractModeContainer;

        public ModePanel(AbstractModeContainer abstractModeContainer) {
            super(new BorderLayout());
            this.abstractModeContainer = abstractModeContainer;
            this.enableEvents(16L);
            if (UIManager.getBoolean("NbMainWindow.showCustomBackground")) {
                this.setOpaque(false);
            }
        }

        @Override
        public ModeView getModeView() {
            return this.abstractModeContainer.getModeView();
        }

        @Override
        public int getKind() {
            return this.abstractModeContainer.getKind();
        }

        @Override
        public Shape getIndicationForLocation(Point point) {
            return this.abstractModeContainer.getIndicationForLocation(point);
        }

        @Override
        public Object getConstraintForLocation(Point point) {
            return this.abstractModeContainer.getConstraintForLocation(point);
        }

        @Override
        public Component getDropComponent() {
            return this.abstractModeContainer.getDropComponent();
        }

        @Override
        public ViewElement getDropViewElement() {
            return this.abstractModeContainer.getDropModeView();
        }

        @Override
        public boolean canDrop(TopComponentDraggable topComponentDraggable, Point point) {
            return this.abstractModeContainer.canDrop(topComponentDraggable);
        }

        @Override
        public boolean supportsKind(TopComponentDraggable topComponentDraggable) {
            if (topComponentDraggable.isModeTransfer()) {
                ModeView modeView = this.getModeView();
                Mode mode = WindowManagerImpl.getInstance().findMode(modeView.getTopComponents().get(0));
                if (mode.getName().equals(topComponentDraggable.getMode().getName())) {
                    return false;
                }
            }
            if (topComponentDraggable.isAllowedToMoveAnywhere()) {
                return true;
            }
            boolean bl = topComponentDraggable.getKind() == 0 || topComponentDraggable.getKind() == 2;
            boolean bl2 = this.getKind() == 0 || this.getKind() == 2;
            return bl == bl2;
        }
    }
}

