/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingQosHandler;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlow;
import com.hivemq.client.internal.mqtt.handler.subscribe.MqttSubscriptionHandler;
import com.hivemq.client.internal.mqtt.ioc.ClientComponent;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAck;
import com.hivemq.client.rx.FlowableWithSingle;
import com.hivemq.client.rx.reactivestreams.WithSingleSubscriber;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MqttSubscribedPublishFlowable
extends FlowableWithSingle<Mqtt5Publish, Mqtt5SubAck> {
    @NotNull
    private final MqttSubscribe subscribe;
    @NotNull
    private final MqttClientConfig clientConfig;
    private final boolean manualAcknowledgement;

    public MqttSubscribedPublishFlowable(@NotNull MqttSubscribe subscribe, @NotNull MqttClientConfig clientConfig, boolean manualAcknowledgement) {
        this.subscribe = subscribe;
        this.clientConfig = clientConfig;
        this.manualAcknowledgement = manualAcknowledgement;
    }

    protected void subscribeActual(@NotNull Subscriber<? super Mqtt5Publish> subscriber) {
        ClientComponent clientComponent = this.clientConfig.getClientComponent();
        MqttIncomingQosHandler incomingQosHandler = clientComponent.incomingQosHandler();
        MqttSubscriptionHandler subscriptionHandler = clientComponent.subscriptionHandler();
        MqttSubscribedPublishFlow flow = new MqttSubscribedPublishFlow(subscriber, this.clientConfig, incomingQosHandler, this.manualAcknowledgement);
        subscriber.onSubscribe((Subscription)flow);
        subscriptionHandler.subscribe(this.subscribe, flow);
    }

    @Override
    protected void subscribeBothActual(@NotNull WithSingleSubscriber<? super Mqtt5Publish, ? super Mqtt5SubAck> subscriber) {
        this.subscribeActual(subscriber);
    }
}

