/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.session.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.traccar.model.BaseModel;

public class CacheNode {
    private BaseModel value;
    private final Map<Class<? extends BaseModel>, Set<CacheNode>> links = new ConcurrentHashMap<Class<? extends BaseModel>, Set<CacheNode>>();
    private final Map<Class<? extends BaseModel>, Set<CacheNode>> backlinks = new ConcurrentHashMap<Class<? extends BaseModel>, Set<CacheNode>>();

    public CacheNode(BaseModel value) {
        this.value = value;
    }

    public BaseModel getValue() {
        return this.value;
    }

    public void setValue(BaseModel value) {
        this.value = value;
    }

    public Set<CacheNode> getLinks(Class<? extends BaseModel> clazz, boolean forward) {
        Map<Class<? extends BaseModel>, Set<CacheNode>> map = forward ? this.links : this.backlinks;
        return map.computeIfAbsent(clazz, k -> new HashSet());
    }

    public Stream<CacheNode> getAllLinks(boolean forward) {
        Map<Class<? extends BaseModel>, Set<CacheNode>> map = forward ? this.links : this.backlinks;
        return map.values().stream().flatMap(Collection::stream);
    }
}

