/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TlvProtocolDecoder
extends BaseProtocolDecoder {
    public TlvProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, String type, String ... arguments) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeCharSequence((CharSequence)type, StandardCharsets.US_ASCII);
            for (String argument : arguments) {
                response.writeByte(argument.length());
                response.writeCharSequence((CharSequence)argument, StandardCharsets.US_ASCII);
            }
            response.writeByte(0);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private String readArgument(ByteBuf buf) {
        return buf.readSlice((int)buf.readUnsignedByte()).toString(StandardCharsets.US_ASCII);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        String type = buf.readSlice(2).toString(StandardCharsets.US_ASCII);
        if (channel != null) {
            switch (type) {
                case "0A": 
                case "0C": {
                    this.sendResponse(channel, remoteAddress, type, new String[0]);
                    break;
                }
                case "0B": {
                    this.sendResponse(channel, remoteAddress, type, "1482202689", "10", "20", "15");
                    break;
                }
                case "0E": 
                case "0F": {
                    this.sendResponse(channel, remoteAddress, type, "30", "Unknown");
                }
            }
        }
        if (type.equals("0E")) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, this.readArgument(buf));
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setValid(true);
            position.setTime(new Date(Long.parseLong(this.readArgument(buf)) * 1000L));
            this.readArgument(buf);
            position.setLongitude(Double.parseDouble(this.readArgument(buf)));
            position.setLatitude(Double.parseDouble(this.readArgument(buf)));
            position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(this.readArgument(buf))));
            position.setCourse(Double.parseDouble(this.readArgument(buf)));
            position.set("sat", Integer.parseInt(this.readArgument(buf)));
            return position;
        }
        return null;
    }
}

