/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import org.traccar.BasePipelineFactory;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;
import org.traccar.protocol.SuntechProtocolDecoder;

public class SuntechProtocolEncoder
extends StringProtocolEncoder {
    public SuntechProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object encodeCommand(Channel channel, Command command) {
        SuntechProtocolDecoder protocolDecoder;
        boolean universal = false;
        String prefix = "SA200";
        if (channel != null && (protocolDecoder = BasePipelineFactory.getHandler(channel.pipeline(), SuntechProtocolDecoder.class)) != null) {
            universal = protocolDecoder.getUniversal();
            String decoderPrefix = protocolDecoder.getPrefix();
            if (decoderPrefix != null && decoderPrefix.length() > 5) {
                prefix = decoderPrefix.substring(0, decoderPrefix.length() - 3);
            }
        }
        if (universal) {
            return this.encodeUniversalCommand(command);
        }
        return this.encodeLegacyCommand(prefix, command);
    }

    protected Object encodeUniversalCommand(Command command) {
        return switch (command.getType()) {
            case "rebootDevice" -> this.formatCommand(command, "CMD;%s;03;03\r", "uniqueId");
            case "positionSingle" -> this.formatCommand(command, "CMD;%s;03;01\r", "uniqueId");
            case "outputControl" -> {
                if (command.getAttributes().get("data").equals("1")) {
                    switch (command.getInteger("index")) {
                        case 1: {
                            yield this.formatCommand(command, "CMD;%s;04;01\r", "uniqueId");
                        }
                        case 2: {
                            yield this.formatCommand(command, "CMD;%s;04;03\r", "uniqueId");
                        }
                        case 3: {
                            yield this.formatCommand(command, "CMD;%s;04;09\r", "uniqueId");
                        }
                    }
                    yield null;
                }
                switch (command.getInteger("index")) {
                    case 1: {
                        yield this.formatCommand(command, "CMD;%s;04;02\r", "uniqueId");
                    }
                    case 2: {
                        yield this.formatCommand(command, "CMD;%s;04;04\r", "uniqueId");
                    }
                    case 3: {
                        yield this.formatCommand(command, "CMD;%s;04;10\r", "uniqueId");
                    }
                }
                yield null;
            }
            case "engineStop" -> this.formatCommand(command, "CMD;%s;04;01\r", "uniqueId");
            case "engineResume" -> this.formatCommand(command, "CMD;%s;04;02\r", "uniqueId");
            case "alarmArm" -> this.formatCommand(command, "CMD;%s;04;03\r", "uniqueId");
            case "alarmDisarm" -> this.formatCommand(command, "CMD;%s;04;04\r", "uniqueId");
            default -> null;
        };
    }

    protected Object encodeLegacyCommand(String prefix, Command command) {
        return switch (command.getType()) {
            case "rebootDevice" -> this.formatCommand(command, prefix + "CMD;%s;02;Reboot\r", "uniqueId");
            case "positionSingle" -> this.formatCommand(command, prefix + "CMD;%s;02;StatusReq\r", "uniqueId");
            case "outputControl" -> {
                if (command.getAttributes().get("data").equals("1")) {
                    yield this.formatCommand(command, prefix + "CMD;%s;02;Enable%s\r", "uniqueId", "index");
                }
                yield this.formatCommand(command, prefix + "CMD;%s;02;Disable%s\r", "uniqueId", "index");
            }
            case "engineStop" -> this.formatCommand(command, prefix + "CMD;%s;02;Enable1\r", "uniqueId");
            case "engineResume" -> this.formatCommand(command, prefix + "CMD;%s;02;Disable1\r", "uniqueId");
            case "alarmArm" -> this.formatCommand(command, prefix + "CMD;%s;02;Enable2\r", "uniqueId");
            case "alarmDisarm" -> this.formatCommand(command, prefix + "CMD;%s;02;Disable2\r", "uniqueId");
            default -> null;
        };
    }
}

