/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class SanavProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().expression("imei[:=]").number("(d+)").expression("&?rmc[:=]").text("$GPRMC,").number("(dd)(dd)(dd).d+,").expression("([AV]),").number("(d+)(dd.d+),").expression("([NS]),").number("(d+)(dd.d+),").expression("([EW]),").number("(d+.d+),").number("(d+.d+)?,").number("(dd)(dd)(dd),").groupBegin().expression("[^*]*").text("*").number("xx,").expression("[^,]+,").number("(d+),").groupEnd("?").any().compile();

    public SanavProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble());
        position.setCourse(parser.nextDouble(0.0));
        dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setTime(dateBuilder.getDate());
        if (parser.hasNext()) {
            int io = parser.nextHexInt();
            for (int i = 0; i < 5; ++i) {
                position.set("in" + (i + 1), BitUtil.check(io, i));
            }
            position.set("ignition", BitUtil.check(io, 5));
            position.set("out1", BitUtil.check(io, 6));
            position.set("out2", BitUtil.check(io, 7));
            position.set("charge", BitUtil.check(io, 8));
            if (!BitUtil.check(io, 9)) {
                position.addAlarm("lowBattery");
            }
        }
        return position;
    }
}

