/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class FoxProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number("(d+),").expression("([AV]),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(dd)(dd.d+),").expression("([NS]),").number("(ddd)(dd.d+),").expression("([EW]),").number("(d+.?d*)?,").number("(d+.?d*)?,").expression("[^,]*,").number("([01]+) ").number("(d+) ").number("(d+) ").number("(d+) ").number("(d+) ").number("(d+) ").number("(d+) ").number("([01]+) ").number("(d+),").expression("(.+)").compile();

    public FoxProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String getAttribute(String xml, String key) {
        int end;
        int start = xml.indexOf(key + "=\"");
        if (start != -1 && (end = xml.indexOf("\"", start += key.length() + 2)) != -1) {
            return xml.substring(start, end);
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String xml = (String)msg;
        String id = this.getAttribute(xml, "id");
        String data = this.getAttribute(xml, "data");
        if (id != null && data != null) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
            if (deviceSession == null) {
                return null;
            }
            Parser parser = new Parser(PATTERN, data);
            if (!parser.matches()) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("status", parser.nextInt(0));
            position.setValid(parser.next().equals("A"));
            position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
            position.setLatitude(parser.nextCoordinate());
            position.setLongitude(parser.nextCoordinate());
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
            position.setCourse(parser.nextDouble(0.0));
            position.set("input", parser.nextBinInt(0));
            position.set("power", parser.nextDouble(0.0) * 0.1);
            position.set("temp1", parser.nextInt(0));
            position.set("rpm", parser.nextInt(0));
            position.set("fuel", parser.nextInt(0));
            position.set("adc1", parser.nextInt(0));
            position.set("adc2", parser.nextInt(0));
            position.set("output", parser.nextBinInt(0));
            position.set("odometer", parser.nextInt(0));
            position.set("statusData", parser.next());
            return position;
        }
        return null;
    }
}

