/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.security;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import org.traccar.api.security.CodeRequiredException;
import org.traccar.api.security.LoginResult;
import org.traccar.api.security.ServiceAccountUser;
import org.traccar.api.signature.TokenManager;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.LdapProvider;
import org.traccar.helper.DataConverter;
import org.traccar.helper.model.UserUtil;
import org.traccar.model.User;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class LoginService {
    private final Config config;
    private final Storage storage;
    private final TokenManager tokenManager;
    private final LdapProvider ldapProvider;
    private final String serviceAccountToken;
    private final boolean forceLdap;
    private final boolean forceOpenId;

    @Inject
    public LoginService(Config config, Storage storage, TokenManager tokenManager, @Nullable LdapProvider ldapProvider) {
        this.storage = storage;
        this.config = config;
        this.tokenManager = tokenManager;
        this.ldapProvider = ldapProvider;
        this.serviceAccountToken = config.getString(Keys.WEB_SERVICE_ACCOUNT_TOKEN);
        this.forceLdap = config.getBoolean(Keys.LDAP_FORCE);
        this.forceOpenId = config.getBoolean(Keys.OPENID_FORCE);
    }

    public LoginResult login(String scheme, String credentials) throws StorageException, GeneralSecurityException, IOException {
        switch (scheme.toLowerCase()) {
            case "bearer": {
                return this.login(credentials);
            }
            case "basic": {
                byte[] decodedBytes = DataConverter.parseBase64(credentials);
                String[] auth = new String(decodedBytes, StandardCharsets.US_ASCII).split(":", 2);
                return this.login(auth[0], auth[1], null);
            }
        }
        throw new SecurityException("Unsupported authorization scheme");
    }

    public LoginResult login(String token) throws StorageException, GeneralSecurityException, IOException {
        if (this.serviceAccountToken != null && this.serviceAccountToken.equals(token)) {
            return new LoginResult(new ServiceAccountUser());
        }
        TokenManager.TokenData tokenData = this.tokenManager.verifyToken(token);
        User user = this.storage.getObject(User.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", tokenData.getUserId())));
        if (user != null) {
            this.checkUserEnabled(user);
        }
        return new LoginResult(user, tokenData.getExpiration());
    }

    public LoginResult login(String email, String password, Integer code) throws StorageException {
        if (this.forceOpenId) {
            return null;
        }
        User user = this.storage.getObject(User.class, new Request((Columns)new Columns.All(), new Condition.Or(new Condition.Equals("email", email = email.trim()), new Condition.Equals("login", email))));
        if (user != null) {
            if (this.ldapProvider != null && user.getLogin() != null && this.ldapProvider.login(user.getLogin(), password) || !this.forceLdap && user.isPasswordValid(password)) {
                this.checkUserCode(user, code);
                this.checkUserEnabled(user);
                return new LoginResult(user);
            }
        } else if (this.ldapProvider != null && this.ldapProvider.login(email, password)) {
            user = this.ldapProvider.getUser(email);
            user.setId(this.storage.addObject(user, new Request(new Columns.Exclude("id"))));
            this.checkUserEnabled(user);
            return new LoginResult(user);
        }
        return null;
    }

    public LoginResult login(String email, String name, boolean administrator) throws StorageException {
        User user = this.storage.getObject(User.class, new Request((Columns)new Columns.All(), new Condition.Equals("email", email)));
        if (user == null) {
            user = new User();
            UserUtil.setUserDefaults(user, this.config);
            user.setName(name);
            user.setEmail(email);
            user.setFixedEmail(true);
            user.setAdministrator(administrator);
            user.setId(this.storage.addObject(user, new Request(new Columns.Exclude("id"))));
        }
        this.checkUserEnabled(user);
        return new LoginResult(user);
    }

    private void checkUserEnabled(User user) throws SecurityException {
        if (user == null) {
            throw new SecurityException("Unknown account");
        }
        user.checkDisabled();
    }

    private void checkUserCode(User user, Integer code) throws SecurityException {
        String key = user.getTotpKey();
        if (key != null && !key.isEmpty()) {
            if (code == null) {
                throw new CodeRequiredException();
            }
            GoogleAuthenticator authenticator = new GoogleAuthenticator();
            if (!authenticator.authorize(key, code)) {
                throw new SecurityException("User authorization failed");
            }
        }
    }
}

