/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import redis.clients.jedis.Builder;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Connection;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.util.Pool;

public abstract class JedisCommandIterationBase<B, D> {
    private final Builder<B> builder;
    private final Queue<Map.Entry> connections;
    private Map.Entry connection;
    private B lastReply;
    private boolean roundRobinCompleted;
    private boolean iterationCompleted;

    protected JedisCommandIterationBase(ConnectionProvider connectionProvider, Builder<B> responseBuilder) {
        Map<?, ?> connectionMap = connectionProvider.getConnectionMap();
        ArrayList connectionList = new ArrayList(connectionMap.entrySet());
        Collections.shuffle(connectionList);
        this.connections = new LinkedList(connectionList);
        this.builder = responseBuilder;
        this.iterationCompleted = true;
        this.roundRobinCompleted = this.connections.isEmpty();
    }

    public final boolean isIterationCompleted() {
        return this.roundRobinCompleted;
    }

    protected abstract boolean isNodeCompleted(B var1);

    protected abstract CommandArguments initCommandArguments();

    protected abstract CommandArguments nextCommandArguments(B var1);

    public final B nextBatch() {
        Object rawReply;
        CommandArguments args;
        if (this.roundRobinCompleted) {
            throw new NoSuchElementException();
        }
        if (this.iterationCompleted) {
            this.connection = this.connections.poll();
            args = this.initCommandArguments();
        } else {
            args = this.nextCommandArguments(this.lastReply);
        }
        if (this.connection.getValue() instanceof Connection) {
            rawReply = ((Connection)this.connection.getValue()).executeCommand(args);
        } else if (this.connection.getValue() instanceof Pool) {
            try (Connection c = (Connection)((Pool)((Object)this.connection.getValue())).getResource();){
                rawReply = c.executeCommand(args);
            }
        } else {
            throw new IllegalArgumentException(this.connection.getValue().getClass() + "is not supported.");
        }
        this.lastReply = this.builder.build(rawReply);
        this.iterationCompleted = this.isNodeCompleted(this.lastReply);
        if (this.iterationCompleted && this.connections.isEmpty()) {
            this.roundRobinCompleted = true;
        }
        return this.lastReply;
    }

    protected abstract Collection<D> convertBatchToData(B var1);

    public final Collection<D> nextBatchList() {
        return this.convertBatchToData(this.nextBatch());
    }

    public final Collection<D> collect(Collection<D> c) {
        while (!this.isIterationCompleted()) {
            c.addAll(this.nextBatchList());
        }
        return c;
    }
}

