/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.InternalExtensionOnly;
import com.google.common.base.Preconditions;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TransactionOptions {
    private static final TransactionOptions DEFAULT_READ_WRITE_TRANSACTION_OPTIONS = TransactionOptions.createReadWriteOptionsBuilder().build();
    private static final int DEFAULT_NUM_ATTEMPTS = 5;
    private final Executor executor;
    private final TransactionOptionsType type;
    private final int numberOfAttempts;
    @Nullable
    private final Timestamp readTime;

    TransactionOptions(Executor executor, TransactionOptionsType type, int numberOfAttempts, @Nullable Timestamp readTime) {
        this.executor = executor;
        this.type = type;
        this.numberOfAttempts = numberOfAttempts;
        this.readTime = readTime;
    }

    public int getNumberOfAttempts() {
        return this.numberOfAttempts;
    }

    @Nullable
    public Executor getExecutor() {
        return this.executor;
    }

    @Nonnull
    public TransactionOptionsType getType() {
        return this.type;
    }

    @Nullable
    public Timestamp getReadTime() {
        if (TransactionOptionsType.READ_ONLY.equals((Object)this.type)) {
            return this.readTime;
        }
        return null;
    }

    @Nonnull
    public static TransactionOptions create() {
        return DEFAULT_READ_WRITE_TRANSACTION_OPTIONS;
    }

    @Nonnull
    @Deprecated
    public static TransactionOptions create(int numberOfAttempts) {
        return TransactionOptions.createReadWriteOptionsBuilder().setNumberOfAttempts(numberOfAttempts).build();
    }

    @Nonnull
    @Deprecated
    public static TransactionOptions create(@Nullable Executor executor) {
        return ((ReadWriteOptionsBuilder)TransactionOptions.createReadWriteOptionsBuilder().setExecutor(executor)).build();
    }

    @Nonnull
    @Deprecated
    public static TransactionOptions create(@Nullable Executor executor, int numberOfAttempts) {
        return ((ReadWriteOptionsBuilder)TransactionOptions.createReadWriteOptionsBuilder().setExecutor(executor)).setNumberOfAttempts(numberOfAttempts).build();
    }

    @Nonnull
    public static ReadWriteOptionsBuilder createReadWriteOptionsBuilder() {
        return new ReadWriteOptionsBuilder(null, 5);
    }

    @Nonnull
    public static ReadOnlyOptionsBuilder createReadOnlyOptionsBuilder() {
        return new ReadOnlyOptionsBuilder(null, null);
    }

    public static enum TransactionOptionsType {
        READ_ONLY,
        READ_WRITE;

    }

    public static final class ReadWriteOptionsBuilder
    extends Builder<ReadWriteOptionsBuilder> {
        private int numberOfAttempts;

        private ReadWriteOptionsBuilder(@Nullable Executor executor, int numberOfAttempts) {
            super(executor);
            this.numberOfAttempts = numberOfAttempts;
        }

        public int getNumberOfAttempts() {
            return this.numberOfAttempts;
        }

        @Nonnull
        public ReadWriteOptionsBuilder setNumberOfAttempts(int numberOfAttempts) {
            Preconditions.checkArgument((numberOfAttempts > 0 ? 1 : 0) != 0, (Object)"You must allow at least one attempt");
            this.numberOfAttempts = numberOfAttempts;
            return this;
        }

        @Override
        @Nonnull
        public TransactionOptions build() {
            return new TransactionOptions(this.executor, TransactionOptionsType.READ_WRITE, this.numberOfAttempts, null);
        }
    }

    @InternalExtensionOnly
    public static abstract class Builder<B extends Builder<B>> {
        @Nullable
        protected Executor executor;

        protected Builder(@Nullable Executor executor) {
            this.executor = executor;
        }

        @Nullable
        public Executor getExecutor() {
            return this.executor;
        }

        @Nonnull
        public B setExecutor(@Nullable Executor executor) {
            this.executor = executor;
            return (B)this;
        }

        @Nonnull
        public abstract TransactionOptions build();
    }

    public static final class ReadOnlyOptionsBuilder
    extends Builder<ReadOnlyOptionsBuilder> {
        @Nullable
        private TimestampOrBuilder readTime;

        private ReadOnlyOptionsBuilder(@Nullable Executor executor, @Nullable Timestamp readTime) {
            super(executor);
            this.readTime = readTime;
        }

        @Nullable
        public TimestampOrBuilder getReadTime() {
            return this.readTime;
        }

        @Nonnull
        public ReadOnlyOptionsBuilder setReadTime(@Nullable TimestampOrBuilder readTime) {
            this.readTime = readTime;
            return this;
        }

        @Override
        @Nonnull
        public TransactionOptions build() {
            Timestamp timestamp = this.readTime != null && this.readTime instanceof Timestamp.Builder ? ((Timestamp.Builder)this.readTime).build() : (Timestamp)this.readTime;
            return new TransactionOptions(this.executor, TransactionOptionsType.READ_ONLY, 1, timestamp);
        }
    }
}

