/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.internal.UserAgentUtils;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse;
import software.amazon.awssdk.services.sns.model.PlatformApplication;

public class ListPlatformApplicationsPublisher
implements SdkPublisher<ListPlatformApplicationsResponse> {
    private final SnsAsyncClient client;
    private final ListPlatformApplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlatformApplicationsPublisher(SnsAsyncClient client, ListPlatformApplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlatformApplicationsPublisher(SnsAsyncClient client, ListPlatformApplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlatformApplicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlatformApplicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PlatformApplication> platformApplications() {
        Function<ListPlatformApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.platformApplications() != null) {
                return response.platformApplications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPlatformApplicationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPlatformApplicationsResponseFetcher
    implements AsyncPageFetcher<ListPlatformApplicationsResponse> {
        private ListPlatformApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlatformApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPlatformApplicationsResponse> nextPage(ListPlatformApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListPlatformApplicationsPublisher.this.client.listPlatformApplications(ListPlatformApplicationsPublisher.this.firstRequest);
            }
            return ListPlatformApplicationsPublisher.this.client.listPlatformApplications((ListPlatformApplicationsRequest)((Object)ListPlatformApplicationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

