/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.IOException;
import java.net.URL;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CloseableVerificationKeyResolver;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JwksFileVerificationKeyResolver;
import org.apache.kafka.common.security.oauthbearer.internals.secured.RefreshingHttpsJwks;
import org.apache.kafka.common.security.oauthbearer.internals.secured.RefreshingHttpsJwksVerificationKeyResolver;
import org.apache.kafka.common.utils.Time;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.UnresolvableKeyException;

public class VerificationKeyResolverFactory {
    private static final Map<VerificationKeyResolverKey, CloseableVerificationKeyResolver> CACHE = new HashMap<VerificationKeyResolverKey, CloseableVerificationKeyResolver>();

    public static synchronized CloseableVerificationKeyResolver get(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        VerificationKeyResolverKey key = new VerificationKeyResolverKey(configs, saslMechanism, jaasConfigEntries);
        return CACHE.computeIfAbsent(key, k -> new RefCountingVerificationKeyResolver(VerificationKeyResolverFactory.create(configs, saslMechanism, jaasConfigEntries)));
    }

    static CloseableVerificationKeyResolver create(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        CloseableVerificationKeyResolver resolver;
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        URL jwksEndpointUrl = cu.validateUrl("sasl.oauthbearer.jwks.endpoint.url");
        if (jwksEndpointUrl.getProtocol().toLowerCase(Locale.ROOT).equals("file")) {
            resolver = new JwksFileVerificationKeyResolver();
        } else {
            long refreshIntervalMs = cu.validateLong("sasl.oauthbearer.jwks.endpoint.refresh.ms", true, 0L);
            JaasOptionsUtils jou = new JaasOptionsUtils(saslMechanism, jaasConfigEntries);
            SSLSocketFactory sslSocketFactory = null;
            if (jou.shouldCreateSSLSocketFactory(jwksEndpointUrl)) {
                sslSocketFactory = jou.createSSLSocketFactory();
            }
            HttpsJwks httpsJwks = new HttpsJwks(jwksEndpointUrl.toString());
            httpsJwks.setDefaultCacheDuration(refreshIntervalMs);
            if (sslSocketFactory != null) {
                Get get = new Get();
                get.setSslSocketFactory(sslSocketFactory);
                httpsJwks.setSimpleHttpGet((SimpleGet)get);
            }
            RefreshingHttpsJwks refreshingHttpsJwks = new RefreshingHttpsJwks(Time.SYSTEM, httpsJwks, refreshIntervalMs, cu.validateLong("sasl.oauthbearer.jwks.endpoint.retry.backoff.ms"), cu.validateLong("sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms"));
            resolver = new RefreshingHttpsJwksVerificationKeyResolver(refreshingHttpsJwks);
        }
        resolver.configure(configs, saslMechanism, jaasConfigEntries);
        return resolver;
    }

    private static class VerificationKeyResolverKey {
        private final Map<String, ?> configs;
        private final String saslMechanism;
        private final Map<String, Object> moduleOptions;

        public VerificationKeyResolverKey(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
            this.configs = configs;
            this.saslMechanism = saslMechanism;
            this.moduleOptions = JaasOptionsUtils.getOptions(saslMechanism, jaasConfigEntries);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VerificationKeyResolverKey that = (VerificationKeyResolverKey)o;
            return this.configs.equals(that.configs) && this.saslMechanism.equals(that.saslMechanism) && this.moduleOptions.equals(that.moduleOptions);
        }

        public int hashCode() {
            return Objects.hash(this.configs, this.saslMechanism, this.moduleOptions);
        }
    }

    private static class RefCountingVerificationKeyResolver
    implements CloseableVerificationKeyResolver {
        private final CloseableVerificationKeyResolver delegate;
        private final AtomicInteger count = new AtomicInteger(0);

        public RefCountingVerificationKeyResolver(CloseableVerificationKeyResolver delegate) {
            this.delegate = delegate;
        }

        public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
            return this.delegate.resolveKey(jws, nestingContext);
        }

        @Override
        public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
            if (this.count.incrementAndGet() == 1) {
                this.delegate.configure(configs, saslMechanism, jaasConfigEntries);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.count.decrementAndGet() == 0) {
                this.delegate.close();
            }
        }
    }
}

