/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.message.DescribeShareGroupOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeShareGroupOffsetsResponse
extends AbstractResponse {
    private final DescribeShareGroupOffsetsResponseData data;
    private final Map<String, Throwable> groupLevelErrors = new HashMap<String, Throwable>();

    public DescribeShareGroupOffsetsResponse(DescribeShareGroupOffsetsResponseData data) {
        super(ApiKeys.DESCRIBE_SHARE_GROUP_OFFSETS);
        this.data = data;
        for (DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup group : data.groups()) {
            if (group.errorCode() == Errors.NONE.code()) continue;
            this.groupLevelErrors.put(group.groupId(), Errors.forCode(group.errorCode()).exception(group.errorMessage()));
        }
    }

    public DescribeShareGroupOffsetsResponse(int throttleTimeMs, List<String> groupIds, Throwable allGroupsException) {
        super(ApiKeys.DESCRIBE_SHARE_GROUP_OFFSETS);
        short errorCode = Errors.forException(allGroupsException).code();
        ArrayList<DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup> groupList = new ArrayList<DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup>();
        groupIds.forEach(groupId -> {
            groupList.add(new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup().setGroupId((String)groupId).setErrorCode(errorCode).setErrorMessage(errorCode == Errors.UNKNOWN_SERVER_ERROR.code() ? Errors.forCode(errorCode).message() : allGroupsException.getMessage()));
            this.groupLevelErrors.put((String)groupId, allGroupsException);
        });
        this.data = new DescribeShareGroupOffsetsResponseData().setThrottleTimeMs(throttleTimeMs).setGroups(groupList);
    }

    public boolean hasGroupError(String groupId) {
        return this.groupLevelErrors.containsKey(groupId);
    }

    public Throwable groupError(String groupId) {
        return this.groupLevelErrors.get(groupId);
    }

    @Override
    public DescribeShareGroupOffsetsResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        this.groupLevelErrors.values().forEach(exception -> DescribeShareGroupOffsetsResponse.updateErrorCounts(counts, Errors.forException(exception)));
        for (DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup group : this.data.groups()) {
            group.topics().forEach(topic -> topic.partitions().forEach(partition -> DescribeShareGroupOffsetsResponse.updateErrorCounts(counts, Errors.forCode(partition.errorCode()))));
        }
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static DescribeShareGroupOffsetsResponse parse(Readable readable, short version) {
        return new DescribeShareGroupOffsetsResponse(new DescribeShareGroupOffsetsResponseData(readable, version));
    }
}

