/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class StreamsGroupMemberAssignment {
    private final List<TaskIds> activeTasks;
    private final List<TaskIds> standbyTasks;
    private final List<TaskIds> warmupTasks;

    public StreamsGroupMemberAssignment(List<TaskIds> activeTasks, List<TaskIds> standbyTasks, List<TaskIds> warmupTasks) {
        this.activeTasks = activeTasks;
        this.standbyTasks = standbyTasks;
        this.warmupTasks = warmupTasks;
    }

    public List<TaskIds> activeTasks() {
        return List.copyOf(this.activeTasks);
    }

    public List<TaskIds> standbyTasks() {
        return List.copyOf(this.standbyTasks);
    }

    public List<TaskIds> warmupTasks() {
        return List.copyOf(this.warmupTasks);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamsGroupMemberAssignment that = (StreamsGroupMemberAssignment)o;
        return Objects.equals(this.activeTasks, that.activeTasks) && Objects.equals(this.standbyTasks, that.standbyTasks) && Objects.equals(this.warmupTasks, that.warmupTasks);
    }

    public int hashCode() {
        return Objects.hash(this.activeTasks, this.standbyTasks, this.warmupTasks);
    }

    public String toString() {
        return "(activeTasks=" + this.activeTasks.stream().map(TaskIds::toString).collect(Collectors.joining(",")) + ", standbyTasks=" + this.standbyTasks.stream().map(TaskIds::toString).collect(Collectors.joining(",")) + ", warmupTasks=" + this.warmupTasks.stream().map(TaskIds::toString).collect(Collectors.joining(",")) + ")";
    }

    public static class TaskIds {
        private final String subtopologyId;
        private final List<Integer> partitions;

        public TaskIds(String subtopologyId, List<Integer> partitions) {
            this.subtopologyId = Objects.requireNonNull(subtopologyId, "subtopologyId must be non-null");
            this.partitions = Objects.requireNonNull(partitions, "partitions must be non-null");
        }

        public String subtopologyId() {
            return this.subtopologyId;
        }

        public List<Integer> partitions() {
            return List.copyOf(this.partitions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskIds taskIds = (TaskIds)o;
            return Objects.equals(this.subtopologyId, taskIds.subtopologyId) && Objects.equals(this.partitions, taskIds.partitions);
        }

        public int hashCode() {
            return Objects.hash(this.subtopologyId, this.partitions);
        }

        public String toString() {
            return this.partitions.stream().map(x -> this.subtopologyId + "_" + x).collect(Collectors.joining(","));
        }
    }
}

