/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.storage.BaseObjectReadSessionStreamRead;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.IOAutoCloseable;
import com.google.cloud.storage.RangeSpec;
import com.google.cloud.storage.ResponseContentLifecycleHandle;
import com.google.cloud.storage.RetryContext;
import com.google.storage.v2.ReadRange;
import java.io.IOException;

@InternalApi
@InternalExtensionOnly
interface ObjectReadSessionStreamRead<Projection>
extends IOAutoCloseable {
    public Projection project();

    public long readOffset();

    public boolean acceptingBytes();

    public void accept(ResponseContentLifecycleHandle.ChildRef var1) throws IOException;

    public void eof() throws IOException;

    public void preFail();

    public ApiFuture<?> fail(Throwable var1);

    public ObjectReadSessionStreamRead<Projection> withNewReadId(long var1);

    public ReadRange makeReadRange();

    public <T extends Throwable> void recordError(T var1, RetryContext.OnSuccess var2, RetryContext.OnFailure<T> var3);

    public boolean readyToSend();

    public Hasher hasher();

    public boolean canShareStreamWith(ObjectReadSessionStreamRead<?> var1);

    public void setOnCloseCallback(IOAutoCloseable var1);

    public void internalClose() throws IOException;

    public static BaseObjectReadSessionStreamRead.AccumulatingRead<byte[]> createByteArrayAccumulatingRead(long readId, RangeSpec rangeSpec, Hasher hasher, RetryContext retryContext) {
        return new BaseObjectReadSessionStreamRead.ByteArrayAccumulatingRead(readId, rangeSpec, hasher, retryContext, IOAutoCloseable.noOp());
    }

    public static BaseObjectReadSessionStreamRead.ZeroCopyByteStringAccumulatingRead createZeroCopyByteStringAccumulatingRead(long readId, RangeSpec rangeSpec, Hasher hasher, RetryContext retryContext) {
        return new BaseObjectReadSessionStreamRead.ZeroCopyByteStringAccumulatingRead(readId, rangeSpec, hasher, retryContext, IOAutoCloseable.noOp());
    }

    public static BaseObjectReadSessionStreamRead.StreamingRead streamingRead(long readId, RangeSpec rangeSpec, Hasher hasher, RetryContext retryContext) {
        return new BaseObjectReadSessionStreamRead.StreamingRead(readId, rangeSpec, hasher, retryContext, IOAutoCloseable.noOp());
    }
}

