/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.gax.batching.AutoValue_DefaultBatchResource;
import com.google.api.gax.batching.BatchResource;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
abstract class DefaultBatchResource
implements BatchResource {
    DefaultBatchResource() {
    }

    static Builder builder() {
        return new AutoValue_DefaultBatchResource.Builder();
    }

    @Override
    public BatchResource add(BatchResource resource) {
        Preconditions.checkArgument((boolean)(resource instanceof DefaultBatchResource), (Object)("Expect an instance of DefaultBatchResource, got " + resource.getClass()));
        DefaultBatchResource defaultResource = (DefaultBatchResource)resource;
        return new AutoValue_DefaultBatchResource.Builder().setElementCount(this.getElementCount() + defaultResource.getElementCount()).setByteCount(this.getByteCount() + defaultResource.getByteCount()).build();
    }

    @Override
    public abstract long getElementCount();

    @Override
    public abstract long getByteCount();

    @Override
    public boolean shouldFlush(long maxElementThreshold, long maxBytesThreshold) {
        return this.getElementCount() > maxElementThreshold || this.getByteCount() > maxBytesThreshold;
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setElementCount(long var1);

        abstract Builder setByteCount(long var1);

        abstract DefaultBatchResource build();
    }
}

