/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.firebase.auth.UserIdentifier;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.GetAccountInfoRequest;
import com.google.firebase.internal.NonNull;

public final class PhoneIdentifier
extends UserIdentifier {
    private final String phoneNumber;

    public PhoneIdentifier(@NonNull String phoneNumber) {
        UserRecord.checkPhoneNumber(phoneNumber);
        this.phoneNumber = phoneNumber;
    }

    @Override
    public String toString() {
        return "PhoneIdentifier(" + this.phoneNumber + ")";
    }

    @Override
    void populate(@NonNull GetAccountInfoRequest payload) {
        payload.addPhoneNumber(this.phoneNumber);
    }

    @Override
    boolean matches(@NonNull UserRecord userRecord) {
        return this.phoneNumber.equals(userRecord.getPhoneNumber());
    }
}

