/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firebase.FirebaseApp;
import com.google.firebase.internal.NonNull;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;

public abstract class ThreadManager {
    @NonNull
    final FirebaseExecutors getFirebaseExecutors(@NonNull FirebaseApp app) {
        return new FirebaseExecutors(this.getExecutor(app));
    }

    final void releaseFirebaseExecutors(@NonNull FirebaseApp app, @NonNull FirebaseExecutors executor) {
        this.releaseExecutor(app, executor.userExecutor);
    }

    @NonNull
    protected abstract ExecutorService getExecutor(@NonNull FirebaseApp var1);

    protected abstract void releaseExecutor(@NonNull FirebaseApp var1, @NonNull ExecutorService var2);

    @NonNull
    protected abstract ThreadFactory getThreadFactory();

    static final class FirebaseExecutors {
        private final ExecutorService userExecutor;
        private final ListeningExecutorService listeningExecutor;

        private FirebaseExecutors(ExecutorService userExecutor) {
            this.userExecutor = (ExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"ExecutorService must not be null");
            this.listeningExecutor = MoreExecutors.listeningDecorator((ExecutorService)userExecutor);
        }

        ListeningExecutorService getListeningExecutor() {
            return this.listeningExecutor;
        }
    }
}

