/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Intersection;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class LineSegment
implements Comparable,
Serializable {
    private static final long serialVersionUID = 3252005833466256227L;
    public Coordinate p0;
    public Coordinate p1;

    public LineSegment(Coordinate p0, Coordinate p1) {
        this.p0 = p0;
        this.p1 = p1;
    }

    public LineSegment(double x0, double y0, double x1, double y1) {
        this(new Coordinate(x0, y0), new Coordinate(x1, y1));
    }

    public LineSegment(LineSegment ls) {
        this(ls.p0, ls.p1);
    }

    public LineSegment() {
        this(new Coordinate(), new Coordinate());
    }

    public Coordinate getCoordinate(int i) {
        if (i == 0) {
            return this.p0;
        }
        return this.p1;
    }

    public void setCoordinates(LineSegment ls) {
        this.setCoordinates(ls.p0, ls.p1);
    }

    public void setCoordinates(Coordinate p0, Coordinate p1) {
        this.p0.x = p0.x;
        this.p0.y = p0.y;
        this.p1.x = p1.x;
        this.p1.y = p1.y;
    }

    public double minX() {
        return Math.min(this.p0.x, this.p1.x);
    }

    public double maxX() {
        return Math.max(this.p0.x, this.p1.x);
    }

    public double minY() {
        return Math.min(this.p0.y, this.p1.y);
    }

    public double maxY() {
        return Math.max(this.p0.y, this.p1.y);
    }

    public double getLength() {
        return this.p0.distance(this.p1);
    }

    public boolean isHorizontal() {
        return this.p0.y == this.p1.y;
    }

    public boolean isVertical() {
        return this.p0.x == this.p1.x;
    }

    public int orientationIndex(LineSegment seg) {
        int orient0 = Orientation.index(this.p0, this.p1, seg.p0);
        int orient1 = Orientation.index(this.p0, this.p1, seg.p1);
        if (orient0 >= 0 && orient1 >= 0) {
            return Math.max(orient0, orient1);
        }
        if (orient0 <= 0 && orient1 <= 0) {
            return Math.min(orient0, orient1);
        }
        return 0;
    }

    public int orientationIndex(Coordinate p) {
        return Orientation.index(this.p0, this.p1, p);
    }

    public void reverse() {
        Coordinate temp = this.p0;
        this.p0 = this.p1;
        this.p1 = temp;
    }

    public void normalize() {
        if (this.p1.compareTo(this.p0) < 0) {
            this.reverse();
        }
    }

    public double angle() {
        return Math.atan2(this.p1.y - this.p0.y, this.p1.x - this.p0.x);
    }

    public Coordinate midPoint() {
        return LineSegment.midPoint(this.p0, this.p1);
    }

    public static Coordinate midPoint(Coordinate p0, Coordinate p1) {
        return new Coordinate((p0.x + p1.x) / 2.0, (p0.y + p1.y) / 2.0);
    }

    public double distance(LineSegment ls) {
        return Distance.segmentToSegment(this.p0, this.p1, ls.p0, ls.p1);
    }

    public double distance(Coordinate p) {
        return Distance.pointToSegment(p, this.p0, this.p1);
    }

    public double distancePerpendicular(Coordinate p) {
        if (this.p0.equals2D(this.p1)) {
            return this.p0.distance(p);
        }
        return Distance.pointToLinePerpendicular(p, this.p0, this.p1);
    }

    public double distancePerpendicularOriented(Coordinate p) {
        if (this.p0.equals2D(this.p1)) {
            return this.p0.distance(p);
        }
        double dist = this.distancePerpendicular(p);
        if (this.orientationIndex(p) < 0) {
            return -dist;
        }
        return dist;
    }

    public Coordinate pointAlong(double segmentLengthFraction) {
        Coordinate coord = this.p0.create();
        coord.x = this.p0.x + segmentLengthFraction * (this.p1.x - this.p0.x);
        coord.y = this.p0.y + segmentLengthFraction * (this.p1.y - this.p0.y);
        return coord;
    }

    public Coordinate pointAlongOffset(double segmentLengthFraction, double offsetDistance) {
        double segx = this.p0.x + segmentLengthFraction * (this.p1.x - this.p0.x);
        double segy = this.p0.y + segmentLengthFraction * (this.p1.y - this.p0.y);
        double dx = this.p1.x - this.p0.x;
        double dy = this.p1.y - this.p0.y;
        double len = Math.hypot(dx, dy);
        double ux = 0.0;
        double uy = 0.0;
        if (offsetDistance != 0.0) {
            if (len <= 0.0) {
                throw new IllegalStateException("Cannot compute offset from zero-length line segment");
            }
            ux = offsetDistance * dx / len;
            uy = offsetDistance * dy / len;
        }
        double offsetx = segx - uy;
        double offsety = segy + ux;
        Coordinate coord = this.p0.create();
        coord.setX(offsetx);
        coord.setY(offsety);
        return coord;
    }

    public double projectionFactor(Coordinate p) {
        if (p.equals(this.p0)) {
            return 0.0;
        }
        if (p.equals(this.p1)) {
            return 1.0;
        }
        double dx = this.p1.x - this.p0.x;
        double dy = this.p1.y - this.p0.y;
        double len = dx * dx + dy * dy;
        if (len <= 0.0) {
            return Double.NaN;
        }
        double r = ((p.x - this.p0.x) * dx + (p.y - this.p0.y) * dy) / len;
        return r;
    }

    public double segmentFraction(Coordinate inputPt) {
        double segFrac = this.projectionFactor(inputPt);
        if (segFrac < 0.0) {
            segFrac = 0.0;
        } else if (segFrac > 1.0 || Double.isNaN(segFrac)) {
            segFrac = 1.0;
        }
        return segFrac;
    }

    public Coordinate project(Coordinate p) {
        if (p.equals(this.p0) || p.equals(this.p1)) {
            return p.copy();
        }
        double r = this.projectionFactor(p);
        return this.project(p, r);
    }

    private Coordinate project(Coordinate p, double projectionFactor) {
        Coordinate coord = p.copy();
        coord.x = this.p0.x + projectionFactor * (this.p1.x - this.p0.x);
        coord.y = this.p0.y + projectionFactor * (this.p1.y - this.p0.y);
        return coord;
    }

    public LineSegment project(LineSegment seg) {
        double pf0 = this.projectionFactor(seg.p0);
        double pf1 = this.projectionFactor(seg.p1);
        if (pf0 >= 1.0 && pf1 >= 1.0) {
            return null;
        }
        if (pf0 <= 0.0 && pf1 <= 0.0) {
            return null;
        }
        Coordinate newp0 = this.project(seg.p0, pf0);
        if (pf0 < 0.0) {
            newp0 = this.p0;
        }
        if (pf0 > 1.0) {
            newp0 = this.p1;
        }
        Coordinate newp1 = this.project(seg.p1, pf1);
        if (pf1 < 0.0) {
            newp1 = this.p0;
        }
        if (pf1 > 1.0) {
            newp1 = this.p1;
        }
        return new LineSegment(newp0, newp1);
    }

    public LineSegment offset(double offsetDistance) {
        Coordinate offset0 = this.pointAlongOffset(0.0, offsetDistance);
        Coordinate offset1 = this.pointAlongOffset(1.0, offsetDistance);
        return new LineSegment(offset0, offset1);
    }

    public Coordinate reflect(Coordinate p) {
        double A = this.p1.getY() - this.p0.getY();
        double B = this.p0.getX() - this.p1.getX();
        double C = this.p0.getY() * (this.p1.getX() - this.p0.getX()) - this.p0.getX() * (this.p1.getY() - this.p0.getY());
        double A2plusB2 = A * A + B * B;
        double A2subB2 = A * A - B * B;
        double x = p.getX();
        double y = p.getY();
        double rx = (-A2subB2 * x - 2.0 * A * B * y - 2.0 * A * C) / A2plusB2;
        double ry = (A2subB2 * y - 2.0 * A * B * x - 2.0 * B * C) / A2plusB2;
        Coordinate coord = p.copy();
        coord.setX(rx);
        coord.setY(ry);
        return coord;
    }

    public Coordinate closestPoint(Coordinate p) {
        double dist1;
        double factor = this.projectionFactor(p);
        if (factor > 0.0 && factor < 1.0) {
            return this.project(p, factor);
        }
        double dist0 = this.p0.distance(p);
        if (dist0 < (dist1 = this.p1.distance(p))) {
            return this.p0;
        }
        return this.p1;
    }

    public Coordinate[] closestPoints(LineSegment line) {
        Coordinate close11;
        Coordinate close10;
        Coordinate intPt = this.intersection(line);
        if (intPt != null) {
            return new Coordinate[]{intPt, intPt};
        }
        Coordinate[] closestPt = new Coordinate[2];
        double minDistance = Double.MAX_VALUE;
        Coordinate close00 = this.closestPoint(line.p0);
        minDistance = close00.distance(line.p0);
        closestPt[0] = close00;
        closestPt[1] = line.p0;
        Coordinate close01 = this.closestPoint(line.p1);
        double dist = close01.distance(line.p1);
        if (dist < minDistance) {
            minDistance = dist;
            closestPt[0] = close01;
            closestPt[1] = line.p1;
        }
        if ((dist = (close10 = line.closestPoint(this.p0)).distance(this.p0)) < minDistance) {
            minDistance = dist;
            closestPt[0] = this.p0;
            closestPt[1] = close10;
        }
        if ((dist = (close11 = line.closestPoint(this.p1)).distance(this.p1)) < minDistance) {
            minDistance = dist;
            closestPt[0] = this.p1;
            closestPt[1] = close11;
        }
        return closestPt;
    }

    public Coordinate intersection(LineSegment line) {
        RobustLineIntersector li = new RobustLineIntersector();
        li.computeIntersection(this.p0, this.p1, line.p0, line.p1);
        if (li.hasIntersection()) {
            return li.getIntersection(0);
        }
        return null;
    }

    public Coordinate lineIntersection(LineSegment line) {
        Coordinate intPt = Intersection.intersection(this.p0, this.p1, line.p0, line.p1);
        return intPt;
    }

    public LineString toGeometry(GeometryFactory geomFactory) {
        return geomFactory.createLineString(new Coordinate[]{this.p0, this.p1});
    }

    public boolean equals(Object o) {
        if (!(o instanceof LineSegment)) {
            return false;
        }
        LineSegment other = (LineSegment)o;
        return this.p0.equals(other.p0) && this.p1.equals(other.p1);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 29 + Double.hashCode(this.p0.x);
        hash = hash * 29 + Double.hashCode(this.p0.y);
        hash = hash * 29 + Double.hashCode(this.p1.x);
        hash = hash * 29 + Double.hashCode(this.p1.y);
        return hash;
    }

    public int OLDhashCode() {
        long bits0 = Double.doubleToLongBits(this.p0.x);
        int hash0 = (int)(bits0 ^= Double.doubleToLongBits(this.p0.y) * 31L) ^ (int)(bits0 >> 32);
        long bits1 = Double.doubleToLongBits(this.p1.x);
        int hash1 = (int)(bits1 ^= Double.doubleToLongBits(this.p1.y) * 31L) ^ (int)(bits1 >> 32);
        return hash0 ^ hash1;
    }

    public int compareTo(Object o) {
        LineSegment other = (LineSegment)o;
        int comp0 = this.p0.compareTo(other.p0);
        if (comp0 != 0) {
            return comp0;
        }
        return this.p1.compareTo(other.p1);
    }

    public boolean equalsTopo(LineSegment other) {
        return this.p0.equals(other.p0) && this.p1.equals(other.p1) || this.p0.equals(other.p1) && this.p1.equals(other.p0);
    }

    public String toString() {
        return "LINESTRING (" + this.p0.x + " " + this.p0.y + ", " + this.p1.x + " " + this.p1.y + ")";
    }
}

