/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.coverage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.coverage.CoveragePolygon;
import org.locationtech.jts.coverage.CoverageRing;
import org.locationtech.jts.coverage.InvalidSegmentDetector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.noding.MCIndexSegmentSetMutualIntersector;

public class CoveragePolygonValidator {
    private Geometry targetGeom;
    private double gapWidth = 0.0;
    private GeometryFactory geomFactory;
    private Geometry[] adjGeoms;
    private List<CoveragePolygon> adjCovPolygons;
    private static final int RING_SECTION_STRIDE = 1000;

    public static Geometry validate(Geometry targetPolygon, Geometry[] adjPolygons) {
        CoveragePolygonValidator v = new CoveragePolygonValidator(targetPolygon, adjPolygons);
        return v.validate();
    }

    public static Geometry validate(Geometry targetPolygon, Geometry[] adjPolygons, double gapWidth) {
        CoveragePolygonValidator v = new CoveragePolygonValidator(targetPolygon, adjPolygons);
        v.setGapWidth(gapWidth);
        return v.validate();
    }

    public CoveragePolygonValidator(Geometry geom, Geometry[] adjGeoms) {
        this.targetGeom = geom;
        this.adjGeoms = adjGeoms;
        this.geomFactory = this.targetGeom.getFactory();
    }

    public void setGapWidth(double gapWidth) {
        this.gapWidth = gapWidth;
    }

    public Geometry validate() {
        List<Polygon> adjPolygons = CoveragePolygonValidator.extractPolygons(this.adjGeoms);
        this.adjCovPolygons = CoveragePolygonValidator.toCoveragePolygons(adjPolygons);
        List<CoverageRing> targetRings = CoverageRing.createRings(this.targetGeom);
        List<CoverageRing> adjRings = CoverageRing.createRings(adjPolygons);
        Envelope targetEnv = this.targetGeom.getEnvelopeInternal().copy();
        targetEnv.expandBy(this.gapWidth);
        this.checkTargetRings(targetRings, adjRings, targetEnv);
        return this.createInvalidLines(targetRings);
    }

    private static List<CoveragePolygon> toCoveragePolygons(List<Polygon> polygons) {
        ArrayList<CoveragePolygon> covPolys = new ArrayList<CoveragePolygon>();
        for (Polygon poly : polygons) {
            covPolys.add(new CoveragePolygon(poly));
        }
        return covPolys;
    }

    private void checkTargetRings(List<CoverageRing> targetRings, List<CoverageRing> adjRings, Envelope targetEnv) {
        this.markMatchedSegments(targetRings, adjRings, targetEnv);
        if (CoverageRing.isKnown(targetRings)) {
            return;
        }
        this.markInvalidInteractingSegments(targetRings, adjRings, this.gapWidth);
        this.markInvalidInteriorSegments(targetRings, this.adjCovPolygons);
    }

    private static List<Polygon> extractPolygons(Geometry[] geoms) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Geometry geom : geoms) {
            PolygonExtracter.getPolygons(geom, polygons);
        }
        return polygons;
    }

    private Geometry createEmptyResult() {
        return this.geomFactory.createLineString();
    }

    private void markMatchedSegments(List<CoverageRing> targetRings, List<CoverageRing> adjRngs, Envelope targetEnv) {
        HashMap<CoverageRingSegment, CoverageRingSegment> segmentMap = new HashMap<CoverageRingSegment, CoverageRingSegment>();
        this.markMatchedSegments(targetRings, targetEnv, segmentMap);
        this.markMatchedSegments(adjRngs, targetEnv, segmentMap);
    }

    private void markMatchedSegments(List<CoverageRing> rings, Envelope envLimit, Map<CoverageRingSegment, CoverageRingSegment> segmentMap) {
        for (CoverageRing ring : rings) {
            for (int i = 0; i < ring.size() - 1; ++i) {
                Coordinate p1;
                Coordinate p0 = ring.getCoordinate(i);
                if (!envLimit.intersects(p0, p1 = ring.getCoordinate(i + 1))) continue;
                CoverageRingSegment seg = CoverageRingSegment.create(ring, i);
                if (segmentMap.containsKey(seg)) {
                    CoverageRingSegment segMatch = segmentMap.get(seg);
                    seg.match(segMatch);
                    continue;
                }
                segmentMap.put(seg, seg);
            }
        }
    }

    private void markInvalidInteractingSegments(List<CoverageRing> targetRings, List<CoverageRing> adjRings, double distanceTolerance) {
        InvalidSegmentDetector detector = new InvalidSegmentDetector(distanceTolerance);
        MCIndexSegmentSetMutualIntersector segSetMutInt = new MCIndexSegmentSetMutualIntersector(targetRings, distanceTolerance);
        segSetMutInt.process(adjRings, detector);
    }

    private void markInvalidInteriorSegments(List<CoverageRing> targetRings, List<CoveragePolygon> adjCovPolygons) {
        for (CoverageRing ring : targetRings) {
            int stride = 1000;
            for (int i = 0; i < ring.size() - 1; i += stride) {
                int iEnd = i + stride;
                if (iEnd >= ring.size()) {
                    iEnd = ring.size() - 1;
                }
                this.markInvalidInteriorSection(ring, i, iEnd, adjCovPolygons);
            }
        }
    }

    private void markInvalidInteriorSection(CoverageRing ring, int iStart, int iEnd, List<CoveragePolygon> adjPolygons) {
        Envelope sectionEnv = ring.getEnvelope(iStart, iEnd);
        for (CoveragePolygon adjPoly : adjPolygons) {
            if (!adjPoly.intersectsEnv(sectionEnv)) continue;
            for (int i = iStart; i < iEnd; ++i) {
                this.markInvalidInteriorSegment(ring, i, adjPoly);
            }
        }
    }

    private void markInvalidInteriorSegment(CoverageRing ring, int i, CoveragePolygon adjPoly) {
        if (ring.isKnown(i)) {
            return;
        }
        Coordinate p = ring.getCoordinate(i);
        if (adjPoly.contains(p)) {
            int iPrev;
            ring.markInvalid(i);
            int n = iPrev = i == 0 ? ring.size() - 2 : i - 1;
            if (!ring.isKnown(iPrev)) {
                ring.markInvalid(iPrev);
            }
        }
    }

    private Geometry createInvalidLines(List<CoverageRing> rings) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (CoverageRing ring : rings) {
            ring.createInvalidLines(this.geomFactory, lines);
        }
        if (lines.size() == 0) {
            return this.createEmptyResult();
        }
        if (lines.size() == 1) {
            return (Geometry)lines.get(0);
        }
        return this.geomFactory.createMultiLineString(GeometryFactory.toLineStringArray(lines));
    }

    private static class CoverageRingSegment
    extends LineSegment {
        private CoverageRing ringForward = null;
        private int indexForward = -1;
        private CoverageRing ringOpp = null;
        private int indexOpp = -1;

        public static CoverageRingSegment create(CoverageRing ring, int index) {
            Coordinate p0 = ring.getCoordinate(index);
            Coordinate p1 = ring.getCoordinate(index + 1);
            if (ring.isInteriorOnRight()) {
                return new CoverageRingSegment(p0, p1, ring, index);
            }
            return new CoverageRingSegment(p1, p0, ring, index);
        }

        private CoverageRingSegment(Coordinate p0, Coordinate p1, CoverageRing ring, int index) {
            super(p0, p1);
            if (p1.compareTo(p0) < 0) {
                this.reverse();
                this.ringOpp = ring;
                this.indexOpp = index;
            } else {
                this.ringForward = ring;
                this.indexForward = index;
            }
        }

        public void match(CoverageRingSegment seg) {
            boolean isInvalid = this.checkInvalid(seg);
            if (isInvalid) {
                return;
            }
            if (this.ringForward == null) {
                this.ringForward = seg.ringForward;
                this.indexForward = seg.indexForward;
            } else {
                this.ringOpp = seg.ringOpp;
                this.indexOpp = seg.indexOpp;
            }
            this.ringForward.markMatched(this.indexForward);
            this.ringOpp.markMatched(this.indexOpp);
        }

        private boolean checkInvalid(CoverageRingSegment seg) {
            if (this.ringForward != null && seg.ringForward != null) {
                this.ringForward.markInvalid(this.indexForward);
                seg.ringForward.markInvalid(seg.indexForward);
                return true;
            }
            if (this.ringOpp != null && seg.ringOpp != null) {
                this.ringOpp.markInvalid(this.indexOpp);
                seg.ringOpp.markInvalid(seg.indexOpp);
                return true;
            }
            return false;
        }
    }
}

