/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;

public class PointLocation {
    public static boolean isOnSegment(Coordinate p, Coordinate p0, Coordinate p1) {
        if (!Envelope.intersects(p0, p1, p)) {
            return false;
        }
        if (p.equals2D(p0)) {
            return true;
        }
        boolean isOnLine = 0 == Orientation.index(p0, p1, p);
        return isOnLine;
    }

    public static boolean isOnLine(Coordinate p, Coordinate[] line) {
        for (int i = 1; i < line.length; ++i) {
            Coordinate p0 = line[i - 1];
            Coordinate p1 = line[i];
            if (!PointLocation.isOnSegment(p, p0, p1)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnLine(Coordinate p, CoordinateSequence line) {
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        int n = line.size();
        for (int i = 1; i < n; ++i) {
            line.getCoordinate(i - 1, p0);
            line.getCoordinate(i, p1);
            if (!PointLocation.isOnSegment(p, p0, p1)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInRing(Coordinate p, Coordinate[] ring) {
        return PointLocation.locateInRing(p, ring) != 2;
    }

    public static int locateInRing(Coordinate p, Coordinate[] ring) {
        return RayCrossingCounter.locatePointInRing(p, ring);
    }
}

