/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.cache.bounded;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
@ThreadSafe
public final class BoundedCache<K, V> {
    private static final int DEFAULT_CACHE_SIZE = 150;
    private static final int DEFAULT_EVICTION_BATCH_SIZE = 10;
    private final ConcurrentHashMap<K, V> cache;
    private final Function<K, V> valueMappingFunction;
    private final int maxCacheSize;
    private final int evictionBatchSize;
    private final Object cacheLock;
    private final AtomicInteger cacheSize;

    private BoundedCache(Builder<K, V> b) {
        this.valueMappingFunction = ((Builder)b).mappingFunction;
        this.maxCacheSize = ((Builder)b).maxSize != null ? Validate.isPositive(((Builder)b).maxSize, "maxSize") : 150;
        this.evictionBatchSize = ((Builder)b).evictionBatchSize != null ? Validate.isPositive(((Builder)b).evictionBatchSize, "evictionBatchSize") : 10;
        this.cache = new ConcurrentHashMap();
        this.cacheLock = new Object();
        this.cacheSize = new AtomicInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Validate.paramNotNull(key, "key");
        V value = this.cache.get(key);
        if (value != null) {
            return value;
        }
        V newValue = this.valueMappingFunction.apply(key);
        if (newValue == null) {
            return null;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            value = this.cache.get(key);
            if (value != null) {
                return value;
            }
            if (this.cacheSize.get() >= this.maxCacheSize) {
                this.cleanup();
            }
            this.cache.put(key, newValue);
            this.cacheSize.incrementAndGet();
            return newValue;
        }
    }

    private void cleanup() {
        Iterator iterator = ((ConcurrentHashMap.KeySetView)this.cache.keySet()).iterator();
        for (int count = 0; iterator.hasNext() && count < this.evictionBatchSize; ++count) {
            iterator.next();
            iterator.remove();
            this.cacheSize.decrementAndGet();
        }
    }

    public int size() {
        return this.cacheSize.get();
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public static <K, V> Builder<K, V> builder(Function<K, V> mappingFunction) {
        return new Builder(mappingFunction);
    }

    public static final class Builder<K, V> {
        private final Function<K, V> mappingFunction;
        private Integer maxSize;
        private Integer evictionBatchSize;

        private Builder(Function<K, V> mappingFunction) {
            this.mappingFunction = mappingFunction;
        }

        public Builder<K, V> maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder<K, V> evictionBatchSize(Integer evictionBatchSize) {
            this.evictionBatchSize = evictionBatchSize;
            return this;
        }

        public BoundedCache<K, V> build() {
            return new BoundedCache(this);
        }
    }
}

