/*
 * pngtclDecls.h --
 *
 * Declarations of functions in the platform independent public PNGTCL API.
 *
 */

#ifndef _PNGTCLDECLS
#define _PNGTCLDECLS

/*
 * WARNING: The contents of this file is automatically generated by the
 * genStubs.tcl script. Any modifications to the function declarations
 * below should be made in the pngtcl.decls script.
 */

#include <tcl.h>

#ifdef PNG_IMPEXP
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#else
#   define PNG_IMPEXP extern
#   undef USE_PNGTCL_STUBS
#   define USE_PNGTCL_STUBS 1
#endif

EXTERN int Pngtcl_Init(Tcl_Interp *interp);
EXTERN int Pngtcl_SafeInit(Tcl_Interp *interp);

#include "../compat/libpng/png.h"

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

/* 0 */
PNG_IMPEXP png_uint_32	png_access_version_number(void);
/* 1 */
PNG_IMPEXP void		png_set_sig_bytes(png_structrp png_ptr,
				int num_bytes);
/* 2 */
PNG_IMPEXP int		png_sig_cmp(png_const_bytep sig, size_t start,
				size_t num_to_check);
/* Slot 3 is reserved */
/* 4 */
PNG_IMPEXP png_structp	png_create_read_struct(png_const_charp user_png_ver,
				png_voidp error_ptr, png_error_ptr error_fn,
				png_error_ptr warn_fn);
/* 5 */
PNG_IMPEXP png_structp	png_create_write_struct(png_const_charp user_png_ver,
				png_voidp error_ptr, png_error_ptr error_fn,
				png_error_ptr warn_fn);
/* 6 */
PNG_IMPEXP size_t	png_get_compression_buffer_size(
				png_const_structrp png_ptr);
/* 7 */
PNG_IMPEXP void		png_set_compression_buffer_size(png_structrp png_ptr,
				size_t size);
/* Slot 8 is reserved */
/* 9 */
PNG_IMPEXP png_structp	png_create_read_struct_2(
				png_const_charp user_png_ver,
				png_voidp error_ptr, png_error_ptr error_fn,
				png_error_ptr warn_fn, png_voidp mem_ptr,
				png_malloc_ptr malloc_fn,
				png_free_ptr free_fn);
/* 10 */
PNG_IMPEXP png_structp	png_create_write_struct_2(
				png_const_charp user_png_ver,
				png_voidp error_ptr, png_error_ptr error_fn,
				png_error_ptr warn_fn, png_voidp mem_ptr,
				png_malloc_ptr malloc_fn,
				png_free_ptr free_fn);
/* 11 */
PNG_IMPEXP void		png_write_chunk(png_structrp png_ptr,
				png_const_bytep chunk_name,
				png_const_bytep data, size_t length);
/* 12 */
PNG_IMPEXP void		png_write_chunk_start(png_structrp png_ptr,
				png_const_bytep chunk_name,
				png_uint_32 length);
/* 13 */
PNG_IMPEXP void		png_write_chunk_data(png_structrp png_ptr,
				png_const_bytep data, size_t length);
/* 14 */
PNG_IMPEXP void		png_write_chunk_end(png_structrp png_ptr);
/* 15 */
PNG_IMPEXP png_infop	png_create_info_struct(png_const_structrp png_ptr);
/* Slot 16 is reserved */
/* 17 */
PNG_IMPEXP void		png_write_info_before_PLTE(png_structrp png_ptr,
				png_const_inforp info_ptr);
/* 18 */
PNG_IMPEXP void		png_write_info(png_structrp png_ptr,
				png_const_inforp info_ptr);
/* 19 */
PNG_IMPEXP void		png_read_info(png_structrp png_ptr,
				png_inforp info_ptr);
/* Slot 20 is reserved */
/* 21 */
PNG_IMPEXP void		png_convert_from_struct_tm(png_timep ptime,
				const struct tm *ttime);
/* 22 */
PNG_IMPEXP void		png_convert_from_time_t(png_timep ptime,
				time_t ttime);
/* 23 */
PNG_IMPEXP void		png_set_expand(png_structrp png_ptr);
/* Slot 24 is reserved */
/* 25 */
PNG_IMPEXP void		png_set_palette_to_rgb(png_structrp png_ptr);
/* 26 */
PNG_IMPEXP void		png_set_tRNS_to_alpha(png_structrp png_ptr);
/* 27 */
PNG_IMPEXP void		png_set_bgr(png_structrp png_ptr);
/* 28 */
PNG_IMPEXP void		png_set_gray_to_rgb(png_structrp png_ptr);
/* 29 */
PNG_IMPEXP void		png_set_rgb_to_gray(png_structrp png_ptr,
				int error_action, double red, double green);
/* 30 */
PNG_IMPEXP void		png_set_rgb_to_gray_fixed(png_structrp png_ptr,
				int error_action, png_fixed_point red,
				png_fixed_point green);
/* 31 */
PNG_IMPEXP png_byte	png_get_rgb_to_gray_status(
				png_const_structrp png_ptr);
/* 32 */
PNG_IMPEXP void		png_build_grayscale_palette(int bit_depth,
				png_colorp palette);
/* 33 */
PNG_IMPEXP void		png_set_strip_alpha(png_structrp png_ptr);
/* 34 */
PNG_IMPEXP void		png_set_swap_alpha(png_structrp png_ptr);
/* 35 */
PNG_IMPEXP void		png_set_invert_alpha(png_structrp png_ptr);
/* 36 */
PNG_IMPEXP void		png_set_filler(png_structrp png_ptr,
				png_uint_32 filler, int flags);
/* 37 */
PNG_IMPEXP void		png_set_swap(png_structrp png_ptr);
/* 38 */
PNG_IMPEXP void		png_set_packing(png_structrp png_ptr);
/* 39 */
PNG_IMPEXP void		png_set_packswap(png_structrp png_ptr);
/* 40 */
PNG_IMPEXP void		png_set_shift(png_structrp png_ptr,
				png_const_color_8p true_bits);
/* 41 */
PNG_IMPEXP int		png_set_interlace_handling(png_structrp png_ptr);
/* 42 */
PNG_IMPEXP void		png_set_invert_mono(png_structrp png_ptr);
/* 43 */
PNG_IMPEXP void		png_set_background(png_structrp png_ptr,
				png_const_color_16p background_color,
				int background_gamma_code, int need_expand,
				double background_gamma);
/* 44 */
PNG_IMPEXP void		png_set_strip_16(png_structrp png_ptr);
/* 45 */
PNG_IMPEXP void		png_set_quantize(png_structrp png_ptr,
				png_colorp palette, int num_palette,
				int maximum_colors,
				png_const_uint_16p histogram,
				int full_quantize);
/* 46 */
PNG_IMPEXP void		png_set_gamma(png_structrp png_ptr,
				double screen_gamma,
				double default_file_gamma);
/* 47 */
PNG_IMPEXP void		png_permit_empty_plte(png_structrp png_ptr,
				int empty_plte_permitted);
/* 48 */
PNG_IMPEXP void		png_set_flush(png_structrp png_ptr, int nrows);
/* 49 */
PNG_IMPEXP void		png_write_flush(png_structrp png_ptr);
/* 50 */
PNG_IMPEXP void		png_start_read_image(png_structrp png_ptr);
/* 51 */
PNG_IMPEXP void		png_read_update_info(png_structrp png_ptr,
				png_inforp info_ptr);
/* 52 */
PNG_IMPEXP void		png_read_rows(png_structrp png_ptr, png_bytepp row,
				png_bytepp display_row, png_uint_32 num_rows);
/* 53 */
PNG_IMPEXP void		png_read_row(png_structrp png_ptr, png_bytep row,
				png_bytep display_row);
/* 54 */
PNG_IMPEXP void		png_read_image(png_structrp png_ptr,
				png_bytepp image);
/* 55 */
PNG_IMPEXP void		png_write_row(png_structrp png_ptr,
				png_const_bytep row);
/* 56 */
PNG_IMPEXP void		png_write_rows(png_structrp png_ptr, png_bytepp row,
				png_uint_32 num_rows);
/* 57 */
PNG_IMPEXP void		png_write_image(png_structrp png_ptr,
				png_bytepp image);
/* 58 */
PNG_IMPEXP void		png_write_end(png_structrp png_ptr,
				png_inforp info_ptr);
/* 59 */
PNG_IMPEXP void		png_read_end(png_structrp png_ptr,
				png_inforp info_ptr);
/* 60 */
PNG_IMPEXP void		png_destroy_info_struct(png_const_structrp png_ptr,
				png_infopp info_ptr_ptr);
/* 61 */
PNG_IMPEXP void		png_destroy_read_struct(png_structpp png_ptr_ptr,
				png_infopp info_ptr_ptr,
				png_infopp end_info_ptr_ptr);
/* Slot 62 is reserved */
/* 63 */
PNG_IMPEXP void		png_destroy_write_struct(png_structpp png_ptr_ptr,
				png_infopp info_ptr_ptr);
/* Slot 64 is reserved */
/* Slot 65 is reserved */
/* 66 */
PNG_IMPEXP void		png_set_crc_action(png_structrp png_ptr,
				int crit_action, int ancil_action);
/* 67 */
PNG_IMPEXP void		png_set_filter(png_structrp png_ptr, int method,
				int filters);
/* 68 */
PNG_IMPEXP void		png_set_filter_heuristics(png_structrp png_ptr,
				int heuristic_method, int num_weights,
				png_const_doublep filter_weights,
				png_const_doublep filter_costs);
/* 69 */
PNG_IMPEXP void		png_set_compression_level(png_structrp png_ptr,
				int level);
/* 70 */
PNG_IMPEXP void		png_set_compression_mem_level(png_structrp png_ptr,
				int mem_level);
/* 71 */
PNG_IMPEXP void		png_set_compression_strategy(png_structrp png_ptr,
				int strategy);
/* 72 */
PNG_IMPEXP void		png_set_compression_window_bits(png_structrp png_ptr,
				int window_bits);
/* 73 */
PNG_IMPEXP void		png_set_compression_method(png_structrp png_ptr,
				int method);
/* 74 */
PNG_IMPEXP void		png_init_io(png_structrp png_ptr, png_FILE_p fp);
/* 75 */
PNG_IMPEXP void		png_set_error_fn(png_structrp png_ptr,
				png_voidp error_ptr, png_error_ptr error_fn,
				png_error_ptr warning_fn);
/* 76 */
PNG_IMPEXP png_voidp	png_get_error_ptr(png_const_structrp png_ptr);
/* 77 */
PNG_IMPEXP void		png_set_write_fn(png_structrp png_ptr,
				png_voidp io_ptr, png_rw_ptr write_data_fn,
				png_flush_ptr output_flush_fn);
/* 78 */
PNG_IMPEXP void		png_set_read_fn(png_structrp png_ptr,
				png_voidp io_ptr, png_rw_ptr read_data_fn);
/* 79 */
PNG_IMPEXP png_voidp	png_get_io_ptr(png_const_structrp png_ptr);
/* 80 */
PNG_IMPEXP void		png_set_read_status_fn(png_structrp png_ptr,
				png_read_status_ptr read_row_fn);
/* 81 */
PNG_IMPEXP void		png_set_write_status_fn(png_structrp png_ptr,
				png_write_status_ptr write_row_fn);
/* 82 */
PNG_IMPEXP void		png_set_mem_fn(png_structrp png_ptr,
				png_voidp mem_ptr, png_malloc_ptr malloc_fn,
				png_free_ptr free_fn);
/* 83 */
PNG_IMPEXP png_voidp	png_get_mem_ptr(png_const_structrp png_ptr);
/* 84 */
PNG_IMPEXP void		png_set_read_user_transform_fn(png_structrp png_ptr,
				png_user_transform_ptr read_user_transform_fn);
/* 85 */
PNG_IMPEXP void		png_set_write_user_transform_fn(png_structrp png_ptr,
				png_user_transform_ptr write_user_transform_fn);
/* 86 */
PNG_IMPEXP void		png_set_user_transform_info(png_structrp png_ptr,
				png_voidp user_transform_ptr,
				int user_transform_depth,
				int user_transform_channels);
/* 87 */
PNG_IMPEXP png_voidp	png_get_user_transform_ptr(
				png_const_structrp png_ptr);
/* 88 */
PNG_IMPEXP void		png_set_read_user_chunk_fn(png_structrp png_ptr,
				png_voidp user_chunk_ptr,
				png_user_chunk_ptr read_user_chunk_fn);
/* 89 */
PNG_IMPEXP png_voidp	png_get_user_chunk_ptr(png_const_structrp png_ptr);
/* 90 */
PNG_IMPEXP void		png_set_progressive_read_fn(png_structrp png_ptr,
				png_voidp progressive_ptr,
				png_progressive_info_ptr info_fn,
				png_progressive_row_ptr row_fn,
				png_progressive_end_ptr end_fn);
/* 91 */
PNG_IMPEXP png_voidp	png_get_progressive_ptr(png_const_structrp png_ptr);
/* 92 */
PNG_IMPEXP void		png_process_data(png_structrp png_ptr,
				png_inforp info_ptr, png_bytep buffer,
				size_t buffer_size);
/* 93 */
PNG_IMPEXP void		png_progressive_combine_row(
				png_const_structrp png_ptr,
				png_bytep old_row, png_const_bytep new_row);
/* 94 */
PNG_IMPEXP png_voidp	png_malloc(png_const_structrp png_ptr,
				png_alloc_size_t size);
/* 95 */
PNG_IMPEXP void		png_free(png_const_structrp png_ptr, png_voidp ptr);
/* 96 */
PNG_IMPEXP void		png_free_data(png_const_structrp png_ptr,
				png_inforp info_ptr, png_uint_32 free_me,
				int num);
/* Slot 97 is reserved */
/* Slot 98 is reserved */
/* Slot 99 is reserved */
/* Slot 100 is reserved */
/* Slot 101 is reserved */
/* 102 */
PNG_IMPEXP void *	png_far_to_near(png_structp png_ptr, png_voidp ptr,
				int check);
/* 103 */
PNG_IMPEXP void		png_error(png_const_structrp png_ptr,
				png_const_charp error_message);
/* 104 */
PNG_IMPEXP void		png_chunk_error(png_const_structrp png_ptr,
				png_const_charp error_message);
/* 105 */
PNG_IMPEXP void		png_warning(png_const_structrp png_ptr,
				png_const_charp warning_message);
/* 106 */
PNG_IMPEXP void		png_chunk_warning(png_const_structrp png_ptr,
				png_const_charp warning_message);
/* 107 */
PNG_IMPEXP png_uint_32	png_get_valid(png_const_structrp png_ptr,
				png_const_inforp info_ptr, png_uint_32 flag);
/* 108 */
PNG_IMPEXP size_t	png_get_rowbytes(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 109 */
PNG_IMPEXP png_bytepp	png_get_rows(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 110 */
PNG_IMPEXP void		png_set_rows(png_const_structrp png_ptr,
				png_inforp info_ptr, png_bytepp row_pointers);
/* 111 */
PNG_IMPEXP png_byte	png_get_channels(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 112 */
PNG_IMPEXP png_uint_32	png_get_image_width(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 113 */
PNG_IMPEXP png_uint_32	png_get_image_height(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 114 */
PNG_IMPEXP png_byte	png_get_bit_depth(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 115 */
PNG_IMPEXP png_byte	png_get_color_type(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 116 */
PNG_IMPEXP png_byte	png_get_filter_type(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 117 */
PNG_IMPEXP png_byte	png_get_interlace_type(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 118 */
PNG_IMPEXP png_byte	png_get_compression_type(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 119 */
PNG_IMPEXP png_uint_32	png_get_pixels_per_meter(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 120 */
PNG_IMPEXP png_uint_32	png_get_x_pixels_per_meter(
				png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 121 */
PNG_IMPEXP png_uint_32	png_get_y_pixels_per_meter(
				png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 122 */
PNG_IMPEXP float	png_get_pixel_aspect_ratio(
				png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 123 */
PNG_IMPEXP png_int_32	png_get_x_offset_pixels(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 124 */
PNG_IMPEXP png_int_32	png_get_y_offset_pixels(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 125 */
PNG_IMPEXP png_int_32	png_get_x_offset_microns(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 126 */
PNG_IMPEXP png_int_32	png_get_y_offset_microns(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 127 */
PNG_IMPEXP png_const_bytep png_get_signature(png_const_structrp png_ptr,
				png_const_inforp info_ptr);
/* 128 */
PNG_IMPEXP png_uint_32	png_get_bKGD(png_const_structrp png_ptr,
				png_inforp info_ptr,
				png_color_16p *background);
/* 129 */
PNG_IMPEXP void		png_set_bKGD(png_const_structrp png_ptr,
				png_inforp info_ptr,
				png_const_color_16p background);
/* 130 */
PNG_IMPEXP png_uint_32	png_get_cHRM(png_const_structrp png_ptr,
				png_const_inforp info_ptr, double *white_x,
				double *white_y, double *red_x,
				double *red_y, double *green_x,
				double *green_y, double *blue_x,
				double *blue_y);
/* 131 */
PNG_IMPEXP png_uint_32	png_get_cHRM_fixed(png_const_structrp png_ptr,
				png_const_inforp info_ptr,
				png_fixed_point *int_white_x,
				png_fixed_point *int_white_y,
				png_fixed_point *int_red_x,
				png_fixed_point *int_red_y,
				png_fixed_point *int_green_x,
				png_fixed_point *int_green_y,
				png_fixed_point *int_blue_x,
				png_fixed_point *int_blue_y);
/* 132 */
PNG_IMPEXP void		png_set_cHRM(png_const_structrp png_ptr,
				png_inforp info_ptr, double white_x,
				double white_y, double red_x, double red_y,
				double green_x, double green_y,
				double blue_x, double blue_y);
/* 133 */
PNG_IMPEXP void		png_set_cHRM_fixed(png_const_structrp png_ptr,
				png_inforp info_ptr,
				png_fixed_point int_white_x,
				png_fixed_point int_white_y,
				png_fixed_point int_red_x,
				png_fixed_point int_red_y,
				png_fixed_point int_green_x,
				png_fixed_point int_green_y,
				png_fixed_point int_blue_x,
				png_fixed_point int_blue_y);
/* 134 */
PNG_IMPEXP png_uint_32	png_get_gAMA(png_const_structrp png_ptr,
				png_const_inforp info_ptr,
				double *file_gamma);
/* 135 */
PNG_IMPEXP png_uint_32	png_get_gAMA_fixed(png_const_structrp png_ptr,
				png_const_inforp info_ptr,
				png_fixed_point *int_file_gamma);
/* 136 */
PNG_IMPEXP void		png_set_gAMA(png_const_structrp png_ptr,
				png_inforp info_ptr, double file_gamma);
/* 137 */
PNG_IMPEXP void		png_set_gAMA_fixed(png_const_structrp png_ptr,
				png_inforp info_ptr,
				png_fixed_point int_file_gamma);
/* 138 */
PNG_IMPEXP png_uint_32	png_get_hIST(png_const_structrp png_ptr,
				png_inforp info_ptr, png_uint_16p *hist);
/* 139 */
PNG_IMPEXP void		png_set_hIST(png_const_structrp png_ptr,
				png_inforp info_ptr, png_const_uint_16p hist);
/* 140 */
PNG_IMPEXP png_uint_32	png_get_IHDR(png_const_structrp png_ptr,
				png_const_inforp info_ptr,
				png_uint_32 *width, png_uint_32 *height,
				int *bit_depth, int *color_type,
				int *interlace_type, int *compression_type,
				int *filter_type);
/* 141 */
PNG_IMPEXP void		png_set_IHDR(png_const_structrp png_ptr,
				png_inforp info_ptr, png_uint_32 width,
				png_uint_32 height, int bit_depth,
				int color_type, int interlace_type,
				int compression_type, int filter_type);
/* 142 */
PNG_IMPEXP png_uint_32	png_get_oFFs(png_const_structrp png_ptr,
				png_const_inforp info_ptr,
				png_int_32 *offset_x, png_int_32 *offset_y,
				int *unit_type);
/* 143 */
PNG_IMPEXP void		png_set_oFFs(png_const_structrp png_ptr,
				png_inforp info_ptr, png_int_32 offset_x,
				png_int_32 offset_y, int unit_type);
/* 144 */
PNG_IMPEXP png_uint_32	png_get_pCAL(png_const_structrp png_ptr,
				png_inforp info_ptr, png_charp *purpose,
				png_int_32 *X0, png_int_32 *X1, int *type,
				int *nparams, png_charp *units,
				png_charpp *params);
/* 145 */
PNG_IMPEXP void		png_set_pCAL(png_const_structrp png_ptr,
				png_inforp info_ptr, png_const_charp purpose,
				png_int_32 X0, png_int_32 X1, int type,
				int nparams, png_const_charp units,
				png_charpp params);
/* 146 */
PNG_IMPEXP png_uint_32	png_get_pHYs(png_const_structrp png_ptr,
				png_const_inforp info_ptr,
				png_uint_32 *res_x, png_uint_32 *res_y,
				int *unit_type);
/* 147 */
PNG_IMPEXP void		png_set_pHYs(png_const_structrp png_ptr,
				png_inforp info_ptr, png_uint_32 res_x,
				png_uint_32 res_y, int unit_type);
/* 148 */
PNG_IMPEXP png_uint_32	png_get_PLTE(png_const_structrp png_ptr,
				png_inforp info_ptr, png_colorp *palette,
				int *num_palette);
/* 149 */
PNG_IMPEXP void		png_set_PLTE(png_structrp png_ptr,
				png_inforp info_ptr,
				png_const_colorp palette, int num_palette);
/* 150 */
PNG_IMPEXP png_uint_32	png_get_sBIT(png_const_structrp png_ptr,
				png_inforp info_ptr, png_color_8p *sig_bit);
/* 151 */
PNG_IMPEXP void		png_set_sBIT(png_const_structrp png_ptr,
				png_inforp info_ptr,
				png_const_color_8p sig_bit);
/* 152 */
PNG_IMPEXP png_uint_32	png_get_sRGB(png_const_structrp png_ptr,
				png_const_inforp info_ptr, int *intent);
/* 153 */
PNG_IMPEXP void		png_set_sRGB(png_const_structrp png_ptr,
				png_inforp info_ptr, int intent);
/* 154 */
PNG_IMPEXP void		png_set_sRGB_gAMA_and_cHRM(
				png_const_structrp png_ptr,
				png_inforp info_ptr, int intent);
/* 155 */
PNG_IMPEXP png_uint_32	png_get_iCCP(png_const_structrp png_ptr,
				png_inforp info_ptr, png_charpp name,
				int *compression_type, png_bytepp profile,
				png_uint_32 *proflen);
/* 156 */
PNG_IMPEXP void		png_set_iCCP(png_const_structrp png_ptr,
				png_inforp info_ptr, png_const_charp name,
				int compression_type,
				png_const_bytep profile, png_uint_32 proflen);
/* 157 */
PNG_IMPEXP int		png_get_sPLT(png_const_structrp png_ptr,
				png_inforp info_ptr, png_sPLT_tpp entries);
/* 158 */
PNG_IMPEXP void		png_set_sPLT(png_const_structrp png_ptr,
				png_inforp info_ptr,
				png_const_sPLT_tp entries, int nentries);
/* 159 */
PNG_IMPEXP int		png_get_text(png_const_structrp png_ptr,
				png_inforp info_ptr, png_textp *text_ptr,
				int *num_text);
/* 160 */
PNG_IMPEXP void		png_set_text(png_const_structrp png_ptr,
				png_inforp info_ptr,
				png_const_textp text_ptr, int num_text);
/* 161 */
PNG_IMPEXP png_uint_32	png_get_tIME(png_const_structrp png_ptr,
				png_inforp info_ptr, png_timep *mod_time);
/* 162 */
PNG_IMPEXP void		png_set_tIME(png_const_structrp png_ptr,
				png_inforp info_ptr,
				png_const_timep mod_time);
/* 163 */
PNG_IMPEXP png_uint_32	png_get_tRNS(png_const_structrp png_ptr,
				png_inforp info_ptr, png_bytep *trans,
				int *num_trans, png_color_16p *trans_values);
/* 164 */
PNG_IMPEXP void		png_set_tRNS(png_structrp png_ptr,
				png_inforp info_ptr,
				png_const_bytep trans_alpha, int num_trans,
				png_const_color_16p trans_values);
/* 165 */
PNG_IMPEXP png_uint_32	png_get_sCAL(png_const_structrp png_ptr,
				png_const_inforp info_ptr, int *unit,
				double *width, double *height);
/* 166 */
PNG_IMPEXP png_uint_32	png_get_sCAL_s(png_const_structrp png_ptr,
				png_const_inforp info_ptr, int *unit,
				png_charpp swidth, png_charpp sheight);
/* 167 */
PNG_IMPEXP void		png_set_sCAL(png_const_structrp png_ptr,
				png_inforp info_ptr, int unit, double width,
				double height);
/* 168 */
PNG_IMPEXP void		png_set_sCAL_s(png_const_structrp png_ptr,
				png_inforp info_ptr, int unit,
				png_const_charp swidth,
				png_const_charp sheight);
/* 169 */
PNG_IMPEXP void		png_set_keep_unknown_chunks(png_structrp png_ptr,
				int keep, png_const_bytep chunk_list,
				int num_chunks);
/* 170 */
PNG_IMPEXP void		png_set_unknown_chunks(png_const_structrp png_ptr,
				png_inforp info_ptr,
				png_const_unknown_chunkp unknowns,
				int num_unknowns);
/* 171 */
PNG_IMPEXP void		png_set_unknown_chunk_location(
				png_const_structrp png_ptr,
				png_inforp info_ptr, int chunk, int location);
/* 172 */
PNG_IMPEXP int		png_get_unknown_chunks(png_const_structrp png_ptr,
				png_inforp info_ptr,
				png_unknown_chunkpp entries);
/* 173 */
PNG_IMPEXP void		png_set_invalid(png_const_structrp png_ptr,
				png_inforp info_ptr, int mask);
/* 174 */
PNG_IMPEXP void		png_read_png(png_structrp png_ptr,
				png_inforp info_ptr, int transforms,
				png_voidp params);
/* 175 */
PNG_IMPEXP void		png_write_png(png_structrp png_ptr,
				png_inforp info_ptr, int transforms,
				png_voidp params);
/* 176 */
PNG_IMPEXP png_bytep	png_sig_bytes(void);
/* 177 */
PNG_IMPEXP png_const_charp png_get_copyright(png_const_structrp png_ptr);
/* 178 */
PNG_IMPEXP png_const_charp png_get_header_ver(png_const_structrp png_ptr);
/* 179 */
PNG_IMPEXP png_const_charp png_get_header_version(png_const_structrp png_ptr);
/* 180 */
PNG_IMPEXP png_const_charp png_get_libpng_ver(png_const_structrp png_ptr);
/* Slot 181 is reserved */
/* Slot 182 is reserved */
/* Slot 183 is reserved */
/* 184 */
PNG_IMPEXP void		png_read_init(png_structp png_ptr);
/* 185 */
PNG_IMPEXP void		png_read_init_2(png_structp png_ptr,
				png_const_charp user_png_ver,
				size_t png_struct_size, size_t png_info_size);
/* Slot 186 is reserved */
/* Slot 187 is reserved */
/* 188 */
PNG_IMPEXP png_voidp	png_create_struct(int type);
/* 189 */
PNG_IMPEXP void		png_destroy_struct(png_voidp struct_ptr);
/* 190 */
PNG_IMPEXP png_voidp	png_create_struct_2(int type,
				png_malloc_ptr malloc_fn);
/* 191 */
PNG_IMPEXP void		png_destroy_struct_2(png_voidp struct_ptr,
				png_free_ptr free_fn);
/* 192 */
PNG_IMPEXP void		png_info_destroy(png_structp png_ptr,
				png_infop info_ptr);
/* Slot 193 is reserved */
/* Slot 194 is reserved */
/* 195 */
PNG_IMPEXP void		png_reset_crc(png_structp png_ptr);
/* 196 */
PNG_IMPEXP void		png_write_data(png_structp png_ptr, png_bytep data,
				size_t length);
/* 197 */
PNG_IMPEXP void		png_read_data(png_structp png_ptr, png_bytep data,
				size_t length);
/* 198 */
PNG_IMPEXP void		png_crc_read(png_structp png_ptr, png_bytep buf,
				size_t length);
/* 199 */
PNG_IMPEXP png_charp	png_decompress_chunk(png_structp png_ptr,
				int comp_type, png_charp chunkdata,
				size_t chunklength, size_t prefix_length,
				size_t *data_length);
/* 200 */
PNG_IMPEXP int		png_crc_finish(png_structp png_ptr, png_uint_32 skip);
/* 201 */
PNG_IMPEXP int		png_crc_error(png_structp png_ptr);
/* 202 */
PNG_IMPEXP void		png_calculate_crc(png_structp png_ptr, png_bytep ptr,
				size_t length);
/* 203 */
PNG_IMPEXP void		png_flush(png_structp png_ptr);
/* 204 */
PNG_IMPEXP void		png_save_uint_32(png_bytep buf, png_uint_32 i);
/* 205 */
PNG_IMPEXP void		png_save_int_32(png_bytep buf, png_int_32 i);
/* 206 */
PNG_IMPEXP void		png_save_uint_16(png_bytep buf, unsigned int i);
/* 207 */
PNG_IMPEXP void		png_write_sig(png_structrp png_ptr);
/* 208 */
PNG_IMPEXP void		png_write_IHDR(png_structp png_ptr,
				png_uint_32 width, png_uint_32 height,
				int bit_depth, int color_type,
				int compression_type, int filter_type,
				int interlace_type);
/* 209 */
PNG_IMPEXP void		png_write_PLTE(png_structp png_ptr,
				png_colorp palette, png_uint_32 num_pal);
/* 210 */
PNG_IMPEXP void		png_write_IDAT(png_structp png_ptr, png_bytep data,
				size_t length);
/* 211 */
PNG_IMPEXP void		png_write_IEND(png_structp png_ptr);
/* 212 */
PNG_IMPEXP void		png_write_gAMA(png_structp png_ptr,
				double file_gamma);
/* 213 */
PNG_IMPEXP void		png_write_gAMA_fixed(png_structp png_ptr,
				png_fixed_point file_gamma);
/* 214 */
PNG_IMPEXP void		png_write_sBIT(png_structp png_ptr,
				png_color_8p sbit, int color_type);
/* 215 */
PNG_IMPEXP void		png_write_cHRM(png_structp png_ptr, double white_x,
				double white_y, double red_x, double red_y,
				double green_x, double green_y,
				double blue_x, double blue_y);
/* 216 */
PNG_IMPEXP void		png_write_cHRM_fixed(png_structp png_ptr,
				png_fixed_point int_white_x,
				png_fixed_point int_white_y,
				png_fixed_point int_red_x,
				png_fixed_point int_red_y,
				png_fixed_point int_green_x,
				png_fixed_point int_green_y,
				png_fixed_point int_blue_x,
				png_fixed_point int_blue_y);
/* 217 */
PNG_IMPEXP void		png_write_sRGB(png_structp png_ptr, int intent);
/* 218 */
PNG_IMPEXP void		png_write_iCCP(png_structp png_ptr, png_charp name,
				int compression_type, png_charp profile,
				int proflen);
/* 219 */
PNG_IMPEXP void		png_write_sPLT(png_structp png_ptr,
				png_sPLT_tp palette);
/* 220 */
PNG_IMPEXP void		png_write_tRNS(png_structp png_ptr, png_bytep trans,
				png_color_16p values, int number,
				int color_type);
/* 221 */
PNG_IMPEXP void		png_write_bKGD(png_structp png_ptr,
				png_color_16p values, int color_type);
/* 222 */
PNG_IMPEXP void		png_write_hIST(png_structp png_ptr,
				png_uint_16p hist, int num_hist);
/* 223 */
PNG_IMPEXP size_t	png_check_keyword(png_structp png_ptr, png_charp key,
				png_charpp new_key);
/* 224 */
PNG_IMPEXP void		png_write_tEXt(png_structp png_ptr, png_charp key,
				png_charp text, size_t text_len);
/* 225 */
PNG_IMPEXP void		png_write_zTXt(png_structp png_ptr, png_charp key,
				size_t text_len, int compression);
/* 226 */
PNG_IMPEXP void		png_write_iTXt(png_structp png_ptr, int compression,
				png_charp key, png_charp lang,
				png_charp lang_key, png_charp text);
/* 227 */
PNG_IMPEXP void		png_write_oFFs(png_structp png_ptr,
				png_uint_32 x_offset, png_uint_32 y_offset,
				int unit_type);
/* 228 */
PNG_IMPEXP void		png_write_pCAL(png_structp png_ptr,
				png_charp purpose, png_int_32 X0,
				png_int_32 X1, int type, int nparams,
				png_charp units, png_charpp params);
/* 229 */
PNG_IMPEXP void		png_write_pHYs(png_structp png_ptr,
				png_uint_32 x_pixels_per_unit,
				png_uint_32 y_pixels_per_unit, int unit_type);
/* 230 */
PNG_IMPEXP void		png_write_tIME(png_structp png_ptr,
				png_timep mod_time);
/* 231 */
PNG_IMPEXP void		png_write_sCAL(png_structp png_ptr, int unit,
				double width, double height);
/* 232 */
PNG_IMPEXP void		png_write_sCAL_s(png_structp png_ptr, int unit,
				png_charp width, png_charp height);
/* 233 */
PNG_IMPEXP void		png_write_finish_row(png_structp png_ptr);
/* 234 */
PNG_IMPEXP void		png_write_start_row(png_structp png_ptr);
/* 235 */
PNG_IMPEXP void		png_build_gamma_table(png_structp png_ptr);
/* 236 */
PNG_IMPEXP void		png_combine_row(png_structp png_ptr, png_bytep row,
				int mask);
/* 237 */
PNG_IMPEXP void		png_do_read_interlace(png_row_infop row_info,
				png_bytep row, int pass,
				png_uint_32 transformations);
/* 238 */
PNG_IMPEXP void		png_do_write_interlace(png_row_infop row_info,
				png_bytep row, png_bytep prev_row,
				int filter);
/* 239 */
PNG_IMPEXP void		png_read_filter_row(png_structp png_ptr,
				png_row_infop row_info, png_bytep row,
				png_bytep prev_row, int filter);
/* 240 */
PNG_IMPEXP void		png_write_find_filter(png_structp png_ptr,
				png_row_infop row_info);
/* 241 */
PNG_IMPEXP void		png_write_filtered_row(png_structp png_ptr,
				png_bytep filtered_row);
/* 242 */
PNG_IMPEXP void		png_read_finish_row(png_structp png_ptr);
/* 243 */
PNG_IMPEXP void		png_read_start_row(png_structp png_ptr);
/* 244 */
PNG_IMPEXP void		png_read_transform_info(png_structp png_ptr,
				png_infop info_ptr);
/* 245 */
PNG_IMPEXP void		png_do_read_filler(png_row_infop row_info,
				png_bytep row, png_uint_32 filler,
				png_uint_32 flags);
/* 246 */
PNG_IMPEXP void		png_do_read_swap_alpha(png_row_infop row_info,
				png_bytep row);
/* 247 */
PNG_IMPEXP void		png_do_write_swap_alpha(png_row_infop row_info,
				png_bytep row);
/* 248 */
PNG_IMPEXP void		png_do_read_invert_alpha(png_row_infop row_info,
				png_bytep row);
/* 249 */
PNG_IMPEXP void		png_do_write_invert_alpha(png_row_infop row_info,
				png_bytep row);
/* 250 */
PNG_IMPEXP void		png_do_strip_filler(png_row_infop row_info,
				png_bytep row, png_uint_32 flags);
/* 251 */
PNG_IMPEXP void		png_do_swap(png_row_infop row_info, png_bytep row);
/* 252 */
PNG_IMPEXP void		png_do_packswap(png_row_infop row_info,
				png_bytep row);
/* 253 */
PNG_IMPEXP int		png_do_rgb_to_gray(png_structp png_ptr,
				png_row_infop row_info, png_bytep row);
/* 254 */
PNG_IMPEXP void		png_do_gray_to_rgb(png_row_infop row_info,
				png_bytep row);
/* 255 */
PNG_IMPEXP void		png_do_unpack(png_row_infop row_info, png_bytep row);
/* 256 */
PNG_IMPEXP void		png_do_unshift(png_row_infop row_info, png_bytep row,
				png_color_8p sig_bits);
/* 257 */
PNG_IMPEXP void		png_do_invert(png_row_infop row_info, png_bytep row);
/* 258 */
PNG_IMPEXP void		png_do_chop(png_row_infop row_info, png_bytep row);
/* 259 */
PNG_IMPEXP void		png_do_dither(png_row_infop row_info, png_bytep row,
				png_bytep palette_lookup,
				png_bytep dither_lookup);
/* 260 */
PNG_IMPEXP void		png_correct_palette(png_structp png_ptr,
				png_colorp palette, int num_palette);
/* 261 */
PNG_IMPEXP void		png_do_bgr(png_row_infop row_info, png_bytep row);
/* 262 */
PNG_IMPEXP void		png_do_pack(png_row_infop row_info, png_bytep row,
				png_uint_32 bit_depth);
/* 263 */
PNG_IMPEXP void		png_do_shift(png_row_infop row_info, png_bytep row,
				png_color_8p bit_depth);
/* 264 */
PNG_IMPEXP void		png_do_background(png_row_infop row_info,
				png_bytep row, png_color_16p trans_values,
				png_color_16p background,
				png_color_16p background_1,
				png_bytep gamma_table,
				png_bytep gamma_from_1, png_bytep gamma_to_1,
				png_uint_16pp gamma_16,
				png_uint_16pp gamma_16_from_1,
				png_uint_16pp gamma_16_to_1, int gamma_shift);
/* 265 */
PNG_IMPEXP void		png_do_gamma(png_row_infop row_info, png_bytep row,
				png_bytep gamma_table,
				png_uint_16pp gamma_16_table,
				int gamma_shift);
/* 266 */
PNG_IMPEXP void		png_do_expand_palette(png_row_infop row_info,
				png_bytep row, png_colorp palette,
				png_bytep trans, int num_trans);
/* 267 */
PNG_IMPEXP void		png_do_expand(png_row_infop row_info, png_bytep row,
				png_color_16p trans_value);
/* 268 */
PNG_IMPEXP void		png_handle_IHDR(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 269 */
PNG_IMPEXP void		png_handle_PLTE(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 270 */
PNG_IMPEXP void		png_handle_IEND(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 271 */
PNG_IMPEXP void		png_handle_bKGD(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 272 */
PNG_IMPEXP void		png_handle_cHRM(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 273 */
PNG_IMPEXP void		png_handle_gAMA(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 274 */
PNG_IMPEXP void		png_handle_hIST(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 275 */
PNG_IMPEXP void		png_handle_iCCP(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 276 */
PNG_IMPEXP void		png_handle_iTXt(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 277 */
PNG_IMPEXP void		png_handle_oFFs(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 278 */
PNG_IMPEXP void		png_handle_pCAL(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 279 */
PNG_IMPEXP void		png_handle_pHYs(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 280 */
PNG_IMPEXP void		png_handle_sBIT(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 281 */
PNG_IMPEXP void		png_handle_sCAL(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 282 */
PNG_IMPEXP void		png_handle_sPLT(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 283 */
PNG_IMPEXP void		png_handle_sRGB(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 284 */
PNG_IMPEXP void		png_handle_tEXt(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 285 */
PNG_IMPEXP void		png_handle_tIME(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 286 */
PNG_IMPEXP void		png_handle_tRNS(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 287 */
PNG_IMPEXP void		png_handle_zTXt(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 288 */
PNG_IMPEXP int		png_handle_as_unknown(png_const_structrp png_ptr,
				png_const_bytep chunk_name);
/* 289 */
PNG_IMPEXP void		png_handle_unknown(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 290 */
PNG_IMPEXP void		png_check_chunk_name(png_structp png_ptr,
				png_bytep chunk_name);
/* 291 */
PNG_IMPEXP void		png_do_read_transformations(png_structp png_ptr);
/* 292 */
PNG_IMPEXP void		png_do_write_transformations(png_structp png_ptr);
/* 293 */
PNG_IMPEXP void		png_init_read_transformations(png_structp png_ptr);
/* 294 */
PNG_IMPEXP void		png_push_read_chunk(png_structp png_ptr,
				png_infop info_ptr);
/* 295 */
PNG_IMPEXP void		png_push_read_sig(png_structp png_ptr,
				png_infop info_ptr);
/* 296 */
PNG_IMPEXP void		png_push_check_crc(png_structp png_ptr);
/* 297 */
PNG_IMPEXP void		png_push_crc_skip(png_structp png_ptr,
				png_uint_32 length);
/* 298 */
PNG_IMPEXP void		png_push_crc_finish(png_structp png_ptr);
/* 299 */
PNG_IMPEXP void		png_push_fill_buffer(png_structp png_ptr,
				png_bytep buffer, size_t length);
/* 300 */
PNG_IMPEXP void		png_push_save_buffer(png_structp png_ptr);
/* 301 */
PNG_IMPEXP void		png_push_restore_buffer(png_structp png_ptr,
				png_bytep buffer, size_t buffer_length);
/* 302 */
PNG_IMPEXP void		png_push_read_IDAT(png_structp png_ptr);
/* 303 */
PNG_IMPEXP void		png_process_IDAT_data(png_structp png_ptr,
				png_bytep buffer, size_t buffer_length);
/* 304 */
PNG_IMPEXP void		png_push_process_row(png_structp png_ptr);
/* 305 */
PNG_IMPEXP void		png_push_handle_unknown(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 306 */
PNG_IMPEXP void		png_push_have_info(png_structp png_ptr,
				png_infop info_ptr);
/* 307 */
PNG_IMPEXP void		png_push_have_end(png_structp png_ptr,
				png_infop info_ptr);
/* 308 */
PNG_IMPEXP void		png_push_have_row(png_structp png_ptr, png_bytep row);
/* 309 */
PNG_IMPEXP void		png_push_read_end(png_structp png_ptr,
				png_infop info_ptr);
/* 310 */
PNG_IMPEXP void		png_process_some_data(png_structp png_ptr,
				png_infop info_ptr);
/* 311 */
PNG_IMPEXP void		png_read_push_finish_row(png_structp png_ptr);
/* 312 */
PNG_IMPEXP void		png_push_handle_tEXt(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 313 */
PNG_IMPEXP void		png_push_read_tEXt(png_structp png_ptr,
				png_infop info_ptr);
/* 314 */
PNG_IMPEXP void		png_push_handle_zTXt(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 315 */
PNG_IMPEXP void		png_push_read_zTXt(png_structp png_ptr,
				png_infop info_ptr);
/* 316 */
PNG_IMPEXP void		png_push_handle_iTXt(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* 317 */
PNG_IMPEXP void		png_push_read_iTXt(png_structp png_ptr,
				png_infop info_ptr, png_uint_32 length);
/* Slot 318 is reserved */
/* 319 */
PNG_IMPEXP void		png_set_add_alpha(png_structrp png_ptr,
				png_uint_32 filler, int flags);
/* 320 */
PNG_IMPEXP void		png_set_scale_16(png_structrp png_ptr);

typedef struct PngtclStubs {
    int magic;
    const struct PngtclStubHooks *hooks;

    png_uint_32 (*png_access_version_numberPtr) (void); /* 0 */
    void (*png_set_sig_bytesPtr) (png_structrp png_ptr, int num_bytes); /* 1 */
    int (*png_sig_cmpPtr) (png_const_bytep sig, size_t start, size_t num_to_check); /* 2 */
    void (*reserved3)(void);
    png_structp (*png_create_read_structPtr) (png_const_charp user_png_ver, png_voidp error_ptr, png_error_ptr error_fn, png_error_ptr warn_fn); /* 4 */
    png_structp (*png_create_write_structPtr) (png_const_charp user_png_ver, png_voidp error_ptr, png_error_ptr error_fn, png_error_ptr warn_fn); /* 5 */
    size_t (*png_get_compression_buffer_sizePtr) (png_const_structrp png_ptr); /* 6 */
    void (*png_set_compression_buffer_sizePtr) (png_structrp png_ptr, size_t size); /* 7 */
    void (*reserved8)(void);
    png_structp (*png_create_read_struct_2Ptr) (png_const_charp user_png_ver, png_voidp error_ptr, png_error_ptr error_fn, png_error_ptr warn_fn, png_voidp mem_ptr, png_malloc_ptr malloc_fn, png_free_ptr free_fn); /* 9 */
    png_structp (*png_create_write_struct_2Ptr) (png_const_charp user_png_ver, png_voidp error_ptr, png_error_ptr error_fn, png_error_ptr warn_fn, png_voidp mem_ptr, png_malloc_ptr malloc_fn, png_free_ptr free_fn); /* 10 */
    void (*png_write_chunkPtr) (png_structrp png_ptr, png_const_bytep chunk_name, png_const_bytep data, size_t length); /* 11 */
    void (*png_write_chunk_startPtr) (png_structrp png_ptr, png_const_bytep chunk_name, png_uint_32 length); /* 12 */
    void (*png_write_chunk_dataPtr) (png_structrp png_ptr, png_const_bytep data, size_t length); /* 13 */
    void (*png_write_chunk_endPtr) (png_structrp png_ptr); /* 14 */
    png_infop (*png_create_info_structPtr) (png_const_structrp png_ptr); /* 15 */
    void (*reserved16)(void);
    void (*png_write_info_before_PLTEPtr) (png_structrp png_ptr, png_const_inforp info_ptr); /* 17 */
    void (*png_write_infoPtr) (png_structrp png_ptr, png_const_inforp info_ptr); /* 18 */
    void (*png_read_infoPtr) (png_structrp png_ptr, png_inforp info_ptr); /* 19 */
    void (*reserved20)(void);
    void (*png_convert_from_struct_tmPtr) (png_timep ptime, const struct tm *ttime); /* 21 */
    void (*png_convert_from_time_tPtr) (png_timep ptime, time_t ttime); /* 22 */
    void (*png_set_expandPtr) (png_structrp png_ptr); /* 23 */
    void (*reserved24)(void);
    void (*png_set_palette_to_rgbPtr) (png_structrp png_ptr); /* 25 */
    void (*png_set_tRNS_to_alphaPtr) (png_structrp png_ptr); /* 26 */
    void (*png_set_bgrPtr) (png_structrp png_ptr); /* 27 */
    void (*png_set_gray_to_rgbPtr) (png_structrp png_ptr); /* 28 */
    void (*png_set_rgb_to_grayPtr) (png_structrp png_ptr, int error_action, double red, double green); /* 29 */
    void (*png_set_rgb_to_gray_fixedPtr) (png_structrp png_ptr, int error_action, png_fixed_point red, png_fixed_point green); /* 30 */
    png_byte (*png_get_rgb_to_gray_statusPtr) (png_const_structrp png_ptr); /* 31 */
    void (*png_build_grayscale_palettePtr) (int bit_depth, png_colorp palette); /* 32 */
    void (*png_set_strip_alphaPtr) (png_structrp png_ptr); /* 33 */
    void (*png_set_swap_alphaPtr) (png_structrp png_ptr); /* 34 */
    void (*png_set_invert_alphaPtr) (png_structrp png_ptr); /* 35 */
    void (*png_set_fillerPtr) (png_structrp png_ptr, png_uint_32 filler, int flags); /* 36 */
    void (*png_set_swapPtr) (png_structrp png_ptr); /* 37 */
    void (*png_set_packingPtr) (png_structrp png_ptr); /* 38 */
    void (*png_set_packswapPtr) (png_structrp png_ptr); /* 39 */
    void (*png_set_shiftPtr) (png_structrp png_ptr, png_const_color_8p true_bits); /* 40 */
    int (*png_set_interlace_handlingPtr) (png_structrp png_ptr); /* 41 */
    void (*png_set_invert_monoPtr) (png_structrp png_ptr); /* 42 */
    void (*png_set_backgroundPtr) (png_structrp png_ptr, png_const_color_16p background_color, int background_gamma_code, int need_expand, double background_gamma); /* 43 */
    void (*png_set_strip_16Ptr) (png_structrp png_ptr); /* 44 */
    void (*png_set_quantizePtr) (png_structrp png_ptr, png_colorp palette, int num_palette, int maximum_colors, png_const_uint_16p histogram, int full_quantize); /* 45 */
    void (*png_set_gammaPtr) (png_structrp png_ptr, double screen_gamma, double default_file_gamma); /* 46 */
    void (*png_permit_empty_pltePtr) (png_structrp png_ptr, int empty_plte_permitted); /* 47 */
    void (*png_set_flushPtr) (png_structrp png_ptr, int nrows); /* 48 */
    void (*png_write_flushPtr) (png_structrp png_ptr); /* 49 */
    void (*png_start_read_imagePtr) (png_structrp png_ptr); /* 50 */
    void (*png_read_update_infoPtr) (png_structrp png_ptr, png_inforp info_ptr); /* 51 */
    void (*png_read_rowsPtr) (png_structrp png_ptr, png_bytepp row, png_bytepp display_row, png_uint_32 num_rows); /* 52 */
    void (*png_read_rowPtr) (png_structrp png_ptr, png_bytep row, png_bytep display_row); /* 53 */
    void (*png_read_imagePtr) (png_structrp png_ptr, png_bytepp image); /* 54 */
    void (*png_write_rowPtr) (png_structrp png_ptr, png_const_bytep row); /* 55 */
    void (*png_write_rowsPtr) (png_structrp png_ptr, png_bytepp row, png_uint_32 num_rows); /* 56 */
    void (*png_write_imagePtr) (png_structrp png_ptr, png_bytepp image); /* 57 */
    void (*png_write_endPtr) (png_structrp png_ptr, png_inforp info_ptr); /* 58 */
    void (*png_read_endPtr) (png_structrp png_ptr, png_inforp info_ptr); /* 59 */
    void (*png_destroy_info_structPtr) (png_const_structrp png_ptr, png_infopp info_ptr_ptr); /* 60 */
    void (*png_destroy_read_structPtr) (png_structpp png_ptr_ptr, png_infopp info_ptr_ptr, png_infopp end_info_ptr_ptr); /* 61 */
    void (*reserved62)(void);
    void (*png_destroy_write_structPtr) (png_structpp png_ptr_ptr, png_infopp info_ptr_ptr); /* 63 */
    void (*reserved64)(void);
    void (*reserved65)(void);
    void (*png_set_crc_actionPtr) (png_structrp png_ptr, int crit_action, int ancil_action); /* 66 */
    void (*png_set_filterPtr) (png_structrp png_ptr, int method, int filters); /* 67 */
    void (*png_set_filter_heuristicsPtr) (png_structrp png_ptr, int heuristic_method, int num_weights, png_const_doublep filter_weights, png_const_doublep filter_costs); /* 68 */
    void (*png_set_compression_levelPtr) (png_structrp png_ptr, int level); /* 69 */
    void (*png_set_compression_mem_levelPtr) (png_structrp png_ptr, int mem_level); /* 70 */
    void (*png_set_compression_strategyPtr) (png_structrp png_ptr, int strategy); /* 71 */
    void (*png_set_compression_window_bitsPtr) (png_structrp png_ptr, int window_bits); /* 72 */
    void (*png_set_compression_methodPtr) (png_structrp png_ptr, int method); /* 73 */
    void (*png_init_ioPtr) (png_structrp png_ptr, png_FILE_p fp); /* 74 */
    void (*png_set_error_fnPtr) (png_structrp png_ptr, png_voidp error_ptr, png_error_ptr error_fn, png_error_ptr warning_fn); /* 75 */
    png_voidp (*png_get_error_ptrPtr) (png_const_structrp png_ptr); /* 76 */
    void (*png_set_write_fnPtr) (png_structrp png_ptr, png_voidp io_ptr, png_rw_ptr write_data_fn, png_flush_ptr output_flush_fn); /* 77 */
    void (*png_set_read_fnPtr) (png_structrp png_ptr, png_voidp io_ptr, png_rw_ptr read_data_fn); /* 78 */
    png_voidp (*png_get_io_ptrPtr) (png_const_structrp png_ptr); /* 79 */
    void (*png_set_read_status_fnPtr) (png_structrp png_ptr, png_read_status_ptr read_row_fn); /* 80 */
    void (*png_set_write_status_fnPtr) (png_structrp png_ptr, png_write_status_ptr write_row_fn); /* 81 */
    void (*png_set_mem_fnPtr) (png_structrp png_ptr, png_voidp mem_ptr, png_malloc_ptr malloc_fn, png_free_ptr free_fn); /* 82 */
    png_voidp (*png_get_mem_ptrPtr) (png_const_structrp png_ptr); /* 83 */
    void (*png_set_read_user_transform_fnPtr) (png_structrp png_ptr, png_user_transform_ptr read_user_transform_fn); /* 84 */
    void (*png_set_write_user_transform_fnPtr) (png_structrp png_ptr, png_user_transform_ptr write_user_transform_fn); /* 85 */
    void (*png_set_user_transform_infoPtr) (png_structrp png_ptr, png_voidp user_transform_ptr, int user_transform_depth, int user_transform_channels); /* 86 */
    png_voidp (*png_get_user_transform_ptrPtr) (png_const_structrp png_ptr); /* 87 */
    void (*png_set_read_user_chunk_fnPtr) (png_structrp png_ptr, png_voidp user_chunk_ptr, png_user_chunk_ptr read_user_chunk_fn); /* 88 */
    png_voidp (*png_get_user_chunk_ptrPtr) (png_const_structrp png_ptr); /* 89 */
    void (*png_set_progressive_read_fnPtr) (png_structrp png_ptr, png_voidp progressive_ptr, png_progressive_info_ptr info_fn, png_progressive_row_ptr row_fn, png_progressive_end_ptr end_fn); /* 90 */
    png_voidp (*png_get_progressive_ptrPtr) (png_const_structrp png_ptr); /* 91 */
    void (*png_process_dataPtr) (png_structrp png_ptr, png_inforp info_ptr, png_bytep buffer, size_t buffer_size); /* 92 */
    void (*png_progressive_combine_rowPtr) (png_const_structrp png_ptr, png_bytep old_row, png_const_bytep new_row); /* 93 */
    png_voidp (*png_mallocPtr) (png_const_structrp png_ptr, png_alloc_size_t size); /* 94 */
    void (*png_freePtr) (png_const_structrp png_ptr, png_voidp ptr); /* 95 */
    void (*png_free_dataPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_uint_32 free_me, int num); /* 96 */
    void (*reserved97)(void);
    void (*reserved98)(void);
    void (*reserved99)(void);
    void (*reserved100)(void);
    void (*reserved101)(void);
    void * (*png_far_to_nearPtr) (png_structp png_ptr, png_voidp ptr, int check); /* 102 */
    void (*png_errorPtr) (png_const_structrp png_ptr, png_const_charp error_message); /* 103 */
    void (*png_chunk_errorPtr) (png_const_structrp png_ptr, png_const_charp error_message); /* 104 */
    void (*png_warningPtr) (png_const_structrp png_ptr, png_const_charp warning_message); /* 105 */
    void (*png_chunk_warningPtr) (png_const_structrp png_ptr, png_const_charp warning_message); /* 106 */
    png_uint_32 (*png_get_validPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr, png_uint_32 flag); /* 107 */
    size_t (*png_get_rowbytesPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 108 */
    png_bytepp (*png_get_rowsPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 109 */
    void (*png_set_rowsPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_bytepp row_pointers); /* 110 */
    png_byte (*png_get_channelsPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 111 */
    png_uint_32 (*png_get_image_widthPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 112 */
    png_uint_32 (*png_get_image_heightPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 113 */
    png_byte (*png_get_bit_depthPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 114 */
    png_byte (*png_get_color_typePtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 115 */
    png_byte (*png_get_filter_typePtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 116 */
    png_byte (*png_get_interlace_typePtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 117 */
    png_byte (*png_get_compression_typePtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 118 */
    png_uint_32 (*png_get_pixels_per_meterPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 119 */
    png_uint_32 (*png_get_x_pixels_per_meterPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 120 */
    png_uint_32 (*png_get_y_pixels_per_meterPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 121 */
    float (*png_get_pixel_aspect_ratioPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 122 */
    png_int_32 (*png_get_x_offset_pixelsPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 123 */
    png_int_32 (*png_get_y_offset_pixelsPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 124 */
    png_int_32 (*png_get_x_offset_micronsPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 125 */
    png_int_32 (*png_get_y_offset_micronsPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 126 */
    png_const_bytep (*png_get_signaturePtr) (png_const_structrp png_ptr, png_const_inforp info_ptr); /* 127 */
    png_uint_32 (*png_get_bKGDPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_color_16p *background); /* 128 */
    void (*png_set_bKGDPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_const_color_16p background); /* 129 */
    png_uint_32 (*png_get_cHRMPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr, double *white_x, double *white_y, double *red_x, double *red_y, double *green_x, double *green_y, double *blue_x, double *blue_y); /* 130 */
    png_uint_32 (*png_get_cHRM_fixedPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr, png_fixed_point *int_white_x, png_fixed_point *int_white_y, png_fixed_point *int_red_x, png_fixed_point *int_red_y, png_fixed_point *int_green_x, png_fixed_point *int_green_y, png_fixed_point *int_blue_x, png_fixed_point *int_blue_y); /* 131 */
    void (*png_set_cHRMPtr) (png_const_structrp png_ptr, png_inforp info_ptr, double white_x, double white_y, double red_x, double red_y, double green_x, double green_y, double blue_x, double blue_y); /* 132 */
    void (*png_set_cHRM_fixedPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_fixed_point int_white_x, png_fixed_point int_white_y, png_fixed_point int_red_x, png_fixed_point int_red_y, png_fixed_point int_green_x, png_fixed_point int_green_y, png_fixed_point int_blue_x, png_fixed_point int_blue_y); /* 133 */
    png_uint_32 (*png_get_gAMAPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr, double *file_gamma); /* 134 */
    png_uint_32 (*png_get_gAMA_fixedPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr, png_fixed_point *int_file_gamma); /* 135 */
    void (*png_set_gAMAPtr) (png_const_structrp png_ptr, png_inforp info_ptr, double file_gamma); /* 136 */
    void (*png_set_gAMA_fixedPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_fixed_point int_file_gamma); /* 137 */
    png_uint_32 (*png_get_hISTPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_uint_16p *hist); /* 138 */
    void (*png_set_hISTPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_const_uint_16p hist); /* 139 */
    png_uint_32 (*png_get_IHDRPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr, png_uint_32 *width, png_uint_32 *height, int *bit_depth, int *color_type, int *interlace_type, int *compression_type, int *filter_type); /* 140 */
    void (*png_set_IHDRPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_uint_32 width, png_uint_32 height, int bit_depth, int color_type, int interlace_type, int compression_type, int filter_type); /* 141 */
    png_uint_32 (*png_get_oFFsPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr, png_int_32 *offset_x, png_int_32 *offset_y, int *unit_type); /* 142 */
    void (*png_set_oFFsPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_int_32 offset_x, png_int_32 offset_y, int unit_type); /* 143 */
    png_uint_32 (*png_get_pCALPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_charp *purpose, png_int_32 *X0, png_int_32 *X1, int *type, int *nparams, png_charp *units, png_charpp *params); /* 144 */
    void (*png_set_pCALPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_const_charp purpose, png_int_32 X0, png_int_32 X1, int type, int nparams, png_const_charp units, png_charpp params); /* 145 */
    png_uint_32 (*png_get_pHYsPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr, png_uint_32 *res_x, png_uint_32 *res_y, int *unit_type); /* 146 */
    void (*png_set_pHYsPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_uint_32 res_x, png_uint_32 res_y, int unit_type); /* 147 */
    png_uint_32 (*png_get_PLTEPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_colorp *palette, int *num_palette); /* 148 */
    void (*png_set_PLTEPtr) (png_structrp png_ptr, png_inforp info_ptr, png_const_colorp palette, int num_palette); /* 149 */
    png_uint_32 (*png_get_sBITPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_color_8p *sig_bit); /* 150 */
    void (*png_set_sBITPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_const_color_8p sig_bit); /* 151 */
    png_uint_32 (*png_get_sRGBPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr, int *intent); /* 152 */
    void (*png_set_sRGBPtr) (png_const_structrp png_ptr, png_inforp info_ptr, int intent); /* 153 */
    void (*png_set_sRGB_gAMA_and_cHRMPtr) (png_const_structrp png_ptr, png_inforp info_ptr, int intent); /* 154 */
    png_uint_32 (*png_get_iCCPPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_charpp name, int *compression_type, png_bytepp profile, png_uint_32 *proflen); /* 155 */
    void (*png_set_iCCPPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_const_charp name, int compression_type, png_const_bytep profile, png_uint_32 proflen); /* 156 */
    int (*png_get_sPLTPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_sPLT_tpp entries); /* 157 */
    void (*png_set_sPLTPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_const_sPLT_tp entries, int nentries); /* 158 */
    int (*png_get_textPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_textp *text_ptr, int *num_text); /* 159 */
    void (*png_set_textPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_const_textp text_ptr, int num_text); /* 160 */
    png_uint_32 (*png_get_tIMEPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_timep *mod_time); /* 161 */
    void (*png_set_tIMEPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_const_timep mod_time); /* 162 */
    png_uint_32 (*png_get_tRNSPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_bytep *trans, int *num_trans, png_color_16p *trans_values); /* 163 */
    void (*png_set_tRNSPtr) (png_structrp png_ptr, png_inforp info_ptr, png_const_bytep trans_alpha, int num_trans, png_const_color_16p trans_values); /* 164 */
    png_uint_32 (*png_get_sCALPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr, int *unit, double *width, double *height); /* 165 */
    png_uint_32 (*png_get_sCAL_sPtr) (png_const_structrp png_ptr, png_const_inforp info_ptr, int *unit, png_charpp swidth, png_charpp sheight); /* 166 */
    void (*png_set_sCALPtr) (png_const_structrp png_ptr, png_inforp info_ptr, int unit, double width, double height); /* 167 */
    void (*png_set_sCAL_sPtr) (png_const_structrp png_ptr, png_inforp info_ptr, int unit, png_const_charp swidth, png_const_charp sheight); /* 168 */
    void (*png_set_keep_unknown_chunksPtr) (png_structrp png_ptr, int keep, png_const_bytep chunk_list, int num_chunks); /* 169 */
    void (*png_set_unknown_chunksPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_const_unknown_chunkp unknowns, int num_unknowns); /* 170 */
    void (*png_set_unknown_chunk_locationPtr) (png_const_structrp png_ptr, png_inforp info_ptr, int chunk, int location); /* 171 */
    int (*png_get_unknown_chunksPtr) (png_const_structrp png_ptr, png_inforp info_ptr, png_unknown_chunkpp entries); /* 172 */
    void (*png_set_invalidPtr) (png_const_structrp png_ptr, png_inforp info_ptr, int mask); /* 173 */
    void (*png_read_pngPtr) (png_structrp png_ptr, png_inforp info_ptr, int transforms, png_voidp params); /* 174 */
    void (*png_write_pngPtr) (png_structrp png_ptr, png_inforp info_ptr, int transforms, png_voidp params); /* 175 */
    png_bytep (*png_sig_bytesPtr) (void); /* 176 */
    png_const_charp (*png_get_copyrightPtr) (png_const_structrp png_ptr); /* 177 */
    png_const_charp (*png_get_header_verPtr) (png_const_structrp png_ptr); /* 178 */
    png_const_charp (*png_get_header_versionPtr) (png_const_structrp png_ptr); /* 179 */
    png_const_charp (*png_get_libpng_verPtr) (png_const_structrp png_ptr); /* 180 */
    void (*reserved181)(void);
    void (*reserved182)(void);
    void (*reserved183)(void);
    void (*png_read_initPtr) (png_structp png_ptr); /* 184 */
    void (*png_read_init_2Ptr) (png_structp png_ptr, png_const_charp user_png_ver, size_t png_struct_size, size_t png_info_size); /* 185 */
    void (*reserved186)(void);
    void (*reserved187)(void);
    png_voidp (*png_create_structPtr) (int type); /* 188 */
    void (*png_destroy_structPtr) (png_voidp struct_ptr); /* 189 */
    png_voidp (*png_create_struct_2Ptr) (int type, png_malloc_ptr malloc_fn); /* 190 */
    void (*png_destroy_struct_2Ptr) (png_voidp struct_ptr, png_free_ptr free_fn); /* 191 */
    void (*png_info_destroyPtr) (png_structp png_ptr, png_infop info_ptr); /* 192 */
    void (*reserved193)(void);
    void (*reserved194)(void);
    void (*png_reset_crcPtr) (png_structp png_ptr); /* 195 */
    void (*png_write_dataPtr) (png_structp png_ptr, png_bytep data, size_t length); /* 196 */
    void (*png_read_dataPtr) (png_structp png_ptr, png_bytep data, size_t length); /* 197 */
    void (*png_crc_readPtr) (png_structp png_ptr, png_bytep buf, size_t length); /* 198 */
    png_charp (*png_decompress_chunkPtr) (png_structp png_ptr, int comp_type, png_charp chunkdata, size_t chunklength, size_t prefix_length, size_t *data_length); /* 199 */
    int (*png_crc_finishPtr) (png_structp png_ptr, png_uint_32 skip); /* 200 */
    int (*png_crc_errorPtr) (png_structp png_ptr); /* 201 */
    void (*png_calculate_crcPtr) (png_structp png_ptr, png_bytep ptr, size_t length); /* 202 */
    void (*png_flushPtr) (png_structp png_ptr); /* 203 */
    void (*png_save_uint_32Ptr) (png_bytep buf, png_uint_32 i); /* 204 */
    void (*png_save_int_32Ptr) (png_bytep buf, png_int_32 i); /* 205 */
    void (*png_save_uint_16Ptr) (png_bytep buf, unsigned int i); /* 206 */
    void (*png_write_sigPtr) (png_structrp png_ptr); /* 207 */
    void (*png_write_IHDRPtr) (png_structp png_ptr, png_uint_32 width, png_uint_32 height, int bit_depth, int color_type, int compression_type, int filter_type, int interlace_type); /* 208 */
    void (*png_write_PLTEPtr) (png_structp png_ptr, png_colorp palette, png_uint_32 num_pal); /* 209 */
    void (*png_write_IDATPtr) (png_structp png_ptr, png_bytep data, size_t length); /* 210 */
    void (*png_write_IENDPtr) (png_structp png_ptr); /* 211 */
    void (*png_write_gAMAPtr) (png_structp png_ptr, double file_gamma); /* 212 */
    void (*png_write_gAMA_fixedPtr) (png_structp png_ptr, png_fixed_point file_gamma); /* 213 */
    void (*png_write_sBITPtr) (png_structp png_ptr, png_color_8p sbit, int color_type); /* 214 */
    void (*png_write_cHRMPtr) (png_structp png_ptr, double white_x, double white_y, double red_x, double red_y, double green_x, double green_y, double blue_x, double blue_y); /* 215 */
    void (*png_write_cHRM_fixedPtr) (png_structp png_ptr, png_fixed_point int_white_x, png_fixed_point int_white_y, png_fixed_point int_red_x, png_fixed_point int_red_y, png_fixed_point int_green_x, png_fixed_point int_green_y, png_fixed_point int_blue_x, png_fixed_point int_blue_y); /* 216 */
    void (*png_write_sRGBPtr) (png_structp png_ptr, int intent); /* 217 */
    void (*png_write_iCCPPtr) (png_structp png_ptr, png_charp name, int compression_type, png_charp profile, int proflen); /* 218 */
    void (*png_write_sPLTPtr) (png_structp png_ptr, png_sPLT_tp palette); /* 219 */
    void (*png_write_tRNSPtr) (png_structp png_ptr, png_bytep trans, png_color_16p values, int number, int color_type); /* 220 */
    void (*png_write_bKGDPtr) (png_structp png_ptr, png_color_16p values, int color_type); /* 221 */
    void (*png_write_hISTPtr) (png_structp png_ptr, png_uint_16p hist, int num_hist); /* 222 */
    size_t (*png_check_keywordPtr) (png_structp png_ptr, png_charp key, png_charpp new_key); /* 223 */
    void (*png_write_tEXtPtr) (png_structp png_ptr, png_charp key, png_charp text, size_t text_len); /* 224 */
    void (*png_write_zTXtPtr) (png_structp png_ptr, png_charp key, size_t text_len, int compression); /* 225 */
    void (*png_write_iTXtPtr) (png_structp png_ptr, int compression, png_charp key, png_charp lang, png_charp lang_key, png_charp text); /* 226 */
    void (*png_write_oFFsPtr) (png_structp png_ptr, png_uint_32 x_offset, png_uint_32 y_offset, int unit_type); /* 227 */
    void (*png_write_pCALPtr) (png_structp png_ptr, png_charp purpose, png_int_32 X0, png_int_32 X1, int type, int nparams, png_charp units, png_charpp params); /* 228 */
    void (*png_write_pHYsPtr) (png_structp png_ptr, png_uint_32 x_pixels_per_unit, png_uint_32 y_pixels_per_unit, int unit_type); /* 229 */
    void (*png_write_tIMEPtr) (png_structp png_ptr, png_timep mod_time); /* 230 */
    void (*png_write_sCALPtr) (png_structp png_ptr, int unit, double width, double height); /* 231 */
    void (*png_write_sCAL_sPtr) (png_structp png_ptr, int unit, png_charp width, png_charp height); /* 232 */
    void (*png_write_finish_rowPtr) (png_structp png_ptr); /* 233 */
    void (*png_write_start_rowPtr) (png_structp png_ptr); /* 234 */
    void (*png_build_gamma_tablePtr) (png_structp png_ptr); /* 235 */
    void (*png_combine_rowPtr) (png_structp png_ptr, png_bytep row, int mask); /* 236 */
    void (*png_do_read_interlacePtr) (png_row_infop row_info, png_bytep row, int pass, png_uint_32 transformations); /* 237 */
    void (*png_do_write_interlacePtr) (png_row_infop row_info, png_bytep row, png_bytep prev_row, int filter); /* 238 */
    void (*png_read_filter_rowPtr) (png_structp png_ptr, png_row_infop row_info, png_bytep row, png_bytep prev_row, int filter); /* 239 */
    void (*png_write_find_filterPtr) (png_structp png_ptr, png_row_infop row_info); /* 240 */
    void (*png_write_filtered_rowPtr) (png_structp png_ptr, png_bytep filtered_row); /* 241 */
    void (*png_read_finish_rowPtr) (png_structp png_ptr); /* 242 */
    void (*png_read_start_rowPtr) (png_structp png_ptr); /* 243 */
    void (*png_read_transform_infoPtr) (png_structp png_ptr, png_infop info_ptr); /* 244 */
    void (*png_do_read_fillerPtr) (png_row_infop row_info, png_bytep row, png_uint_32 filler, png_uint_32 flags); /* 245 */
    void (*png_do_read_swap_alphaPtr) (png_row_infop row_info, png_bytep row); /* 246 */
    void (*png_do_write_swap_alphaPtr) (png_row_infop row_info, png_bytep row); /* 247 */
    void (*png_do_read_invert_alphaPtr) (png_row_infop row_info, png_bytep row); /* 248 */
    void (*png_do_write_invert_alphaPtr) (png_row_infop row_info, png_bytep row); /* 249 */
    void (*png_do_strip_fillerPtr) (png_row_infop row_info, png_bytep row, png_uint_32 flags); /* 250 */
    void (*png_do_swapPtr) (png_row_infop row_info, png_bytep row); /* 251 */
    void (*png_do_packswapPtr) (png_row_infop row_info, png_bytep row); /* 252 */
    int (*png_do_rgb_to_grayPtr) (png_structp png_ptr, png_row_infop row_info, png_bytep row); /* 253 */
    void (*png_do_gray_to_rgbPtr) (png_row_infop row_info, png_bytep row); /* 254 */
    void (*png_do_unpackPtr) (png_row_infop row_info, png_bytep row); /* 255 */
    void (*png_do_unshiftPtr) (png_row_infop row_info, png_bytep row, png_color_8p sig_bits); /* 256 */
    void (*png_do_invertPtr) (png_row_infop row_info, png_bytep row); /* 257 */
    void (*png_do_chopPtr) (png_row_infop row_info, png_bytep row); /* 258 */
    void (*png_do_ditherPtr) (png_row_infop row_info, png_bytep row, png_bytep palette_lookup, png_bytep dither_lookup); /* 259 */
    void (*png_correct_palettePtr) (png_structp png_ptr, png_colorp palette, int num_palette); /* 260 */
    void (*png_do_bgrPtr) (png_row_infop row_info, png_bytep row); /* 261 */
    void (*png_do_packPtr) (png_row_infop row_info, png_bytep row, png_uint_32 bit_depth); /* 262 */
    void (*png_do_shiftPtr) (png_row_infop row_info, png_bytep row, png_color_8p bit_depth); /* 263 */
    void (*png_do_backgroundPtr) (png_row_infop row_info, png_bytep row, png_color_16p trans_values, png_color_16p background, png_color_16p background_1, png_bytep gamma_table, png_bytep gamma_from_1, png_bytep gamma_to_1, png_uint_16pp gamma_16, png_uint_16pp gamma_16_from_1, png_uint_16pp gamma_16_to_1, int gamma_shift); /* 264 */
    void (*png_do_gammaPtr) (png_row_infop row_info, png_bytep row, png_bytep gamma_table, png_uint_16pp gamma_16_table, int gamma_shift); /* 265 */
    void (*png_do_expand_palettePtr) (png_row_infop row_info, png_bytep row, png_colorp palette, png_bytep trans, int num_trans); /* 266 */
    void (*png_do_expandPtr) (png_row_infop row_info, png_bytep row, png_color_16p trans_value); /* 267 */
    void (*png_handle_IHDRPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 268 */
    void (*png_handle_PLTEPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 269 */
    void (*png_handle_IENDPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 270 */
    void (*png_handle_bKGDPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 271 */
    void (*png_handle_cHRMPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 272 */
    void (*png_handle_gAMAPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 273 */
    void (*png_handle_hISTPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 274 */
    void (*png_handle_iCCPPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 275 */
    void (*png_handle_iTXtPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 276 */
    void (*png_handle_oFFsPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 277 */
    void (*png_handle_pCALPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 278 */
    void (*png_handle_pHYsPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 279 */
    void (*png_handle_sBITPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 280 */
    void (*png_handle_sCALPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 281 */
    void (*png_handle_sPLTPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 282 */
    void (*png_handle_sRGBPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 283 */
    void (*png_handle_tEXtPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 284 */
    void (*png_handle_tIMEPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 285 */
    void (*png_handle_tRNSPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 286 */
    void (*png_handle_zTXtPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 287 */
    int (*png_handle_as_unknownPtr) (png_const_structrp png_ptr, png_const_bytep chunk_name); /* 288 */
    void (*png_handle_unknownPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 289 */
    void (*png_check_chunk_namePtr) (png_structp png_ptr, png_bytep chunk_name); /* 290 */
    void (*png_do_read_transformationsPtr) (png_structp png_ptr); /* 291 */
    void (*png_do_write_transformationsPtr) (png_structp png_ptr); /* 292 */
    void (*png_init_read_transformationsPtr) (png_structp png_ptr); /* 293 */
    void (*png_push_read_chunkPtr) (png_structp png_ptr, png_infop info_ptr); /* 294 */
    void (*png_push_read_sigPtr) (png_structp png_ptr, png_infop info_ptr); /* 295 */
    void (*png_push_check_crcPtr) (png_structp png_ptr); /* 296 */
    void (*png_push_crc_skipPtr) (png_structp png_ptr, png_uint_32 length); /* 297 */
    void (*png_push_crc_finishPtr) (png_structp png_ptr); /* 298 */
    void (*png_push_fill_bufferPtr) (png_structp png_ptr, png_bytep buffer, size_t length); /* 299 */
    void (*png_push_save_bufferPtr) (png_structp png_ptr); /* 300 */
    void (*png_push_restore_bufferPtr) (png_structp png_ptr, png_bytep buffer, size_t buffer_length); /* 301 */
    void (*png_push_read_IDATPtr) (png_structp png_ptr); /* 302 */
    void (*png_process_IDAT_dataPtr) (png_structp png_ptr, png_bytep buffer, size_t buffer_length); /* 303 */
    void (*png_push_process_rowPtr) (png_structp png_ptr); /* 304 */
    void (*png_push_handle_unknownPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 305 */
    void (*png_push_have_infoPtr) (png_structp png_ptr, png_infop info_ptr); /* 306 */
    void (*png_push_have_endPtr) (png_structp png_ptr, png_infop info_ptr); /* 307 */
    void (*png_push_have_rowPtr) (png_structp png_ptr, png_bytep row); /* 308 */
    void (*png_push_read_endPtr) (png_structp png_ptr, png_infop info_ptr); /* 309 */
    void (*png_process_some_dataPtr) (png_structp png_ptr, png_infop info_ptr); /* 310 */
    void (*png_read_push_finish_rowPtr) (png_structp png_ptr); /* 311 */
    void (*png_push_handle_tEXtPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 312 */
    void (*png_push_read_tEXtPtr) (png_structp png_ptr, png_infop info_ptr); /* 313 */
    void (*png_push_handle_zTXtPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 314 */
    void (*png_push_read_zTXtPtr) (png_structp png_ptr, png_infop info_ptr); /* 315 */
    void (*png_push_handle_iTXtPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 316 */
    void (*png_push_read_iTXtPtr) (png_structp png_ptr, png_infop info_ptr, png_uint_32 length); /* 317 */
    void (*reserved318)(void);
    void (*png_set_add_alphaPtr) (png_structrp png_ptr, png_uint_32 filler, int flags); /* 319 */
    void (*png_set_scale_16Ptr) (png_structrp png_ptr); /* 320 */
} PngtclStubs;

#ifdef __cplusplus
extern "C" {
#endif
PNG_IMPEXP const PngtclStubs *pngtclStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_PNGTCL_STUBS)

/*
 * Inline function declarations:
 */

#define png_access_version_number \
	(pngtclStubsPtr->png_access_version_numberPtr) /* 0 */
#define png_set_sig_bytes \
	(pngtclStubsPtr->png_set_sig_bytesPtr) /* 1 */
#define png_sig_cmp \
	(pngtclStubsPtr->png_sig_cmpPtr) /* 2 */
/* Slot 3 is reserved */
#define png_create_read_struct \
	(pngtclStubsPtr->png_create_read_structPtr) /* 4 */
#define png_create_write_struct \
	(pngtclStubsPtr->png_create_write_structPtr) /* 5 */
#define png_get_compression_buffer_size \
	(pngtclStubsPtr->png_get_compression_buffer_sizePtr) /* 6 */
#define png_set_compression_buffer_size \
	(pngtclStubsPtr->png_set_compression_buffer_sizePtr) /* 7 */
/* Slot 8 is reserved */
#define png_create_read_struct_2 \
	(pngtclStubsPtr->png_create_read_struct_2Ptr) /* 9 */
#define png_create_write_struct_2 \
	(pngtclStubsPtr->png_create_write_struct_2Ptr) /* 10 */
#define png_write_chunk \
	(pngtclStubsPtr->png_write_chunkPtr) /* 11 */
#define png_write_chunk_start \
	(pngtclStubsPtr->png_write_chunk_startPtr) /* 12 */
#define png_write_chunk_data \
	(pngtclStubsPtr->png_write_chunk_dataPtr) /* 13 */
#define png_write_chunk_end \
	(pngtclStubsPtr->png_write_chunk_endPtr) /* 14 */
#define png_create_info_struct \
	(pngtclStubsPtr->png_create_info_structPtr) /* 15 */
/* Slot 16 is reserved */
#define png_write_info_before_PLTE \
	(pngtclStubsPtr->png_write_info_before_PLTEPtr) /* 17 */
#define png_write_info \
	(pngtclStubsPtr->png_write_infoPtr) /* 18 */
#define png_read_info \
	(pngtclStubsPtr->png_read_infoPtr) /* 19 */
/* Slot 20 is reserved */
#define png_convert_from_struct_tm \
	(pngtclStubsPtr->png_convert_from_struct_tmPtr) /* 21 */
#define png_convert_from_time_t \
	(pngtclStubsPtr->png_convert_from_time_tPtr) /* 22 */
#define png_set_expand \
	(pngtclStubsPtr->png_set_expandPtr) /* 23 */
/* Slot 24 is reserved */
#define png_set_palette_to_rgb \
	(pngtclStubsPtr->png_set_palette_to_rgbPtr) /* 25 */
#define png_set_tRNS_to_alpha \
	(pngtclStubsPtr->png_set_tRNS_to_alphaPtr) /* 26 */
#define png_set_bgr \
	(pngtclStubsPtr->png_set_bgrPtr) /* 27 */
#define png_set_gray_to_rgb \
	(pngtclStubsPtr->png_set_gray_to_rgbPtr) /* 28 */
#define png_set_rgb_to_gray \
	(pngtclStubsPtr->png_set_rgb_to_grayPtr) /* 29 */
#define png_set_rgb_to_gray_fixed \
	(pngtclStubsPtr->png_set_rgb_to_gray_fixedPtr) /* 30 */
#define png_get_rgb_to_gray_status \
	(pngtclStubsPtr->png_get_rgb_to_gray_statusPtr) /* 31 */
#define png_build_grayscale_palette \
	(pngtclStubsPtr->png_build_grayscale_palettePtr) /* 32 */
#define png_set_strip_alpha \
	(pngtclStubsPtr->png_set_strip_alphaPtr) /* 33 */
#define png_set_swap_alpha \
	(pngtclStubsPtr->png_set_swap_alphaPtr) /* 34 */
#define png_set_invert_alpha \
	(pngtclStubsPtr->png_set_invert_alphaPtr) /* 35 */
#define png_set_filler \
	(pngtclStubsPtr->png_set_fillerPtr) /* 36 */
#define png_set_swap \
	(pngtclStubsPtr->png_set_swapPtr) /* 37 */
#define png_set_packing \
	(pngtclStubsPtr->png_set_packingPtr) /* 38 */
#define png_set_packswap \
	(pngtclStubsPtr->png_set_packswapPtr) /* 39 */
#define png_set_shift \
	(pngtclStubsPtr->png_set_shiftPtr) /* 40 */
#define png_set_interlace_handling \
	(pngtclStubsPtr->png_set_interlace_handlingPtr) /* 41 */
#define png_set_invert_mono \
	(pngtclStubsPtr->png_set_invert_monoPtr) /* 42 */
#define png_set_background \
	(pngtclStubsPtr->png_set_backgroundPtr) /* 43 */
#define png_set_strip_16 \
	(pngtclStubsPtr->png_set_strip_16Ptr) /* 44 */
#define png_set_quantize \
	(pngtclStubsPtr->png_set_quantizePtr) /* 45 */
#define png_set_gamma \
	(pngtclStubsPtr->png_set_gammaPtr) /* 46 */
#define png_permit_empty_plte \
	(pngtclStubsPtr->png_permit_empty_pltePtr) /* 47 */
#define png_set_flush \
	(pngtclStubsPtr->png_set_flushPtr) /* 48 */
#define png_write_flush \
	(pngtclStubsPtr->png_write_flushPtr) /* 49 */
#define png_start_read_image \
	(pngtclStubsPtr->png_start_read_imagePtr) /* 50 */
#define png_read_update_info \
	(pngtclStubsPtr->png_read_update_infoPtr) /* 51 */
#define png_read_rows \
	(pngtclStubsPtr->png_read_rowsPtr) /* 52 */
#define png_read_row \
	(pngtclStubsPtr->png_read_rowPtr) /* 53 */
#define png_read_image \
	(pngtclStubsPtr->png_read_imagePtr) /* 54 */
#define png_write_row \
	(pngtclStubsPtr->png_write_rowPtr) /* 55 */
#define png_write_rows \
	(pngtclStubsPtr->png_write_rowsPtr) /* 56 */
#define png_write_image \
	(pngtclStubsPtr->png_write_imagePtr) /* 57 */
#define png_write_end \
	(pngtclStubsPtr->png_write_endPtr) /* 58 */
#define png_read_end \
	(pngtclStubsPtr->png_read_endPtr) /* 59 */
#define png_destroy_info_struct \
	(pngtclStubsPtr->png_destroy_info_structPtr) /* 60 */
#define png_destroy_read_struct \
	(pngtclStubsPtr->png_destroy_read_structPtr) /* 61 */
/* Slot 62 is reserved */
#define png_destroy_write_struct \
	(pngtclStubsPtr->png_destroy_write_structPtr) /* 63 */
/* Slot 64 is reserved */
/* Slot 65 is reserved */
#define png_set_crc_action \
	(pngtclStubsPtr->png_set_crc_actionPtr) /* 66 */
#define png_set_filter \
	(pngtclStubsPtr->png_set_filterPtr) /* 67 */
#define png_set_filter_heuristics \
	(pngtclStubsPtr->png_set_filter_heuristicsPtr) /* 68 */
#define png_set_compression_level \
	(pngtclStubsPtr->png_set_compression_levelPtr) /* 69 */
#define png_set_compression_mem_level \
	(pngtclStubsPtr->png_set_compression_mem_levelPtr) /* 70 */
#define png_set_compression_strategy \
	(pngtclStubsPtr->png_set_compression_strategyPtr) /* 71 */
#define png_set_compression_window_bits \
	(pngtclStubsPtr->png_set_compression_window_bitsPtr) /* 72 */
#define png_set_compression_method \
	(pngtclStubsPtr->png_set_compression_methodPtr) /* 73 */
#define png_init_io \
	(pngtclStubsPtr->png_init_ioPtr) /* 74 */
#define png_set_error_fn \
	(pngtclStubsPtr->png_set_error_fnPtr) /* 75 */
#define png_get_error_ptr \
	(pngtclStubsPtr->png_get_error_ptrPtr) /* 76 */
#define png_set_write_fn \
	(pngtclStubsPtr->png_set_write_fnPtr) /* 77 */
#define png_set_read_fn \
	(pngtclStubsPtr->png_set_read_fnPtr) /* 78 */
#define png_get_io_ptr \
	(pngtclStubsPtr->png_get_io_ptrPtr) /* 79 */
#define png_set_read_status_fn \
	(pngtclStubsPtr->png_set_read_status_fnPtr) /* 80 */
#define png_set_write_status_fn \
	(pngtclStubsPtr->png_set_write_status_fnPtr) /* 81 */
#define png_set_mem_fn \
	(pngtclStubsPtr->png_set_mem_fnPtr) /* 82 */
#define png_get_mem_ptr \
	(pngtclStubsPtr->png_get_mem_ptrPtr) /* 83 */
#define png_set_read_user_transform_fn \
	(pngtclStubsPtr->png_set_read_user_transform_fnPtr) /* 84 */
#define png_set_write_user_transform_fn \
	(pngtclStubsPtr->png_set_write_user_transform_fnPtr) /* 85 */
#define png_set_user_transform_info \
	(pngtclStubsPtr->png_set_user_transform_infoPtr) /* 86 */
#define png_get_user_transform_ptr \
	(pngtclStubsPtr->png_get_user_transform_ptrPtr) /* 87 */
#define png_set_read_user_chunk_fn \
	(pngtclStubsPtr->png_set_read_user_chunk_fnPtr) /* 88 */
#define png_get_user_chunk_ptr \
	(pngtclStubsPtr->png_get_user_chunk_ptrPtr) /* 89 */
#define png_set_progressive_read_fn \
	(pngtclStubsPtr->png_set_progressive_read_fnPtr) /* 90 */
#define png_get_progressive_ptr \
	(pngtclStubsPtr->png_get_progressive_ptrPtr) /* 91 */
#define png_process_data \
	(pngtclStubsPtr->png_process_dataPtr) /* 92 */
#define png_progressive_combine_row \
	(pngtclStubsPtr->png_progressive_combine_rowPtr) /* 93 */
#define png_malloc \
	(pngtclStubsPtr->png_mallocPtr) /* 94 */
#define png_free \
	(pngtclStubsPtr->png_freePtr) /* 95 */
#define png_free_data \
	(pngtclStubsPtr->png_free_dataPtr) /* 96 */
/* Slot 97 is reserved */
/* Slot 98 is reserved */
/* Slot 99 is reserved */
/* Slot 100 is reserved */
/* Slot 101 is reserved */
#define png_far_to_near \
	(pngtclStubsPtr->png_far_to_nearPtr) /* 102 */
#define png_error \
	(pngtclStubsPtr->png_errorPtr) /* 103 */
#define png_chunk_error \
	(pngtclStubsPtr->png_chunk_errorPtr) /* 104 */
#define png_warning \
	(pngtclStubsPtr->png_warningPtr) /* 105 */
#define png_chunk_warning \
	(pngtclStubsPtr->png_chunk_warningPtr) /* 106 */
#define png_get_valid \
	(pngtclStubsPtr->png_get_validPtr) /* 107 */
#define png_get_rowbytes \
	(pngtclStubsPtr->png_get_rowbytesPtr) /* 108 */
#define png_get_rows \
	(pngtclStubsPtr->png_get_rowsPtr) /* 109 */
#define png_set_rows \
	(pngtclStubsPtr->png_set_rowsPtr) /* 110 */
#define png_get_channels \
	(pngtclStubsPtr->png_get_channelsPtr) /* 111 */
#define png_get_image_width \
	(pngtclStubsPtr->png_get_image_widthPtr) /* 112 */
#define png_get_image_height \
	(pngtclStubsPtr->png_get_image_heightPtr) /* 113 */
#define png_get_bit_depth \
	(pngtclStubsPtr->png_get_bit_depthPtr) /* 114 */
#define png_get_color_type \
	(pngtclStubsPtr->png_get_color_typePtr) /* 115 */
#define png_get_filter_type \
	(pngtclStubsPtr->png_get_filter_typePtr) /* 116 */
#define png_get_interlace_type \
	(pngtclStubsPtr->png_get_interlace_typePtr) /* 117 */
#define png_get_compression_type \
	(pngtclStubsPtr->png_get_compression_typePtr) /* 118 */
#define png_get_pixels_per_meter \
	(pngtclStubsPtr->png_get_pixels_per_meterPtr) /* 119 */
#define png_get_x_pixels_per_meter \
	(pngtclStubsPtr->png_get_x_pixels_per_meterPtr) /* 120 */
#define png_get_y_pixels_per_meter \
	(pngtclStubsPtr->png_get_y_pixels_per_meterPtr) /* 121 */
#define png_get_pixel_aspect_ratio \
	(pngtclStubsPtr->png_get_pixel_aspect_ratioPtr) /* 122 */
#define png_get_x_offset_pixels \
	(pngtclStubsPtr->png_get_x_offset_pixelsPtr) /* 123 */
#define png_get_y_offset_pixels \
	(pngtclStubsPtr->png_get_y_offset_pixelsPtr) /* 124 */
#define png_get_x_offset_microns \
	(pngtclStubsPtr->png_get_x_offset_micronsPtr) /* 125 */
#define png_get_y_offset_microns \
	(pngtclStubsPtr->png_get_y_offset_micronsPtr) /* 126 */
#define png_get_signature \
	(pngtclStubsPtr->png_get_signaturePtr) /* 127 */
#define png_get_bKGD \
	(pngtclStubsPtr->png_get_bKGDPtr) /* 128 */
#define png_set_bKGD \
	(pngtclStubsPtr->png_set_bKGDPtr) /* 129 */
#define png_get_cHRM \
	(pngtclStubsPtr->png_get_cHRMPtr) /* 130 */
#define png_get_cHRM_fixed \
	(pngtclStubsPtr->png_get_cHRM_fixedPtr) /* 131 */
#define png_set_cHRM \
	(pngtclStubsPtr->png_set_cHRMPtr) /* 132 */
#define png_set_cHRM_fixed \
	(pngtclStubsPtr->png_set_cHRM_fixedPtr) /* 133 */
#define png_get_gAMA \
	(pngtclStubsPtr->png_get_gAMAPtr) /* 134 */
#define png_get_gAMA_fixed \
	(pngtclStubsPtr->png_get_gAMA_fixedPtr) /* 135 */
#define png_set_gAMA \
	(pngtclStubsPtr->png_set_gAMAPtr) /* 136 */
#define png_set_gAMA_fixed \
	(pngtclStubsPtr->png_set_gAMA_fixedPtr) /* 137 */
#define png_get_hIST \
	(pngtclStubsPtr->png_get_hISTPtr) /* 138 */
#define png_set_hIST \
	(pngtclStubsPtr->png_set_hISTPtr) /* 139 */
#define png_get_IHDR \
	(pngtclStubsPtr->png_get_IHDRPtr) /* 140 */
#define png_set_IHDR \
	(pngtclStubsPtr->png_set_IHDRPtr) /* 141 */
#define png_get_oFFs \
	(pngtclStubsPtr->png_get_oFFsPtr) /* 142 */
#define png_set_oFFs \
	(pngtclStubsPtr->png_set_oFFsPtr) /* 143 */
#define png_get_pCAL \
	(pngtclStubsPtr->png_get_pCALPtr) /* 144 */
#define png_set_pCAL \
	(pngtclStubsPtr->png_set_pCALPtr) /* 145 */
#define png_get_pHYs \
	(pngtclStubsPtr->png_get_pHYsPtr) /* 146 */
#define png_set_pHYs \
	(pngtclStubsPtr->png_set_pHYsPtr) /* 147 */
#define png_get_PLTE \
	(pngtclStubsPtr->png_get_PLTEPtr) /* 148 */
#define png_set_PLTE \
	(pngtclStubsPtr->png_set_PLTEPtr) /* 149 */
#define png_get_sBIT \
	(pngtclStubsPtr->png_get_sBITPtr) /* 150 */
#define png_set_sBIT \
	(pngtclStubsPtr->png_set_sBITPtr) /* 151 */
#define png_get_sRGB \
	(pngtclStubsPtr->png_get_sRGBPtr) /* 152 */
#define png_set_sRGB \
	(pngtclStubsPtr->png_set_sRGBPtr) /* 153 */
#define png_set_sRGB_gAMA_and_cHRM \
	(pngtclStubsPtr->png_set_sRGB_gAMA_and_cHRMPtr) /* 154 */
#define png_get_iCCP \
	(pngtclStubsPtr->png_get_iCCPPtr) /* 155 */
#define png_set_iCCP \
	(pngtclStubsPtr->png_set_iCCPPtr) /* 156 */
#define png_get_sPLT \
	(pngtclStubsPtr->png_get_sPLTPtr) /* 157 */
#define png_set_sPLT \
	(pngtclStubsPtr->png_set_sPLTPtr) /* 158 */
#define png_get_text \
	(pngtclStubsPtr->png_get_textPtr) /* 159 */
#define png_set_text \
	(pngtclStubsPtr->png_set_textPtr) /* 160 */
#define png_get_tIME \
	(pngtclStubsPtr->png_get_tIMEPtr) /* 161 */
#define png_set_tIME \
	(pngtclStubsPtr->png_set_tIMEPtr) /* 162 */
#define png_get_tRNS \
	(pngtclStubsPtr->png_get_tRNSPtr) /* 163 */
#define png_set_tRNS \
	(pngtclStubsPtr->png_set_tRNSPtr) /* 164 */
#define png_get_sCAL \
	(pngtclStubsPtr->png_get_sCALPtr) /* 165 */
#define png_get_sCAL_s \
	(pngtclStubsPtr->png_get_sCAL_sPtr) /* 166 */
#define png_set_sCAL \
	(pngtclStubsPtr->png_set_sCALPtr) /* 167 */
#define png_set_sCAL_s \
	(pngtclStubsPtr->png_set_sCAL_sPtr) /* 168 */
#define png_set_keep_unknown_chunks \
	(pngtclStubsPtr->png_set_keep_unknown_chunksPtr) /* 169 */
#define png_set_unknown_chunks \
	(pngtclStubsPtr->png_set_unknown_chunksPtr) /* 170 */
#define png_set_unknown_chunk_location \
	(pngtclStubsPtr->png_set_unknown_chunk_locationPtr) /* 171 */
#define png_get_unknown_chunks \
	(pngtclStubsPtr->png_get_unknown_chunksPtr) /* 172 */
#define png_set_invalid \
	(pngtclStubsPtr->png_set_invalidPtr) /* 173 */
#define png_read_png \
	(pngtclStubsPtr->png_read_pngPtr) /* 174 */
#define png_write_png \
	(pngtclStubsPtr->png_write_pngPtr) /* 175 */
#define png_sig_bytes \
	(pngtclStubsPtr->png_sig_bytesPtr) /* 176 */
#define png_get_copyright \
	(pngtclStubsPtr->png_get_copyrightPtr) /* 177 */
#define png_get_header_ver \
	(pngtclStubsPtr->png_get_header_verPtr) /* 178 */
#define png_get_header_version \
	(pngtclStubsPtr->png_get_header_versionPtr) /* 179 */
#define png_get_libpng_ver \
	(pngtclStubsPtr->png_get_libpng_verPtr) /* 180 */
/* Slot 181 is reserved */
/* Slot 182 is reserved */
/* Slot 183 is reserved */
#define png_read_init \
	(pngtclStubsPtr->png_read_initPtr) /* 184 */
#define png_read_init_2 \
	(pngtclStubsPtr->png_read_init_2Ptr) /* 185 */
/* Slot 186 is reserved */
/* Slot 187 is reserved */
#define png_create_struct \
	(pngtclStubsPtr->png_create_structPtr) /* 188 */
#define png_destroy_struct \
	(pngtclStubsPtr->png_destroy_structPtr) /* 189 */
#define png_create_struct_2 \
	(pngtclStubsPtr->png_create_struct_2Ptr) /* 190 */
#define png_destroy_struct_2 \
	(pngtclStubsPtr->png_destroy_struct_2Ptr) /* 191 */
#define png_info_destroy \
	(pngtclStubsPtr->png_info_destroyPtr) /* 192 */
/* Slot 193 is reserved */
/* Slot 194 is reserved */
#define png_reset_crc \
	(pngtclStubsPtr->png_reset_crcPtr) /* 195 */
#define png_write_data \
	(pngtclStubsPtr->png_write_dataPtr) /* 196 */
#define png_read_data \
	(pngtclStubsPtr->png_read_dataPtr) /* 197 */
#define png_crc_read \
	(pngtclStubsPtr->png_crc_readPtr) /* 198 */
#define png_decompress_chunk \
	(pngtclStubsPtr->png_decompress_chunkPtr) /* 199 */
#define png_crc_finish \
	(pngtclStubsPtr->png_crc_finishPtr) /* 200 */
#define png_crc_error \
	(pngtclStubsPtr->png_crc_errorPtr) /* 201 */
#define png_calculate_crc \
	(pngtclStubsPtr->png_calculate_crcPtr) /* 202 */
#define png_flush \
	(pngtclStubsPtr->png_flushPtr) /* 203 */
#define png_save_uint_32 \
	(pngtclStubsPtr->png_save_uint_32Ptr) /* 204 */
#define png_save_int_32 \
	(pngtclStubsPtr->png_save_int_32Ptr) /* 205 */
#define png_save_uint_16 \
	(pngtclStubsPtr->png_save_uint_16Ptr) /* 206 */
#define png_write_sig \
	(pngtclStubsPtr->png_write_sigPtr) /* 207 */
#define png_write_IHDR \
	(pngtclStubsPtr->png_write_IHDRPtr) /* 208 */
#define png_write_PLTE \
	(pngtclStubsPtr->png_write_PLTEPtr) /* 209 */
#define png_write_IDAT \
	(pngtclStubsPtr->png_write_IDATPtr) /* 210 */
#define png_write_IEND \
	(pngtclStubsPtr->png_write_IENDPtr) /* 211 */
#define png_write_gAMA \
	(pngtclStubsPtr->png_write_gAMAPtr) /* 212 */
#define png_write_gAMA_fixed \
	(pngtclStubsPtr->png_write_gAMA_fixedPtr) /* 213 */
#define png_write_sBIT \
	(pngtclStubsPtr->png_write_sBITPtr) /* 214 */
#define png_write_cHRM \
	(pngtclStubsPtr->png_write_cHRMPtr) /* 215 */
#define png_write_cHRM_fixed \
	(pngtclStubsPtr->png_write_cHRM_fixedPtr) /* 216 */
#define png_write_sRGB \
	(pngtclStubsPtr->png_write_sRGBPtr) /* 217 */
#define png_write_iCCP \
	(pngtclStubsPtr->png_write_iCCPPtr) /* 218 */
#define png_write_sPLT \
	(pngtclStubsPtr->png_write_sPLTPtr) /* 219 */
#define png_write_tRNS \
	(pngtclStubsPtr->png_write_tRNSPtr) /* 220 */
#define png_write_bKGD \
	(pngtclStubsPtr->png_write_bKGDPtr) /* 221 */
#define png_write_hIST \
	(pngtclStubsPtr->png_write_hISTPtr) /* 222 */
#define png_check_keyword \
	(pngtclStubsPtr->png_check_keywordPtr) /* 223 */
#define png_write_tEXt \
	(pngtclStubsPtr->png_write_tEXtPtr) /* 224 */
#define png_write_zTXt \
	(pngtclStubsPtr->png_write_zTXtPtr) /* 225 */
#define png_write_iTXt \
	(pngtclStubsPtr->png_write_iTXtPtr) /* 226 */
#define png_write_oFFs \
	(pngtclStubsPtr->png_write_oFFsPtr) /* 227 */
#define png_write_pCAL \
	(pngtclStubsPtr->png_write_pCALPtr) /* 228 */
#define png_write_pHYs \
	(pngtclStubsPtr->png_write_pHYsPtr) /* 229 */
#define png_write_tIME \
	(pngtclStubsPtr->png_write_tIMEPtr) /* 230 */
#define png_write_sCAL \
	(pngtclStubsPtr->png_write_sCALPtr) /* 231 */
#define png_write_sCAL_s \
	(pngtclStubsPtr->png_write_sCAL_sPtr) /* 232 */
#define png_write_finish_row \
	(pngtclStubsPtr->png_write_finish_rowPtr) /* 233 */
#define png_write_start_row \
	(pngtclStubsPtr->png_write_start_rowPtr) /* 234 */
#define png_build_gamma_table \
	(pngtclStubsPtr->png_build_gamma_tablePtr) /* 235 */
#define png_combine_row \
	(pngtclStubsPtr->png_combine_rowPtr) /* 236 */
#define png_do_read_interlace \
	(pngtclStubsPtr->png_do_read_interlacePtr) /* 237 */
#define png_do_write_interlace \
	(pngtclStubsPtr->png_do_write_interlacePtr) /* 238 */
#define png_read_filter_row \
	(pngtclStubsPtr->png_read_filter_rowPtr) /* 239 */
#define png_write_find_filter \
	(pngtclStubsPtr->png_write_find_filterPtr) /* 240 */
#define png_write_filtered_row \
	(pngtclStubsPtr->png_write_filtered_rowPtr) /* 241 */
#define png_read_finish_row \
	(pngtclStubsPtr->png_read_finish_rowPtr) /* 242 */
#define png_read_start_row \
	(pngtclStubsPtr->png_read_start_rowPtr) /* 243 */
#define png_read_transform_info \
	(pngtclStubsPtr->png_read_transform_infoPtr) /* 244 */
#define png_do_read_filler \
	(pngtclStubsPtr->png_do_read_fillerPtr) /* 245 */
#define png_do_read_swap_alpha \
	(pngtclStubsPtr->png_do_read_swap_alphaPtr) /* 246 */
#define png_do_write_swap_alpha \
	(pngtclStubsPtr->png_do_write_swap_alphaPtr) /* 247 */
#define png_do_read_invert_alpha \
	(pngtclStubsPtr->png_do_read_invert_alphaPtr) /* 248 */
#define png_do_write_invert_alpha \
	(pngtclStubsPtr->png_do_write_invert_alphaPtr) /* 249 */
#define png_do_strip_filler \
	(pngtclStubsPtr->png_do_strip_fillerPtr) /* 250 */
#define png_do_swap \
	(pngtclStubsPtr->png_do_swapPtr) /* 251 */
#define png_do_packswap \
	(pngtclStubsPtr->png_do_packswapPtr) /* 252 */
#define png_do_rgb_to_gray \
	(pngtclStubsPtr->png_do_rgb_to_grayPtr) /* 253 */
#define png_do_gray_to_rgb \
	(pngtclStubsPtr->png_do_gray_to_rgbPtr) /* 254 */
#define png_do_unpack \
	(pngtclStubsPtr->png_do_unpackPtr) /* 255 */
#define png_do_unshift \
	(pngtclStubsPtr->png_do_unshiftPtr) /* 256 */
#define png_do_invert \
	(pngtclStubsPtr->png_do_invertPtr) /* 257 */
#define png_do_chop \
	(pngtclStubsPtr->png_do_chopPtr) /* 258 */
#define png_do_dither \
	(pngtclStubsPtr->png_do_ditherPtr) /* 259 */
#define png_correct_palette \
	(pngtclStubsPtr->png_correct_palettePtr) /* 260 */
#define png_do_bgr \
	(pngtclStubsPtr->png_do_bgrPtr) /* 261 */
#define png_do_pack \
	(pngtclStubsPtr->png_do_packPtr) /* 262 */
#define png_do_shift \
	(pngtclStubsPtr->png_do_shiftPtr) /* 263 */
#define png_do_background \
	(pngtclStubsPtr->png_do_backgroundPtr) /* 264 */
#define png_do_gamma \
	(pngtclStubsPtr->png_do_gammaPtr) /* 265 */
#define png_do_expand_palette \
	(pngtclStubsPtr->png_do_expand_palettePtr) /* 266 */
#define png_do_expand \
	(pngtclStubsPtr->png_do_expandPtr) /* 267 */
#define png_handle_IHDR \
	(pngtclStubsPtr->png_handle_IHDRPtr) /* 268 */
#define png_handle_PLTE \
	(pngtclStubsPtr->png_handle_PLTEPtr) /* 269 */
#define png_handle_IEND \
	(pngtclStubsPtr->png_handle_IENDPtr) /* 270 */
#define png_handle_bKGD \
	(pngtclStubsPtr->png_handle_bKGDPtr) /* 271 */
#define png_handle_cHRM \
	(pngtclStubsPtr->png_handle_cHRMPtr) /* 272 */
#define png_handle_gAMA \
	(pngtclStubsPtr->png_handle_gAMAPtr) /* 273 */
#define png_handle_hIST \
	(pngtclStubsPtr->png_handle_hISTPtr) /* 274 */
#define png_handle_iCCP \
	(pngtclStubsPtr->png_handle_iCCPPtr) /* 275 */
#define png_handle_iTXt \
	(pngtclStubsPtr->png_handle_iTXtPtr) /* 276 */
#define png_handle_oFFs \
	(pngtclStubsPtr->png_handle_oFFsPtr) /* 277 */
#define png_handle_pCAL \
	(pngtclStubsPtr->png_handle_pCALPtr) /* 278 */
#define png_handle_pHYs \
	(pngtclStubsPtr->png_handle_pHYsPtr) /* 279 */
#define png_handle_sBIT \
	(pngtclStubsPtr->png_handle_sBITPtr) /* 280 */
#define png_handle_sCAL \
	(pngtclStubsPtr->png_handle_sCALPtr) /* 281 */
#define png_handle_sPLT \
	(pngtclStubsPtr->png_handle_sPLTPtr) /* 282 */
#define png_handle_sRGB \
	(pngtclStubsPtr->png_handle_sRGBPtr) /* 283 */
#define png_handle_tEXt \
	(pngtclStubsPtr->png_handle_tEXtPtr) /* 284 */
#define png_handle_tIME \
	(pngtclStubsPtr->png_handle_tIMEPtr) /* 285 */
#define png_handle_tRNS \
	(pngtclStubsPtr->png_handle_tRNSPtr) /* 286 */
#define png_handle_zTXt \
	(pngtclStubsPtr->png_handle_zTXtPtr) /* 287 */
#define png_handle_as_unknown \
	(pngtclStubsPtr->png_handle_as_unknownPtr) /* 288 */
#define png_handle_unknown \
	(pngtclStubsPtr->png_handle_unknownPtr) /* 289 */
#define png_check_chunk_name \
	(pngtclStubsPtr->png_check_chunk_namePtr) /* 290 */
#define png_do_read_transformations \
	(pngtclStubsPtr->png_do_read_transformationsPtr) /* 291 */
#define png_do_write_transformations \
	(pngtclStubsPtr->png_do_write_transformationsPtr) /* 292 */
#define png_init_read_transformations \
	(pngtclStubsPtr->png_init_read_transformationsPtr) /* 293 */
#define png_push_read_chunk \
	(pngtclStubsPtr->png_push_read_chunkPtr) /* 294 */
#define png_push_read_sig \
	(pngtclStubsPtr->png_push_read_sigPtr) /* 295 */
#define png_push_check_crc \
	(pngtclStubsPtr->png_push_check_crcPtr) /* 296 */
#define png_push_crc_skip \
	(pngtclStubsPtr->png_push_crc_skipPtr) /* 297 */
#define png_push_crc_finish \
	(pngtclStubsPtr->png_push_crc_finishPtr) /* 298 */
#define png_push_fill_buffer \
	(pngtclStubsPtr->png_push_fill_bufferPtr) /* 299 */
#define png_push_save_buffer \
	(pngtclStubsPtr->png_push_save_bufferPtr) /* 300 */
#define png_push_restore_buffer \
	(pngtclStubsPtr->png_push_restore_bufferPtr) /* 301 */
#define png_push_read_IDAT \
	(pngtclStubsPtr->png_push_read_IDATPtr) /* 302 */
#define png_process_IDAT_data \
	(pngtclStubsPtr->png_process_IDAT_dataPtr) /* 303 */
#define png_push_process_row \
	(pngtclStubsPtr->png_push_process_rowPtr) /* 304 */
#define png_push_handle_unknown \
	(pngtclStubsPtr->png_push_handle_unknownPtr) /* 305 */
#define png_push_have_info \
	(pngtclStubsPtr->png_push_have_infoPtr) /* 306 */
#define png_push_have_end \
	(pngtclStubsPtr->png_push_have_endPtr) /* 307 */
#define png_push_have_row \
	(pngtclStubsPtr->png_push_have_rowPtr) /* 308 */
#define png_push_read_end \
	(pngtclStubsPtr->png_push_read_endPtr) /* 309 */
#define png_process_some_data \
	(pngtclStubsPtr->png_process_some_dataPtr) /* 310 */
#define png_read_push_finish_row \
	(pngtclStubsPtr->png_read_push_finish_rowPtr) /* 311 */
#define png_push_handle_tEXt \
	(pngtclStubsPtr->png_push_handle_tEXtPtr) /* 312 */
#define png_push_read_tEXt \
	(pngtclStubsPtr->png_push_read_tEXtPtr) /* 313 */
#define png_push_handle_zTXt \
	(pngtclStubsPtr->png_push_handle_zTXtPtr) /* 314 */
#define png_push_read_zTXt \
	(pngtclStubsPtr->png_push_read_zTXtPtr) /* 315 */
#define png_push_handle_iTXt \
	(pngtclStubsPtr->png_push_handle_iTXtPtr) /* 316 */
#define png_push_read_iTXt \
	(pngtclStubsPtr->png_push_read_iTXtPtr) /* 317 */
/* Slot 318 is reserved */
#define png_set_add_alpha \
	(pngtclStubsPtr->png_set_add_alphaPtr) /* 319 */
#define png_set_scale_16 \
	(pngtclStubsPtr->png_set_scale_16Ptr) /* 320 */

#endif /* defined(USE_PNGTCL_STUBS) */

/* !END!: Do not edit above this line. */

#undef png_info_init
#define png_info_init(info_ptr) png_info_init_3(&info_ptr,\
    png_sizeof(png_info));

#endif /* _PNGTCLDECLS */

