/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.export.legacy.BorderOffset;

public class EllipseDrawer
extends ElementDrawer {
    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) {
        JRPrintEllipse ellipse = (JRPrintEllipse)element;
        int width = ellipse.getWidth();
        int height = ellipse.getHeight();
        if (ellipse.getMode() == 1) {
            grx.setColor(ellipse.getBackcolor());
            grx.fillOval(ellipse.getX() + offsetX, ellipse.getY() + offsetY, width, height);
        }
        grx.setColor(ellipse.getLinePen().getLineColor());
        Stroke stroke = EllipseDrawer.getStroke(ellipse.getLinePen(), 2);
        if (stroke != null) {
            grx.setStroke(stroke);
            AffineTransform oldTx = grx.getTransform();
            if (ellipse.getLinePen().getLineStyle() == 3) {
                float lineWidth = ellipse.getLinePen().getLineWidth().floatValue();
                grx.translate((float)(ellipse.getX() + offsetX) - lineWidth / 3.0f, (float)(ellipse.getY() + offsetY) - lineWidth / 3.0f);
                grx.scale(((float)width + 2.0f * lineWidth / 3.0f) / (float)width, ((float)height + 2.0f * lineWidth / 3.0f) / (float)height);
                grx.drawOval(0, 0, width, height);
                grx.setTransform(oldTx);
                grx.translate((float)(ellipse.getX() + offsetX) + lineWidth / 3.0f, (float)(ellipse.getY() + offsetY) + lineWidth / 3.0f);
                if ((float)width > 2.0f * lineWidth / 3.0f) {
                    grx.scale(((float)width - 2.0f * lineWidth / 3.0f) / (float)width, 1.0);
                }
                if ((float)height > 2.0f * lineWidth / 3.0f) {
                    grx.scale(1.0, ((float)height - 2.0f * lineWidth / 3.0f) / (float)height);
                }
                grx.drawOval(0, 0, width, height);
            } else {
                float lineOffset = BorderOffset.getOffset(ellipse.getLinePen());
                grx.translate((float)(ellipse.getX() + offsetX) + lineOffset, (float)(ellipse.getY() + offsetY) + lineOffset);
                if ((float)width > 2.0f * lineOffset) {
                    grx.scale(((float)width - 2.0f * lineOffset) / (float)width, 1.0);
                }
                if ((float)height > 2.0f * lineOffset) {
                    grx.scale(1.0, ((float)height - 2.0f * lineOffset) / (float)height);
                }
                grx.drawOval(0, 0, width, height);
            }
            grx.setTransform(oldTx);
        }
    }
}

