/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.util.concurrent.Lock;
import ca.odell.glazedlists.util.concurrent.LockFactory;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugList<E>
extends AbstractEventList<E> {
    private boolean lockCheckingEnabled;
    private final Set<Thread> sanctionedReaderThreads = new HashSet<Thread>();
    private final Set<Thread> sanctionedWriterThreads = new HashSet<Thread>();
    private final EventList<E> delegate;
    private final DebugReadWriteLock debugReadWriteLock;

    public DebugList() {
        this(null, new DebugReadWriteLock());
    }

    private DebugList(ListEventPublisher publisher, DebugReadWriteLock debugReadWriteLock) {
        this.debugReadWriteLock = debugReadWriteLock;
        this.delegate = new BasicEventList(publisher, this.debugReadWriteLock);
        this.delegate.addListEventListener(new ListEventForwarder());
    }

    public boolean isLockCheckingEnabled() {
        return this.lockCheckingEnabled;
    }

    public void setLockCheckingEnabled(boolean lockCheckingEnabled) {
        this.lockCheckingEnabled = lockCheckingEnabled;
    }

    public Set<Thread> getSanctionedReaderThreads() {
        return this.sanctionedReaderThreads;
    }

    public Set<Thread> getSanctionedWriterThreads() {
        return this.sanctionedWriterThreads;
    }

    public <E> DebugList<E> createNewDebugList() {
        return new DebugList<E>(this.getPublisher(), this.debugReadWriteLock);
    }

    protected void beforeReadOperation() {
        if (!this.sanctionedReaderThreads.isEmpty() && !this.sanctionedReaderThreads.contains(Thread.currentThread())) {
            throw new IllegalStateException("DebugList detected an unexpected Thread (" + Thread.currentThread() + ") attempting to perform a read operation");
        }
        if (this.isLockCheckingEnabled() && !this.debugReadWriteLock.isThreadHoldingReadOrWriteLock()) {
            throw new IllegalStateException("DebugList detected a failure to acquire the readLock prior to a read operation");
        }
    }

    protected void afterReadOperation() {
    }

    protected void beforeWriteOperation() {
        if (!this.sanctionedWriterThreads.isEmpty() && !this.sanctionedWriterThreads.contains(Thread.currentThread())) {
            throw new IllegalStateException("DebugList detected an unexpected Thread (" + Thread.currentThread() + ") attempting to perform a write operation");
        }
        if (this.isLockCheckingEnabled() && !this.debugReadWriteLock.isThreadHoldingWriteLock()) {
            throw new IllegalStateException("DebugList detected a failure to acquire the writeLock prior to a write operation");
        }
    }

    protected void afterWriteOperation() {
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.delegate.getReadWriteLock();
    }

    @Override
    public ListEventPublisher getPublisher() {
        return this.delegate.getPublisher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        this.beforeReadOperation();
        try {
            Object e = this.delegate.get(index);
            return e;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.beforeReadOperation();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.contains(object);
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.containsAll(collection);
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.equals(object);
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this.beforeReadOperation();
        try {
            int n = this.delegate.hashCode();
            return n;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object object) {
        this.beforeReadOperation();
        try {
            int n = this.delegate.indexOf(object);
            return n;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object object) {
        this.beforeReadOperation();
        try {
            int n = this.delegate.lastIndexOf(object);
            return n;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.beforeReadOperation();
        try {
            Object[] objectArray = this.delegate.toArray();
            return objectArray;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] array) {
        this.beforeReadOperation();
        try {
            T[] TArray = this.delegate.toArray(array);
            return TArray;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.beforeReadOperation();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E value) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.add(value);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object toRemove) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.remove(toRemove);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> values) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.addAll(values);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> values) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.addAll(index, values);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> values) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.removeAll(values);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> values) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.retainAll(values);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.beforeWriteOperation();
        try {
            this.delegate.clear();
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E value) {
        this.beforeWriteOperation();
        try {
            E e = this.delegate.set(index, value);
            return e;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E value) {
        this.beforeWriteOperation();
        try {
            this.delegate.add(index, value);
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        this.beforeWriteOperation();
        try {
            Object e = this.delegate.remove(index);
            return e;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    private static class DebugReadWriteLock
    implements ReadWriteLock {
        private final DebugLock readLock;
        private final DebugLock writeLock;

        public DebugReadWriteLock() {
            ReadWriteLock decorated = LockFactory.DEFAULT.createReadWriteLock();
            this.readLock = new DebugLock(decorated.readLock());
            this.writeLock = new DebugLock(decorated.writeLock());
        }

        public Lock readLock() {
            return this.readLock;
        }

        public Lock writeLock() {
            return this.writeLock;
        }

        public boolean isThreadHoldingWriteLock() {
            return this.writeLock.getThreadsHoldingLock().contains(Thread.currentThread());
        }

        public boolean isThreadHoldingReadOrWriteLock() {
            return this.readLock.getThreadsHoldingLock().contains(Thread.currentThread()) || this.writeLock.getThreadsHoldingLock().contains(Thread.currentThread());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DebugLock
        implements Lock {
            private final Lock delegate;
            private final List<Thread> threadsHoldingLock = new ArrayList<Thread>();

            public DebugLock(Lock delegate) {
                this.delegate = delegate;
            }

            @Override
            public void lock() {
                this.delegate.lock();
                this.threadsHoldingLock.add(Thread.currentThread());
            }

            @Override
            public boolean tryLock() {
                boolean success = this.delegate.tryLock();
                if (success) {
                    this.threadsHoldingLock.add(Thread.currentThread());
                }
                return success;
            }

            @Override
            public void unlock() {
                this.delegate.unlock();
                this.threadsHoldingLock.remove(Thread.currentThread());
            }

            public List<Thread> getThreadsHoldingLock() {
                return this.threadsHoldingLock;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListEventForwarder
    implements ListEventListener<E> {
        private ListEventForwarder() {
        }

        @Override
        public void listChanged(ListEvent<E> listChanges) {
            DebugList.this.updates.forwardEvent(listChanges);
        }
    }
}

